/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.core.gui.GuiUtil;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.render.TextureManager;
import forestry.core.tiles.EscritoireGame;
import forestry.core.tiles.EscritoireGameToken;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class GameTokenWidget
extends Widget {
    private final ItemStack HIDDEN_TOKEN = new ItemStack(Items.field_151122_aG);
    private final EscritoireGame game;
    private final int index;

    public GameTokenWidget(EscritoireGame game, WidgetManager manager, int xPos, int yPos, int index) {
        super(manager, xPos, yPos);
        this.game = game;
        this.index = index;
    }

    private EscritoireGameToken getToken() {
        return this.game.getToken(this.index);
    }

    @Override
    public void draw(int startX, int startY) {
        EscritoireGameToken token = this.getToken();
        if (token == null) {
            return;
        }
        int tokenColour = token.getTokenColour();
        float colorR = (float)(tokenColour >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(tokenColour >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(tokenColour & 0xFF) / 255.0f;
        Proxies.render.bindTexture(this.manager.gui.textureFile);
        GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        this.manager.gui.func_73729_b(startX + this.xPos, startY + this.yPos, 228, 0, 22, 22);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack tokenStack = this.HIDDEN_TOKEN;
        if (token.isVisible()) {
            tokenStack = token.getTokenStack();
        }
        GuiUtil.drawItemStack(this.manager.gui, tokenStack, startX + this.xPos + 3, startY + this.yPos + 3);
        this.manager.gui.setZLevel(150.0f);
        for (String ident : this.getToken().getOverlayIcons()) {
            RenderHelper.func_74520_c();
            Proxies.render.bindTexture(SpriteSheet.ITEMS);
            IIcon icon = TextureManager.getInstance().getDefault(ident);
            this.manager.gui.func_94065_a(startX + this.xPos + 3, startY + this.yPos + 3, icon, 16, 16);
            RenderHelper.func_74518_a();
        }
        this.manager.gui.setZLevel(0.0f);
    }

    @Override
    protected String getLegacyTooltip(EntityPlayer player) {
        EscritoireGameToken token = this.getToken();
        if (token == null || !token.isVisible()) {
            return null;
        }
        return token.getTooltip();
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        Proxies.net.sendToServer(new PacketGuiSelectRequest(this.index, 0));
    }
}

