/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class AbstractWidget<P extends AbstractWidget>
implements Widget<P> {
    protected Rectangle bounds;
    protected int desiredWidth = -1;
    protected int desiredHeight = -1;
    protected Minecraft mc;
    protected Gui gui;
    private LayoutHint layoutHint = null;
    private boolean enabled = true;
    private boolean hovering = false;
    protected boolean visible = true;
    protected List<String> tooltips = null;
    private boolean layoutDirty = true;
    private Object userObject = null;
    private ResourceLocation background1 = null;
    private ResourceLocation background2 = null;
    private boolean background2Horizontal = true;
    private int backgroundOffset = 256;
    private int filledRectThickness = 0;
    private int filledBackground = -1;
    private int filledBackground2 = -1;

    protected AbstractWidget(Minecraft mc, Gui gui) {
        this.mc = mc;
        this.gui = gui;
    }

    protected void drawBox(int xx, int yy, int color) {
        Gui.func_73734_a((int)xx, (int)yy, (int)xx, (int)(yy + this.bounds.height), (int)color);
        Gui.func_73734_a((int)(xx + this.bounds.width), (int)yy, (int)(xx + this.bounds.width), (int)(yy + this.bounds.height), (int)color);
        Gui.func_73734_a((int)xx, (int)yy, (int)(xx + this.bounds.width), (int)yy, (int)color);
        Gui.func_73734_a((int)xx, (int)(yy + this.bounds.height), (int)(xx + this.bounds.width), (int)(yy + this.bounds.height), (int)color);
    }

    @Override
    public Widget getWidgetAtPosition(int x, int y) {
        return this;
    }

    @Override
    public P setTooltips(String ... tooltips) {
        if (tooltips.length > 0) {
            this.tooltips = new ArrayList<String>();
            for (String s : tooltips) {
                this.tooltips.add(s);
            }
        } else {
            this.tooltips = null;
        }
        return (P)this;
    }

    @Override
    public List<String> getTooltips() {
        return this.tooltips;
    }

    @Override
    public boolean isHovering() {
        return this.hovering;
    }

    @Override
    public P setHovering(boolean hovering) {
        this.hovering = hovering;
        return (P)this;
    }

    @Override
    public P setEnabled(boolean enabled) {
        this.enabled = enabled;
        return (P)this;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isEnabledAndVisible() {
        return this.enabled && this.visible;
    }

    @Override
    public P setVisible(boolean visible) {
        this.visible = visible;
        return (P)this;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public int getDesiredSize(Widget.Dimension dimension) {
        if (dimension == Widget.Dimension.DIMENSION_WIDTH) {
            return this.getDesiredWidth();
        }
        return this.getDesiredHeight();
    }

    @Override
    public int getDesiredWidth() {
        return this.desiredWidth;
    }

    @Override
    public P setDesiredWidth(int desiredWidth) {
        this.desiredWidth = desiredWidth;
        return (P)this;
    }

    @Override
    public int getDesiredHeight() {
        return this.desiredHeight;
    }

    @Override
    public P setDesiredHeight(int desiredHeight) {
        this.desiredHeight = desiredHeight;
        return (P)this;
    }

    public P setBackground(ResourceLocation bg) {
        return this.setBackgrounds(bg, null);
    }

    public P setBackgrounds(ResourceLocation bg1, ResourceLocation bg2) {
        this.background1 = bg1;
        this.background2 = bg2;
        this.background2Horizontal = true;
        this.backgroundOffset = 256;
        return (P)this;
    }

    public P setBackgroundLayout(boolean horizontal, int offset) {
        this.background2Horizontal = horizontal;
        this.backgroundOffset = offset;
        return (P)this;
    }

    public P setFilledRectThickness(int thickness) {
        this.filledRectThickness = thickness;
        return (P)this;
    }

    public int getFilledBackground() {
        return this.filledBackground;
    }

    public int getFilledBackground2() {
        return this.filledBackground2;
    }

    public P setFilledBackground(int filledBackground) {
        this.filledBackground = filledBackground;
        this.filledBackground2 = -1;
        return (P)this;
    }

    public P setFilledBackground(int filledBackground, int filledBackground2) {
        this.filledBackground = filledBackground;
        this.filledBackground2 = filledBackground2;
        return (P)this;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public boolean in(int x, int y) {
        if (this.bounds == null) {
            return false;
        }
        return this.bounds.contains(x, y);
    }

    protected void drawBackground(int x, int y) {
        if (!this.visible) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        if (this.background1 != null) {
            this.mc.func_110434_K().func_110577_a(this.background1);
            if (this.background2 == null) {
                this.gui.func_73729_b(xx, yy, 0, 0, this.bounds.width, this.bounds.height);
            } else if (this.background2Horizontal) {
                this.gui.func_73729_b(xx, yy, 0, 0, this.backgroundOffset, this.bounds.height);
                this.mc.func_110434_K().func_110577_a(this.background2);
                this.gui.func_73729_b(xx + this.backgroundOffset, yy, 0, 0, this.bounds.width - this.backgroundOffset, this.bounds.height);
            } else {
                this.gui.func_73729_b(xx, yy, 0, 0, this.bounds.width, this.backgroundOffset);
                this.mc.func_110434_K().func_110577_a(this.background2);
                this.gui.func_73729_b(xx, yy + this.backgroundOffset, 0, 0, this.bounds.width, this.bounds.height - this.backgroundOffset);
            }
        } else if (this.filledRectThickness > 0) {
            RenderHelper.drawThickBeveledBox(xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1, this.filledRectThickness, StyleConfig.colorBackgroundBevelBright, StyleConfig.colorBackgroundBevelDark, this.filledBackground == -1 ? StyleConfig.colorBackgroundFiller : this.filledBackground);
        } else if (this.filledRectThickness < 0) {
            RenderHelper.drawThickBeveledBox(xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1, -this.filledRectThickness, StyleConfig.colorBackgroundBevelDark, StyleConfig.colorBackgroundBevelBright, this.filledBackground == -1 ? StyleConfig.colorBackgroundFiller : this.filledBackground);
        } else if (this.filledBackground != -1) {
            RenderHelper.drawHorizontalGradientRect(xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1, this.filledBackground, this.filledBackground2 == -1 ? this.filledBackground : this.filledBackground2);
        }
    }

    protected void drawStyledBoxNormal(Window window, int x1, int y1, int x2, int y2) {
        this.drawStyledBox(window, x1, y1, x2, y2, StyleConfig.colorButtonBorderTopLeft, StyleConfig.colorButtonFiller, StyleConfig.colorButtonFillerGradient1, StyleConfig.colorButtonFillerGradient2, StyleConfig.colorButtonBorderBottomRight);
    }

    protected void drawStyledBoxNormal(Window window, int x1, int y1, int x2, int y2, int averageOverride) {
        this.drawStyledBox(window, x1, y1, x2, y2, StyleConfig.colorButtonBorderTopLeft, averageOverride, averageOverride, averageOverride, StyleConfig.colorButtonBorderBottomRight);
    }

    protected void drawStyledBoxSelected(Window window, int x1, int y1, int x2, int y2) {
        this.drawStyledBox(window, x1, y1, x2, y2, StyleConfig.colorButtonSelectedBorderTopLeft, StyleConfig.colorButtonSelectedFiller, StyleConfig.colorButtonSelectedFillerGradient1, StyleConfig.colorButtonSelectedFillerGradient2, StyleConfig.colorButtonSelectedBorderBottomRight);
    }

    protected void drawStyledBoxHovering(Window window, int x1, int y1, int x2, int y2) {
        this.drawStyledBox(window, x1, y1, x2, y2, StyleConfig.colorButtonHoveringBorderTopLeft, StyleConfig.colorButtonHoveringFiller, StyleConfig.colorButtonHoveringFillerGradient1, StyleConfig.colorButtonHoveringFillerGradient2, StyleConfig.colorButtonHoveringBorderBottomRight);
    }

    protected void drawStyledBoxDisabled(Window window, int x1, int y1, int x2, int y2) {
        this.drawStyledBox(window, x1, y1, x2, y2, StyleConfig.colorButtonDisabledBorderTopLeft, StyleConfig.colorButtonDisabledFiller, StyleConfig.colorButtonDisabledFillerGradient1, StyleConfig.colorButtonDisabledFillerGradient2, StyleConfig.colorButtonDisabledBorderBottomRight);
    }

    private void drawStyledBox(Window window, int x1, int y1, int x2, int y2, int bright, int average, int average1, int average2, int dark) {
        switch (window.getCurrentStyle()) {
            case STYLE_BEVEL: {
                RenderHelper.drawThinButtonBox(x1, y1, x2, y2, bright, average, dark);
                break;
            }
            case STYLE_BEVEL_GRADIENT: {
                RenderHelper.drawThinButtonBoxGradient(x1, y1, x2, y2, bright, average1, average2, dark);
                break;
            }
            case STYLE_FLAT: {
                RenderHelper.drawFlatButtonBox(x1, y1, x2, y2, bright, average, dark);
                break;
            }
            case STYLE_FLAT_GRADIENT: {
                RenderHelper.drawFlatButtonBoxGradient(x1, y1, x2, y2, bright, average1, average2, dark);
                break;
            }
            case STYLE_THICK: {
                RenderHelper.drawThickButtonBox(x1, y1, x2, y2, bright, average, dark);
            }
        }
    }

    @Override
    public void draw(Window window, int x, int y) {
        this.drawBackground(x, y);
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        return null;
    }

    @Override
    public void mouseRelease(int x, int y, int button) {
    }

    @Override
    public void mouseMove(int x, int y) {
    }

    @Override
    public boolean mouseWheel(int amount, int x, int y) {
        return false;
    }

    @Override
    public boolean keyTyped(Window window, char typedChar, int keyCode) {
        return false;
    }

    void markDirty() {
        this.layoutDirty = true;
    }

    void markClean() {
        this.layoutDirty = false;
    }

    boolean isDirty() {
        return this.layoutDirty;
    }

    @Override
    public P setLayoutHint(LayoutHint hint) {
        this.layoutHint = hint;
        this.layoutDirty = true;
        return (P)this;
    }

    @Override
    public LayoutHint getLayoutHint() {
        return this.layoutHint;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public P setUserObject(Object obj) {
        this.userObject = obj;
        return (P)this;
    }
}

