/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockTools {
    private static final Random random = new Random();
    public static final int MASK_ORIENTATION = 7;
    public static final int MASK_REDSTONE = 8;
    public static final int MASK_ORIENTATION_HORIZONTAL = 3;
    public static final int MASK_REDSTONE_IN = 8;
    public static final int MASK_REDSTONE_OUT = 4;
    public static final int MASK_STATE = 12;

    public static ForgeDirection getOrientation(int metadata) {
        return ForgeDirection.getOrientation((int)(metadata & 7));
    }

    public static ForgeDirection reorient(ForgeDirection side, int meta) {
        return BlockTools.reorient(side, BlockTools.getOrientation(meta));
    }

    public static ForgeDirection reorientHoriz(ForgeDirection side, int meta) {
        return BlockTools.reorient(side, BlockTools.getOrientationHoriz(meta));
    }

    public static ForgeDirection reorient(ForgeDirection side, ForgeDirection blockDirection) {
        switch (blockDirection) {
            case DOWN: {
                switch (side) {
                    case DOWN: {
                        return ForgeDirection.SOUTH;
                    }
                    case UP: {
                        return ForgeDirection.NORTH;
                    }
                    case NORTH: {
                        return ForgeDirection.UP;
                    }
                    case SOUTH: {
                        return ForgeDirection.DOWN;
                    }
                    case WEST: {
                        return ForgeDirection.EAST;
                    }
                    case EAST: {
                        return ForgeDirection.WEST;
                    }
                    case UNKNOWN: {
                        return side;
                    }
                }
            }
            case UP: {
                switch (side) {
                    case DOWN: {
                        return ForgeDirection.NORTH;
                    }
                    case UP: {
                        return ForgeDirection.SOUTH;
                    }
                    case NORTH: {
                        return ForgeDirection.UP;
                    }
                    case SOUTH: {
                        return ForgeDirection.DOWN;
                    }
                    case WEST: {
                        return ForgeDirection.WEST;
                    }
                    case EAST: {
                        return ForgeDirection.EAST;
                    }
                    case UNKNOWN: {
                        return side;
                    }
                }
            }
            case NORTH: {
                if (side == ForgeDirection.DOWN || side == ForgeDirection.UP) {
                    return side;
                }
                return side.getOpposite();
            }
            case SOUTH: {
                return side;
            }
            case WEST: {
                if (side == ForgeDirection.DOWN || side == ForgeDirection.UP) {
                    return side;
                }
                if (side == ForgeDirection.WEST) {
                    return ForgeDirection.SOUTH;
                }
                if (side == ForgeDirection.NORTH) {
                    return ForgeDirection.WEST;
                }
                if (side == ForgeDirection.EAST) {
                    return ForgeDirection.NORTH;
                }
                return ForgeDirection.EAST;
            }
            case EAST: {
                if (side == ForgeDirection.DOWN || side == ForgeDirection.UP) {
                    return side;
                }
                if (side == ForgeDirection.WEST) {
                    return ForgeDirection.NORTH;
                }
                if (side == ForgeDirection.NORTH) {
                    return ForgeDirection.EAST;
                }
                if (side == ForgeDirection.EAST) {
                    return ForgeDirection.SOUTH;
                }
                return ForgeDirection.WEST;
            }
            case UNKNOWN: {
                return side;
            }
        }
        return side;
    }

    public static ForgeDirection getTopDirection(ForgeDirection direction) {
        switch (direction) {
            case DOWN: {
                return ForgeDirection.SOUTH;
            }
            case UP: {
                return ForgeDirection.NORTH;
            }
        }
        return ForgeDirection.UP;
    }

    public static ForgeDirection getBottomDirection(ForgeDirection direction) {
        switch (direction) {
            case DOWN: {
                return ForgeDirection.NORTH;
            }
            case UP: {
                return ForgeDirection.SOUTH;
            }
        }
        return ForgeDirection.DOWN;
    }

    public static int setOrientation(int metadata, ForgeDirection orientation) {
        return metadata & 0xFFFFFFF8 | orientation.ordinal();
    }

    public static ForgeDirection getOrientationHoriz(int metadata) {
        return ForgeDirection.getOrientation((int)((metadata & 3) + 2));
    }

    public static int setOrientationHoriz(int metadata, ForgeDirection orientation) {
        return metadata & 0xFFFFFFFC | orientation.ordinal() - 2;
    }

    public static boolean getRedstoneSignal(int metadata) {
        return (metadata & 8) != 0;
    }

    public static int setRedstoneSignal(int metadata, boolean signal) {
        if (signal) {
            return metadata | 8;
        }
        return metadata & 0xFFFFFFF7;
    }

    public static boolean getRedstoneSignalIn(int metadata) {
        return (metadata & 8) != 0;
    }

    public static int setRedstoneSignalIn(int metadata, boolean signal) {
        if (signal) {
            return metadata | 8;
        }
        return metadata & 0xFFFFFFF7;
    }

    public static boolean getRedstoneSignalOut(int metadata) {
        return (metadata & 4) != 0;
    }

    public static int setRedstoneSignalOut(int metadata, boolean signal) {
        if (signal) {
            return metadata | 4;
        }
        return metadata & 0xFFFFFFFB;
    }

    public static int setState(int metadata, int value) {
        return metadata & 0xFFFFFFF3 | value << 2;
    }

    public static int getState(int metadata) {
        return (metadata & 0xC) >> 2;
    }

    public static ForgeDirection determineOrientation(int x, int y, int z, EntityLivingBase entityLivingBase) {
        int l;
        if (MathHelper.func_76135_e((float)((float)entityLivingBase.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entityLivingBase.field_70161_v - (float)z)) < 2.0f) {
            double d0 = entityLivingBase.field_70163_u + 1.82 - (double)entityLivingBase.field_70129_M;
            if (d0 - (double)y > 2.0) {
                return ForgeDirection.UP;
            }
            if ((double)y - d0 > 0.0) {
                return ForgeDirection.DOWN;
            }
        }
        return (l = MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? ForgeDirection.NORTH : (l == 1 ? ForgeDirection.EAST : (l == 2 ? ForgeDirection.SOUTH : (l == 3 ? ForgeDirection.WEST : ForgeDirection.DOWN)));
    }

    public static ForgeDirection determineOrientationHoriz(EntityLivingBase entityLivingBase) {
        int l = MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        return l == 0 ? ForgeDirection.NORTH : (l == 1 ? ForgeDirection.EAST : (l == 2 ? ForgeDirection.SOUTH : (l == 3 ? ForgeDirection.WEST : ForgeDirection.DOWN)));
    }

    public static void emptyInventoryInWorld(World world, int x, int y, int z, Block block, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            BlockTools.spawnItemStack(world, x, y, z, itemstack);
            inventory.func_70299_a(i, null);
        }
        world.func_147453_f(x, y, z, block);
    }

    public static void spawnItemStack(World world, int x, int y, int z, ItemStack itemstack) {
        if (itemstack != null) {
            float f = random.nextFloat() * 0.8f + 0.1f;
            float f1 = random.nextFloat() * 0.8f + 0.1f;
            float f2 = random.nextFloat() * 0.8f + 0.1f;
            while (itemstack.field_77994_a > 0) {
                int j = random.nextInt(21) + 10;
                if (j > itemstack.field_77994_a) {
                    j = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= j;
                EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j, itemstack.func_77960_j()));
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)random.nextGaussian() * f3;
                entityitem.field_70181_x = (float)random.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)random.nextGaussian() * f3;
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                }
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public static Block getBlock(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            return ((ItemBlock)stack.func_77973_b()).field_150939_a;
        }
        return null;
    }
}

