/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.ByteBufConverter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class Coordinate
implements ByteBufConverter {
    private final int x;
    private final int y;
    private final int z;
    public static final Coordinate INVALID = new Coordinate(-1, -1, -1);

    public Coordinate(ByteBuf buf) {
        this(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public Coordinate(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float squaredDistance(Coordinate c) {
        return (c.x - this.x) * (c.x - this.x) + (c.y - this.y) * (c.y - this.y) + (c.z - this.z) * (c.z - this.z);
    }

    public float squaredDistance(int x1, int y1, int z1) {
        return (x1 - this.x) * (x1 - this.x) + (y1 - this.y) * (y1 - this.y) + (z1 - this.z) * (z1 - this.z);
    }

    public static int area(Coordinate c1, Coordinate c2) {
        return (c2.getX() - c1.getX() + 1) * (c2.getY() - c1.getY() + 1) * (c2.getZ() - c1.getZ() + 1);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public boolean isValid() {
        return this.y >= 0;
    }

    public Coordinate addDirection(ForgeDirection direction) {
        return new Coordinate(this.x + direction.offsetX, this.y + direction.offsetY, this.z + direction.offsetZ);
    }

    public static Coordinate center(Coordinate c1, Coordinate c2) {
        return new Coordinate((c1.getX() + c2.getX()) / 2, (c1.getY() + c2.getY()) / 2, (c1.getZ() + c2.getZ()) / 2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coordinate that = (Coordinate)o;
        if (this.x != that.x) {
            return false;
        }
        if (this.y != that.y) {
            return false;
        }
        return this.z == that.z;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.z;
    }

    public static Coordinate readFromNBT(NBTTagCompound tagCompound, String tagName) {
        int[] array = tagCompound.func_74759_k(tagName);
        if (array.length == 0) {
            return null;
        }
        return new Coordinate(array[0], array[1], array[2]);
    }

    public static void writeToNBT(NBTTagCompound tagCompound, String tagName, Coordinate coordinate) {
        if (coordinate == null) {
            tagCompound.func_74783_a(tagName, new int[0]);
        } else {
            tagCompound.func_74783_a(tagName, new int[]{coordinate.getX(), coordinate.getY(), coordinate.getZ()});
        }
    }

    public static NBTTagCompound writeToNBT(Coordinate coordinate) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        Coordinate.writeToNBT(tagCompound, "c", coordinate);
        return tagCompound;
    }
}

