/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimletconstruction;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import java.util.List;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.dimletconstruction.DimletConstructionConfiguration;
import mcjty.rftools.blocks.dimletconstruction.TimeAbsorberTileEntity;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

@Optional.InterfaceList(value={@Optional.Interface(iface="crazypants.enderio.api.redstone.IRedstoneConnectable", modid="EnderIO")})
public class TimeAbsorberBlock
extends GenericRFToolsBlock
implements IRedstoneConnectable {
    public TimeAbsorberBlock() {
        super(Material.field_151573_f, TimeAbsorberTileEntity.class, false);
        this.func_149663_c("timeAbsorberBlock");
        this.func_149647_a(RFTools.tabRfTools);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkRedstone(world, x, y, z);
    }

    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, ForgeDirection from) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof TimeAbsorberTileEntity) {
            TimeAbsorberTileEntity timeAbsorberTileEntity = (TimeAbsorberTileEntity)te;
            float angle = timeAbsorberTileEntity.getAngle();
            if (angle >= -0.01f) {
                DimletKey key = TimeAbsorberTileEntity.findBestTimeDimlet(angle);
                String name = KnownDimletConfiguration.idToDisplayName.get(key);
                if (name == null) {
                    name = "<unknown>";
                }
                int absorbing = timeAbsorberTileEntity.getAbsorbing();
                int pct = (DimletConstructionConfiguration.maxTimeAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxTimeAbsorbtion;
                currenttip.add(EnumChatFormatting.GREEN + "Dimlet: " + name + " (" + angle + ", " + pct + "%)");
            } else {
                currenttip.add(EnumChatFormatting.GREEN + "Give this block a redstone signal");
                currenttip.add(EnumChatFormatting.GREEN + "at the right time you want to absorb");
            }
        }
        return currenttip;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("angle") && tagCompound.func_74760_g("angle") > -0.001f) {
            float angle = tagCompound.func_74760_g("angle");
            DimletKey key = TimeAbsorberTileEntity.findBestTimeDimlet(angle);
            String name = KnownDimletConfiguration.idToDisplayName.get(key);
            if (name == null) {
                name = "<unknown>";
            }
            list.add(EnumChatFormatting.GREEN + "Dimlet: " + name + " (" + angle + ")");
            int absorbing = tagCompound.func_74762_e("absorbing");
            int pct = (DimletConstructionConfiguration.maxTimeAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxTimeAbsorbtion;
            list.add(EnumChatFormatting.GREEN + "Absorbed: " + pct + "%");
            int timeout = tagCompound.func_74762_e("registerTimeout");
            list.add(EnumChatFormatting.GREEN + "Timeout: " + timeout);
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "Place this block outside and give it a redstone");
            list.add(EnumChatFormatting.WHITE + "signal around the time that you want to absorb.");
            list.add(EnumChatFormatting.WHITE + "You can use the end result in the Dimlet Workbench.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.iconSide = iconRegister.func_94245_a("rftools:" + this.getSideIconName());
    }

    public String getSideIconName() {
        return "timeAbsorber";
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149701_w() {
        return 0;
    }

    public int getGuiID() {
        return -1;
    }
}

