/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimlets;

import java.util.ArrayList;
import java.util.Map;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.dimlets.DimensionEnscriberContainer;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.blocks.dimlets.DimletSetup;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.rftools.dimension.description.DimensionDescriptor;
import mcjty.rftools.dimension.world.types.SpecialType;
import mcjty.rftools.items.dimlets.DimletEntry;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletObjectMapping;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class DimensionEnscriberTileEntity
extends GenericTileEntity
implements ISidedInventory {
    public static final String CMD_STORE = "store";
    public static final String CMD_EXTRACT = "extract";
    public static final String CMD_SETNAME = "setName";
    private boolean tabSlotHasChanged = false;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, DimensionEnscriberContainer.factory, 92);

    public int[] func_94128_d(int side) {
        return DimensionEnscriberContainer.factory.getAccessibleSlots();
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        return DimensionEnscriberContainer.factory.isInputSlot(index);
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return DimensionEnscriberContainer.factory.isOutputSlot(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Enscriber Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    private void storeDimlets(EntityPlayerMP player) {
        if (DimletConfiguration.ownerDimletsNeeded && this.checkOwnerDimlet()) {
            Logging.warn((EntityPlayer)player, (String)"You need an owner dimlet to make a dimension!");
            return;
        }
        DimensionDescriptor descriptor = this.convertToDimensionDescriptor();
        ItemStack realizedTab = DimensionEnscriberTileEntity.createRealizedTab(descriptor, this.field_145850_b);
        this.inventoryHelper.setStackInSlot(91, realizedTab);
        this.func_70296_d();
    }

    private boolean checkOwnerDimlet() {
        boolean owner = false;
        for (int i = 0; i < 91; ++i) {
            DimletKey key;
            ItemStack stack = this.inventoryHelper.getStackInSlot(i + 0);
            if (stack == null || stack.field_77994_a <= 0 || (key = KnownDimletConfiguration.getDimletKey(stack, this.field_145850_b)).getType() != DimletType.DIMLET_SPECIAL || DimletObjectMapping.idToSpecialType.get(key) != SpecialType.SPECIAL_OWNER) continue;
            owner = true;
            break;
        }
        return !owner;
    }

    public static ItemStack createRealizedTab(DimensionDescriptor descriptor, World world) {
        ItemStack realizedTab = new ItemStack((Item)DimletSetup.realizedDimensionTab, 1, 0);
        NBTTagCompound tagCompound = new NBTTagCompound();
        descriptor.writeToNBT(tagCompound);
        RfToolsDimensionManager manager = RfToolsDimensionManager.getDimensionManager(world);
        Integer id = manager.getDimensionID(descriptor);
        if (id != null) {
            tagCompound.func_74768_a("ticksLeft", 0);
            tagCompound.func_74768_a("id", id.intValue());
        }
        realizedTab.func_77982_d(tagCompound);
        return realizedTab;
    }

    private DimensionDescriptor convertToDimensionDescriptor() {
        ArrayList<DimletKey> descriptors = new ArrayList<DimletKey>();
        long forcedSeed = 0L;
        for (int i = 0; i < 91; ++i) {
            DimletKey key;
            DimletEntry entry;
            ItemStack stack = this.inventoryHelper.getStackInSlot(i + 0);
            if (stack != null && stack.field_77994_a > 0 && (entry = KnownDimletConfiguration.getEntry(key = KnownDimletConfiguration.getDimletKey(stack, this.field_145850_b))) != null) {
                descriptors.add(key);
                NBTTagCompound tagCompound = stack.func_77978_p();
                if (tagCompound != null && tagCompound.func_74763_f("forcedSeed") != 0L) {
                    forcedSeed = tagCompound.func_74763_f("forcedSeed");
                }
            }
            this.inventoryHelper.setStackInSlot(i + 0, null);
        }
        return new DimensionDescriptor(descriptors, forcedSeed);
    }

    private void extractDimlets() {
        ItemStack realizedTab = this.inventoryHelper.getStackInSlot(91);
        NBTTagCompound tagCompound = realizedTab.func_77978_p();
        if (tagCompound != null) {
            int idx = 0;
            String descriptionString = tagCompound.func_74779_i("descriptionString");
            for (DimletKey descriptor : DimensionDescriptor.parseDescriptionString(descriptionString)) {
                int id = tagCompound.func_74762_e("id");
                if (DimletConfiguration.ownerDimletsNeeded && id != 0 && descriptor.getType() == DimletType.DIMLET_SPECIAL && DimletObjectMapping.idToSpecialType.get(descriptor) == SpecialType.SPECIAL_OWNER) continue;
                this.inventoryHelper.setStackInSlot(idx++, KnownDimletConfiguration.makeKnownDimlet(descriptor, this.field_145850_b));
            }
        }
        this.inventoryHelper.setStackInSlot(91, new ItemStack((Item)DimletSetup.emptyDimensionTab));
        this.func_70296_d();
    }

    private void setName(String name) {
        ItemStack realizedTab = this.inventoryHelper.getStackInSlot(91);
        if (realizedTab != null) {
            NBTTagCompound tagCompound = realizedTab.func_77978_p();
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
                realizedTab.func_77982_d(tagCompound);
            }
            tagCompound.func_74778_a("name", name);
            if (tagCompound.func_74764_b("id")) {
                Integer id = tagCompound.func_74762_e("id");
                RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(this.field_145850_b);
                DimensionInformation information = dimensionManager.getDimensionInformation(id);
                if (information != null) {
                    information.setName(name);
                    dimensionManager.save(this.field_145850_b);
                }
            }
            this.func_70296_d();
        }
    }

    public void onSlotChanged(int index, ItemStack stack) {
        if (this.field_145850_b.field_72995_K && index == 91) {
            this.tabSlotHasChanged = true;
        }
    }

    public boolean hasTabSlotChangedAndClear() {
        boolean rc = this.tabSlotHasChanged;
        this.tabSlotHasChanged = false;
        return rc;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_STORE.equals(command)) {
            this.storeDimlets(playerMP);
            this.setName(args.get("name").getString());
            return true;
        }
        if (CMD_EXTRACT.equals(command)) {
            this.extractDimlets();
            return true;
        }
        if (CMD_SETNAME.equals(command)) {
            this.setName(args.get("name").getString());
            return true;
        }
        return false;
    }
}

