/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.itemfilter;

import java.util.Map;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.blocks.itemfilter.DimletFilterContainer;
import mcjty.rftools.items.dimlets.DimletEntry;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class DimletFilterTileEntity
extends GenericTileEntity
implements ISidedInventory {
    public static final String CMD_SETMODE = "setMode";
    public static final String CMD_SETMINRARITY = "setMinRarity";
    public static final String CMD_SETMAXRARITY = "setMaxRarity";
    public static final String CMD_SETTYPE = "setType";
    public static final String CMD_SETCRAFTABLE = "setCraftable";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, DimletFilterContainer.factory, 9);
    public static final int DISABLED = 0;
    public static final int INPUT = 1;
    public static final int OUTPUT = 2;
    public static final int CRAFTABLE_DONTCARE = 0;
    public static final int CRAFTABLE_YES = 1;
    public static final int CRAFTABLE_NO = 2;
    private int[] inputMode = new int[6];
    private int[] minRarity = new int[6];
    private int[] maxRarity = new int[6];
    private DimletType[] types = new DimletType[6];
    private int[] craftable = new int[6];

    public int[] getInputMode() {
        return this.inputMode;
    }

    public int[] getMinRarity() {
        return this.minRarity;
    }

    public int[] getMaxRarity() {
        return this.maxRarity;
    }

    public int[] getCraftable() {
        return this.craftable;
    }

    public DimletType[] getTypes() {
        return this.types;
    }

    public DimletFilterTileEntity() {
        for (int i = 0; i < 6; ++i) {
            this.inputMode[i] = 0;
            this.minRarity[i] = 0;
            this.maxRarity[i] = 6;
            this.types[i] = null;
            this.craftable[i] = 0;
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public boolean canUpdate() {
        return false;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        int[] typesI;
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
        this.inputMode = tagCompound.func_74759_k("inputs");
        this.minRarity = tagCompound.func_74759_k("minRarity");
        if (this.minRarity == null || this.minRarity.length == 0) {
            this.minRarity = new int[6];
        }
        this.maxRarity = tagCompound.func_74759_k("maxRarity");
        if (this.maxRarity == null || this.maxRarity.length == 0) {
            this.maxRarity = new int[6];
        }
        this.craftable = tagCompound.func_74759_k("craftable");
        if (this.craftable == null || this.craftable.length == 0) {
            this.craftable = new int[6];
        }
        if ((typesI = tagCompound.func_74759_k("types")) == null || typesI.length == 0) {
            for (int i = 0; i < 6; ++i) {
                this.types[i] = null;
            }
        } else {
            for (int i = 0; i < 6; ++i) {
                this.types[i] = typesI[i] == -1 ? null : DimletType.values()[typesI[i]];
            }
        }
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        tagCompound.func_74783_a("inputs", this.inputMode);
        tagCompound.func_74783_a("minRarity", this.minRarity);
        tagCompound.func_74783_a("maxRarity", this.maxRarity);
        tagCompound.func_74783_a("craftable", this.craftable);
        int[] typesI = new int[6];
        for (int i = 0; i < 6; ++i) {
            typesI[i] = this.types[i] == null ? -1 : this.types[i].ordinal();
        }
        tagCompound.func_74783_a("types", typesI);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETMODE.equals(command)) {
            Integer side = args.get("side").getInteger();
            Integer input = args.get("input").getInteger();
            this.inputMode[side.intValue()] = input;
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (CMD_SETMINRARITY.equals(command)) {
            Integer side = args.get("side").getInteger();
            Integer value = args.get("value").getInteger();
            this.minRarity[side.intValue()] = value;
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (CMD_SETMAXRARITY.equals(command)) {
            Integer side = args.get("side").getInteger();
            Integer value = args.get("value").getInteger();
            this.maxRarity[side.intValue()] = value;
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (CMD_SETTYPE.equals(command)) {
            Integer side = args.get("side").getInteger();
            Integer type = args.get("type").getInteger();
            this.types[side.intValue()] = type == -1 ? null : DimletType.values()[type];
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (CMD_SETCRAFTABLE.equals(command)) {
            Integer side = args.get("side").getInteger();
            Integer cr = args.get("craftable").getInteger();
            this.craftable[side.intValue()] = cr;
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Dimlet Filter Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return DimletConfiguration.dimletStackSize;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int[] func_94128_d(int side) {
        int v = 0;
        return new int[]{v, v + 1, v + 2, v + 3, v + 4, v + 5, v + 6, v + 7, v + 8};
    }

    public boolean func_102007_a(int index, ItemStack stack, int side) {
        return this.isInputMode(side);
    }

    private int findMostSpecificExtractionSide(DimletEntry entry) {
        DimletKey key = entry.getKey();
        int rarity = entry.getRarity();
        int side = -1;
        int bestMatch = 0;
        int cr = KnownDimletConfiguration.craftableDimlets.contains(key) ? 1 : 2;
        for (int i = 0; i < 6; ++i) {
            if (!this.isOutputMode(i)) continue;
            int match = 0;
            if (this.types[i] != null && !this.types[i].equals((Object)key.getType())) continue;
            match = this.types[i] == null ? ++match : (match += 7);
            if (rarity < this.minRarity[i] || rarity > this.maxRarity[i]) continue;
            match += 7 - (this.maxRarity[i] - this.minRarity[i]);
            if (this.craftable[i] != 0 && this.craftable[i] != cr) continue;
            match = this.craftable[i] == 0 ? ++match : (match += 7);
            if (match <= bestMatch) continue;
            bestMatch = match;
            side = i;
        }
        return side;
    }

    public boolean func_102008_b(int index, ItemStack stack, int side) {
        if (!this.isOutputMode(side)) {
            return false;
        }
        if (stack == null) {
            return false;
        }
        DimletKey key = KnownDimletConfiguration.getDimletKey(stack, this.field_145850_b);
        if (key == null) {
            return false;
        }
        if (this.types[side] != null && !this.types[side].equals((Object)key.getType())) {
            return false;
        }
        DimletEntry entry = KnownDimletConfiguration.getEntry(key);
        if (entry == null) {
            return false;
        }
        int rarity = entry.getRarity();
        if (rarity < this.minRarity[side] || rarity > this.maxRarity[side]) {
            return false;
        }
        if (this.craftable[side] != 0) {
            int cr;
            int n = cr = KnownDimletConfiguration.craftableDimlets.contains(key) ? 1 : 2;
            if (cr != this.craftable[side]) {
                return false;
            }
        }
        return this.findMostSpecificExtractionSide(entry) == side;
    }

    private boolean isInputMode(int side) {
        return this.inputMode[side] == 1;
    }

    private boolean isOutputMode(int side) {
        return this.inputMode[side] == 2;
    }
}

