/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.itemfilter;

import java.util.Map;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.rftools.blocks.itemfilter.ItemFilterContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class ItemFilterTileEntity
extends GenericTileEntity
implements ISidedInventory {
    public static final String CMD_SETMODE = "setMode";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, ItemFilterContainer.factory, 18);
    public static final byte OLDMODE_INPUT_EXACT = 2;
    public static final byte OLDMODE_INPUT = 1;
    public static final byte OLDMODE_DISABLED = 0;
    public static final byte OLDMODE_OUTPUT_EXACT = -1;
    public static final byte OLDMODE_OUTPUT = -2;
    private int[] inputMode = new int[6];
    private int[] outputMode = new int[6];

    public int[] getInputMode() {
        return this.inputMode;
    }

    public int[] getOutputMode() {
        return this.outputMode;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public boolean canUpdate() {
        return false;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
        if (tagCompound.func_74764_b("inputMode")) {
            for (int i = 14; i >= 9; --i) {
                this.inventoryHelper.setStackInSlot(i, this.inventoryHelper.getStackInSlot(i - 3));
                this.inventoryHelper.setStackInSlot(i - 3, null);
            }
            byte[] oldInputMode = tagCompound.func_74770_j("inputMode");
            block8: for (int i = 0; i < 6; ++i) {
                byte im = oldInputMode[i];
                switch (im) {
                    case 2: {
                        this.inputMode[i] = 1 << i;
                        this.outputMode[i] = 0;
                        continue block8;
                    }
                    case 1: {
                        this.inputMode[i] = 63;
                        this.outputMode[i] = 0;
                        continue block8;
                    }
                    case -1: {
                        this.inputMode[i] = 0;
                        this.outputMode[i] = 1 << i;
                        continue block8;
                    }
                    case -2: {
                        this.inputMode[i] = 0;
                        this.outputMode[i] = 63;
                        continue block8;
                    }
                    case 0: {
                        this.inputMode[i] = 0;
                        this.outputMode[i] = 0;
                    }
                }
            }
        } else {
            this.inputMode = tagCompound.func_74759_k("inputs");
            this.outputMode = tagCompound.func_74759_k("outputs");
        }
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        tagCompound.func_74783_a("inputs", this.inputMode);
        tagCompound.func_74783_a("outputs", this.outputMode);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETMODE.equals(command)) {
            Integer side = args.get("side").getInteger();
            Integer slot = args.get("slot").getInteger();
            Boolean input = args.get("input").getBoolean();
            Boolean output = args.get("output").getBoolean();
            int n = side;
            this.inputMode[n] = this.inputMode[n] & ~(1 << slot);
            if (input.booleanValue()) {
                int n2 = side;
                this.inputMode[n2] = this.inputMode[n2] | 1 << slot;
            }
            int n3 = side;
            this.outputMode[n3] = this.outputMode[n3] & ~(1 << slot);
            if (output.booleanValue()) {
                int n4 = side;
                this.outputMode[n4] = this.outputMode[n4] | 1 << slot;
            }
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Item Filter Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index < 9) {
            return true;
        }
        ItemStack ghostStack = this.inventoryHelper.getStackInSlot(index - 9);
        return ghostStack == null || ghostStack.func_77969_a(stack);
    }

    public int[] func_94128_d(int side) {
        int v = 9;
        return new int[]{v, v + 1, v + 2, v + 3, v + 4, v + 5, v + 6, v + 7, v + 8};
    }

    public boolean func_102007_a(int index, ItemStack stack, int side) {
        if (index < 9) {
            return false;
        }
        if (!this.isInputMode(side, index - 9)) {
            return false;
        }
        int ghostIndex = index - 9;
        ItemStack ghostStack = this.inventoryHelper.getStackInSlot(ghostIndex);
        if (ghostStack == null) {
            int im = this.inputMode[side];
            for (int i = 0; i < 9; ++i) {
                ItemStack g = this.inventoryHelper.getStackInSlot(i);
                if (g == null || (im & 1 << i) == 0 || !g.func_77969_a(stack)) continue;
                return false;
            }
            return true;
        }
        return ghostStack.func_77969_a(stack);
    }

    public boolean func_102008_b(int index, ItemStack stack, int side) {
        if (index < 9) {
            return false;
        }
        return this.isOutputMode(side, index - 9);
    }

    private boolean isInputMode(int side, int slot) {
        return (this.inputMode[side] & 1 << slot) != 0;
    }

    private boolean isOutputMode(int side, int slot) {
        return (this.outputMode[side] & 1 << slot) != 0;
    }
}

