/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modules;

import mcjty.rftools.blocks.logic.RedstoneChannels;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modules.ScreenModule;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ButtonScreenModule
implements ScreenModule {
    private String line = "";
    private int channel = -1;
    private boolean toggle;

    @Override
    public Object[] getData(World worldObj, long millis) {
        if (this.channel != -1 && this.toggle) {
            RedstoneChannels channels = RedstoneChannels.getChannels(worldObj);
            RedstoneChannels.RedstoneChannel ch = channels.getOrCreateChannel(this.channel);
            return new Object[]{ch.getValue()};
        }
        return null;
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, int x, int y, int z) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            if (tagCompound.func_74764_b("channel")) {
                this.channel = tagCompound.func_74762_e("channel");
            }
            this.toggle = tagCompound.func_74767_n("toggle");
        }
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked) {
        int xoffset = !this.line.isEmpty() ? 80 : 5;
        if (x >= xoffset && this.channel != -1) {
            if (this.toggle) {
                if (clicked) {
                    RedstoneChannels.RedstoneChannel ch;
                    RedstoneChannels channels = RedstoneChannels.getChannels(world);
                    ch.setValue((ch = channels.getOrCreateChannel(this.channel)).getValue() == 0 ? 15 : 0);
                    channels.save(world);
                }
            } else {
                RedstoneChannels channels = RedstoneChannels.getChannels(world);
                RedstoneChannels.RedstoneChannel ch = channels.getOrCreateChannel(this.channel);
                ch.setValue(clicked ? 15 : 0);
                channels.save(world);
            }
        }
    }

    @Override
    public int getRfPerTick() {
        return ScreenConfiguration.BUTTON_RFPERTICK;
    }
}

