/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spaceprojector;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.ChoiceEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.spaceprojector.BuilderContainer;
import mcjty.rftools.blocks.spaceprojector.BuilderTileEntity;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiBuilder
extends GenericGuiContainer<BuilderTileEntity> {
    public static final int BUILDER_WIDTH = 180;
    public static final int BUILDER_HEIGHT = 152;
    private EnergyBar energyBar;
    private ChoiceLabel modeChoice;
    private ImageChoiceLabel silentMode;
    private ImageChoiceLabel supportMode;
    private ImageChoiceLabel entityMode;
    private ImageChoiceLabel loopMode;
    private Label currentLevel;
    private ImageChoiceLabel[] anchor = new ImageChoiceLabel[4];
    private ChoiceLabel rotateButton;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/spaceprojector.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");

    public GuiBuilder(BuilderTileEntity builderTileEntity, BuilderContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)builderTileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "builder");
        BuilderTileEntity.setCurrentRF((int)builderTileEntity.getEnergyStored(ForgeDirection.DOWN));
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((BuilderTileEntity)this.tileEntity).getMaxEnergyStored(ForgeDirection.DOWN);
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 6, 9, 59))).setShowText(false);
        BuilderTileEntity cfr_ignored_0 = (BuilderTileEntity)this.tileEntity;
        this.energyBar.setValue(BuilderTileEntity.getCurrentRF());
        this.currentLevel = new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.currentLevel.setText("Y:").setTooltips(new String[]{"Current level the builder is at"}).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(75, 40, 40, 15));
        Panel positionPanel = this.setupPositionPanel();
        Panel modePanel = this.setupModePanel();
        Panel toplevel = (Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.energyBar)).addChild((Widget)modePanel)).addChild((Widget)positionPanel)).addChild((Widget)this.currentLevel);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        ((BuilderTileEntity)this.tileEntity).requestRfFromServer(RFToolsMessages.INSTANCE);
        ((BuilderTileEntity)this.tileEntity).requestCurrentLevel();
    }

    private Panel setupPositionPanel() {
        this.rotateButton = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{"0", "90", "180", "270"}).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, 4, 42, 14))).setTooltips(new String[]{"Set the horizontal rotation angle"})).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiBuilder.this.updateRotate();
            }
        });
        switch (((BuilderTileEntity)this.tileEntity).getRotate()) {
            case 0: {
                this.rotateButton.setChoice("0");
                break;
            }
            case 1: {
                this.rotateButton.setChoice("90");
                break;
            }
            case 2: {
                this.rotateButton.setChoice("180");
                break;
            }
            case 3: {
                this.rotateButton.setChoice("270");
            }
        }
        Panel positionPanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(122, 6, 50, 59))).addChild((Widget)this.rotateButton)).setFilledRectThickness(-2)).setFilledBackground(StyleConfig.colorListBackground);
        String[] choiceDescriptions = new String[]{"Builder at south west corner", "Builder at south east corner", "Builder at north west corner", "Builder at north east corner"};
        for (int y = 0; y <= 1; ++y) {
            for (int x = 0; x <= 1; ++x) {
                final int index = x + y * 2;
                this.anchor[index] = (ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setWithBorder(true).setHighlightedChoice(1).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4 + x * 24, 18 + (1 - y) * 19, 17, 17))).setTooltips(new String[]{"Set the anchor where you want to", "place the blocks in front of the", "builder"});
                this.anchor[index].addChoice("off", choiceDescriptions[index], guiElements, (7 + index * 2) * 16, 64);
                this.anchor[index].addChoice("on", choiceDescriptions[index], guiElements, (6 + index * 2) * 16, 64);
                this.anchor[index].addChoiceEvent(new ChoiceEvent(){

                    public void choiceChanged(Widget widget, String s) {
                        GuiBuilder.this.selectAnchor(index);
                    }
                });
                positionPanel.addChild((Widget)this.anchor[index]);
            }
        }
        if (!this.isShapeCard()) {
            this.anchor[((BuilderTileEntity)this.tileEntity).getAnchor()].setCurrentChoice(1);
        }
        return positionPanel;
    }

    private Panel setupModePanel() {
        this.modeChoice = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{BuilderTileEntity.MODES[0], BuilderTileEntity.MODES[1], BuilderTileEntity.MODES[2], BuilderTileEntity.MODES[3]}).setTooltips(new String[]{"Set the building mode"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, 4, 42, 14))).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiBuilder.this.updateMode();
            }
        });
        this.modeChoice.setChoice(BuilderTileEntity.MODES[((BuilderTileEntity)this.tileEntity).getMode()]);
        this.silentMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, 18, 17, 17))).setWithBorder(true).setHighlightedChoice(1).setTooltips(new String[]{"Suppress the placement/breaking sound", "when moving blocks"})).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiBuilder.this.setSilentMode();
            }
        });
        this.silentMode.addChoice("off", "Moving blocks make sound", guiElements, 176, 48);
        this.silentMode.addChoice("on", "Block sounds are muted", guiElements, 160, 48);
        this.silentMode.setCurrentChoice(((BuilderTileEntity)this.tileEntity).isSilent() ? 1 : 0);
        this.supportMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(28, 18, 17, 17))).setWithBorder(true).setHighlightedChoice(1).setTooltips(new String[]{"Use supporting blocks when moving.", "Useful for liquids, gravel, ..."})).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiBuilder.this.setSupportMode();
            }
        });
        this.supportMode.addChoice("off", "Support/preview mode disabled", guiElements, 112, 48);
        this.supportMode.addChoice("on", "Support/preview mode enabled", guiElements, 96, 48);
        this.supportMode.setCurrentChoice(((BuilderTileEntity)this.tileEntity).hasSupportMode() ? 1 : 0);
        this.entityMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, 37, 17, 17))).setWithBorder(true).setHighlightedChoice(1).setTooltips(new String[]{"Move entities"})).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiBuilder.this.setEntityMode();
            }
        });
        this.entityMode.addChoice("off", "Entities are not moved", guiElements, 144, 48);
        this.entityMode.addChoice("on", "Entities are moved", guiElements, 128, 48);
        this.entityMode.setCurrentChoice(((BuilderTileEntity)this.tileEntity).hasEntityMode() ? 1 : 0);
        this.loopMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(28, 37, 17, 17))).setWithBorder(true).setHighlightedChoice(1).setTooltips(new String[]{"Loop mode"})).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiBuilder.this.setLoopMode();
            }
        });
        this.loopMode.addChoice("off", "Do a single run and stop", guiElements, 208, 48);
        this.loopMode.addChoice("on", "Keep running with redstone signal", guiElements, 192, 48);
        this.loopMode.setCurrentChoice(((BuilderTileEntity)this.tileEntity).hasLoopMode() ? 1 : 0);
        return (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(23, 6, 50, 59))).addChild((Widget)this.modeChoice)).addChild((Widget)this.silentMode)).addChild((Widget)this.supportMode)).addChild((Widget)this.entityMode)).addChild((Widget)this.loopMode)).setFilledRectThickness(-2)).setFilledBackground(StyleConfig.colorListBackground);
    }

    private void setLoopMode() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setLoop", new Argument[]{new Argument("loop", this.loopMode.getCurrentChoiceIndex() == 1)});
    }

    private void setSilentMode() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setSilent", new Argument[]{new Argument("silent", this.silentMode.getCurrentChoiceIndex() == 1)});
    }

    private void setSupportMode() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setSupport", new Argument[]{new Argument("support", this.supportMode.getCurrentChoiceIndex() == 1)});
    }

    private void setEntityMode() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setEntities", new Argument[]{new Argument("entities", this.entityMode.getCurrentChoiceIndex() == 1)});
    }

    private void selectAnchor(int index) {
        this.updateAnchorSettings(index);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setAnchor", new Argument[]{new Argument("anchor", index)});
    }

    private void updateAnchorSettings(int index) {
        for (int i = 0; i < this.anchor.length; ++i) {
            if (this.isShapeCard()) {
                this.anchor[i].setCurrentChoice(0);
                continue;
            }
            if (this.anchor[i].getCurrentChoiceIndex() == 1 == (i == index)) continue;
            this.anchor[i].setCurrentChoice(i == index ? 1 : 0);
        }
    }

    private void updateMode() {
        String currentChoice = this.modeChoice.getCurrentChoice();
        int mode = 0;
        for (int i = 0; i < BuilderTileEntity.MODES.length; ++i) {
            if (!currentChoice.equals(BuilderTileEntity.MODES[i])) continue;
            mode = i;
            break;
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setMode", new Argument[]{new Argument("mode", mode)});
    }

    private void updateRotate() {
        String choice = this.rotateButton.getCurrentChoice();
        int index = 0;
        if ("0".equals(choice)) {
            index = 0;
        } else if ("90".equals(choice)) {
            index = 1;
        } else if ("180".equals(choice)) {
            index = 2;
        } else if ("270".equals(choice)) {
            index = 3;
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setRotate", new Argument[]{new Argument("rotate", index)});
    }

    private boolean isShapeCard() {
        ItemStack card = ((BuilderTileEntity)this.tileEntity).func_70301_a(0);
        return card != null && card.func_77973_b() == ModItems.shapeCardItem;
    }

    protected void func_146976_a(float v, int i, int i2) {
        BuilderTileEntity cfr_ignored_0 = (BuilderTileEntity)this.tileEntity;
        int cury = BuilderTileEntity.getCurrentLevel();
        this.currentLevel.setText("Y: " + (cury == -1 ? "stop" : Integer.valueOf(cury)));
        ItemStack card = ((BuilderTileEntity)this.tileEntity).func_70301_a(0);
        boolean enabled = card == null ? false : card.func_77973_b() != ModItems.shapeCardItem;
        this.modeChoice.setEnabled(enabled);
        this.rotateButton.setEnabled(enabled);
        this.updateAnchorSettings(((BuilderTileEntity)this.tileEntity).getAnchor());
        this.drawWindow();
        BuilderTileEntity cfr_ignored_1 = (BuilderTileEntity)this.tileEntity;
        this.energyBar.setValue(BuilderTileEntity.getCurrentRF());
        ((BuilderTileEntity)this.tileEntity).requestRfFromServer(RFToolsMessages.INSTANCE);
        ((BuilderTileEntity)this.tileEntity).requestCurrentLevel();
    }
}

