/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spaceprojector;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.BlockMeta;
import mcjty.rftools.blocks.spaceprojector.GuiChamberDetails;
import net.minecraft.block.Block;

public class PacketChamberInfoReady
implements IMessage,
IMessageHandler<PacketChamberInfoReady, IMessage> {
    private Map<BlockMeta, Integer> blocks;
    private Map<BlockMeta, Integer> costs;
    private Map<String, Integer> entities;
    private Map<String, Integer> entityCosts;

    public void fromBytes(ByteBuf buf) {
        int i;
        int size = buf.readInt();
        this.blocks = new HashMap<BlockMeta, Integer>(size);
        this.costs = new HashMap<BlockMeta, Integer>(size);
        for (i = 0; i < size; ++i) {
            int id = buf.readInt();
            byte meta = buf.readByte();
            int count = buf.readInt();
            int cost = buf.readInt();
            Block block = (Block)Block.field_149771_c.func_148754_a(id);
            BlockMeta bm = new BlockMeta(block, meta);
            this.blocks.put(bm, count);
            this.costs.put(bm, cost);
        }
        size = buf.readInt();
        this.entities = new HashMap<String, Integer>(size);
        this.entityCosts = new HashMap<String, Integer>(size);
        for (i = 0; i < size; ++i) {
            String className = NetworkTools.readString((ByteBuf)buf);
            int count = buf.readInt();
            int cost = buf.readInt();
            this.entities.put(className, count);
            this.entityCosts.put(className, cost);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.blocks.size());
        for (Map.Entry<BlockMeta, Integer> entry : this.blocks.entrySet()) {
            Block block = entry.getKey().getBlock();
            buf.writeInt(Block.field_149771_c.func_148757_b((Object)block));
            buf.writeByte((int)entry.getKey().getMeta());
            buf.writeInt(entry.getValue().intValue());
            buf.writeInt(this.costs.get(entry.getKey()).intValue());
        }
        buf.writeInt(this.entities.size());
        for (Map.Entry<Object, Integer> entry : this.entities.entrySet()) {
            NetworkTools.writeString((ByteBuf)buf, (String)((String)entry.getKey()));
            buf.writeInt(entry.getValue().intValue());
            buf.writeInt(this.entityCosts.get(entry.getKey()).intValue());
        }
    }

    public PacketChamberInfoReady() {
    }

    public PacketChamberInfoReady(Map<BlockMeta, Integer> blocks, Map<BlockMeta, Integer> costs, Map<String, Integer> entities, Map<String, Integer> entityCosts) {
        this.blocks = new HashMap<BlockMeta, Integer>(blocks);
        this.costs = new HashMap<BlockMeta, Integer>(costs);
        this.entities = new HashMap<String, Integer>(entities);
        this.entityCosts = new HashMap<String, Integer>(entityCosts);
    }

    public IMessage onMessage(PacketChamberInfoReady message, MessageContext ctx) {
        GuiChamberDetails.setItemsWithCount(message.blocks, message.costs, message.entities, message.entityCosts);
        return null;
    }
}

