/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spaceprojector;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import mcjty.lib.varia.BlockMeta;
import mcjty.lib.varia.Coordinate;
import mcjty.lib.varia.Counter;
import mcjty.rftools.blocks.spaceprojector.BuilderTileEntity;
import mcjty.rftools.blocks.spaceprojector.PacketChamberInfoReady;
import mcjty.rftools.blocks.spaceprojector.SpaceChamberRepository;
import mcjty.rftools.blocks.spaceprojector.SpaceProjectorConfiguration;
import mcjty.rftools.blocks.spaceprojector.SpaceProjectorSetup;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PacketGetChamberInfo
implements IMessage,
IMessageHandler<PacketGetChamberInfo, PacketChamberInfoReady> {
    public void fromBytes(ByteBuf buf) {
    }

    public void toBytes(ByteBuf buf) {
    }

    public PacketChamberInfoReady onMessage(PacketGetChamberInfo message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        ItemStack cardItem = player.func_70694_bm();
        if (cardItem == null || cardItem.func_77978_p() == null) {
            return null;
        }
        int channel = cardItem.func_77978_p().func_74762_e("channel");
        if (channel == -1) {
            return null;
        }
        SpaceChamberRepository repository = SpaceChamberRepository.getChannels(player.field_70170_p);
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
        if (chamberChannel == null) {
            return null;
        }
        int dimension = chamberChannel.getDimension();
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world == null) {
            return null;
        }
        Counter blocks = new Counter();
        Counter costs = new Counter();
        Coordinate minCorner = chamberChannel.getMinCorner();
        Coordinate maxCorner = chamberChannel.getMaxCorner();
        for (int x = minCorner.getX(); x <= maxCorner.getX(); ++x) {
            for (int y = minCorner.getY(); y <= maxCorner.getY(); ++y) {
                for (int z = minCorner.getZ(); z <= maxCorner.getZ(); ++z) {
                    Block block = world.func_147439_a(x, y, z);
                    if (BuilderTileEntity.isEmpty(block)) continue;
                    int meta = world.func_72805_g(x, y, z);
                    BlockMeta bm = new BlockMeta(block, meta);
                    blocks.increment((Object)bm);
                    TileEntity te = world.func_147438_o(x, y, z);
                    SpaceProjectorSetup.BlockInformation info = BuilderTileEntity.getBlockInformation((World)world, x, y, z, block, te);
                    if (info.getBlockLevel() == 2) {
                        costs.put((Object)bm, (Object)-1);
                        continue;
                    }
                    costs.increment((Object)bm, (int)((double)SpaceProjectorConfiguration.builderRfPerOperation * info.getCostFactor()));
                }
            }
        }
        Counter entitiesWithCount = new Counter();
        Counter entitiesWithCost = new Counter();
        List entities = world.func_72839_b(null, AxisAlignedBB.func_72330_a((double)minCorner.getX(), (double)minCorner.getY(), (double)minCorner.getZ(), (double)(maxCorner.getX() + 1), (double)(maxCorner.getY() + 1), (double)(maxCorner.getZ() + 1)));
        for (Object o : entities) {
            Entity entity = (Entity)o;
            String canonicalName = entity.getClass().getCanonicalName();
            entitiesWithCount.increment((Object)canonicalName);
            if (entity instanceof EntityPlayer) {
                entitiesWithCost.increment((Object)canonicalName, SpaceProjectorConfiguration.builderRfPerPlayer);
                continue;
            }
            entitiesWithCost.increment((Object)canonicalName, SpaceProjectorConfiguration.builderRfPerEntity);
        }
        return new PacketChamberInfoReady((Map<BlockMeta, Integer>)blocks, (Map<BlockMeta, Integer>)costs, (Map<String, Integer>)entitiesWithCount, (Map<String, Integer>)entitiesWithCost);
    }
}

