/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spawner;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketServerCommand;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Coordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.spawner.MatterBeamerContainer;
import mcjty.rftools.blocks.spawner.SpawnerConfiguration;
import mcjty.rftools.blocks.spawner.SpawnerTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class MatterBeamerTileEntity
extends GenericEnergyReceiverTileEntity
implements ISidedInventory {
    public static final int TICKTIME = 20;
    public static String CMD_SETDESTINATION = "setDest";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, MatterBeamerContainer.factory, 1);
    private Coordinate destination = null;
    private int ticker = 20;

    public MatterBeamerTileEntity() {
        super(SpawnerConfiguration.BEAMER_MAXENERGY, SpawnerConfiguration.BEAMER_RECEIVEPERTICK);
    }

    protected void checkStateServer() {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!BlockTools.getRedstoneSignal((int)meta)) {
            this.disableBlockGlow();
            return;
        }
        --this.ticker;
        if (this.ticker > 0) {
            return;
        }
        this.ticker = 20;
        TileEntity te = null;
        if (this.destination != null) {
            te = this.field_145850_b.func_147438_o(this.destination.getX(), this.destination.getY(), this.destination.getZ());
            if (!(te instanceof SpawnerTileEntity)) {
                this.setDestination(null);
                return;
            }
        } else {
            return;
        }
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
        if (itemStack == null || itemStack.field_77994_a == 0) {
            this.disableBlockGlow();
            return;
        }
        SpawnerTileEntity spawnerTileEntity = (SpawnerTileEntity)te;
        int maxblocks = (int)((double)SpawnerConfiguration.beamBlocksPerSend * (1.01 + (double)this.getInfusedFactor() * 2.0));
        int numblocks = Math.min(maxblocks, itemStack.field_77994_a);
        int rf = (int)((float)(SpawnerConfiguration.beamRfPerObject * numblocks) * (4.0f - this.getInfusedFactor()) / 4.0f);
        if (this.getEnergyStored(ForgeDirection.DOWN) < rf) {
            return;
        }
        this.consumeEnergy(rf);
        spawnerTileEntity.addMatter(itemStack, numblocks);
        this.inventoryHelper.decrStackSize(0, numblocks);
        this.enableBlockGlow();
    }

    private void disableBlockGlow() {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if ((meta & 1) != 0) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta & 0xFFFFFFFE, 3);
        }
    }

    private void enableBlockGlow() {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if ((meta & 1) == 0) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta | 1, 3);
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 4), (double)(this.field_145848_d - 4), (double)(this.field_145849_e - 4), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 5));
    }

    public void useWrench(EntityPlayer player) {
        Coordinate thisCoord = new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        Coordinate coord = RFTools.instance.clientInfo.getSelectedTE();
        TileEntity tileEntity = null;
        if (coord != null) {
            tileEntity = this.field_145850_b.func_147438_o(coord.getX(), coord.getY(), coord.getZ());
        }
        if (!(tileEntity instanceof MatterBeamerTileEntity)) {
            RFTools.instance.clientInfo.setSelectedTE(thisCoord);
            SpawnerTileEntity destinationTE = this.getDestinationTE();
            if (destinationTE == null) {
                RFTools.instance.clientInfo.setDestinationTE(null);
            } else {
                RFTools.instance.clientInfo.setDestinationTE(new Coordinate(destinationTE.field_145851_c, destinationTE.field_145848_d, destinationTE.field_145849_e));
            }
            Logging.message((EntityPlayer)player, (String)"Select a spawner as destination");
        } else if (coord.equals((Object)thisCoord)) {
            RFTools.instance.clientInfo.setSelectedTE(null);
            RFTools.instance.clientInfo.setDestinationTE(null);
            this.setDestination(null);
            Logging.message((EntityPlayer)player, (String)"Destination cleared!");
        }
    }

    public void setDestination(Coordinate destination) {
        this.destination = destination;
        this.disableBlockGlow();
        this.func_70296_d();
        if (this.field_145850_b.field_72995_K) {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketServerCommand(this.field_145851_c, this.field_145848_d, this.field_145849_e, CMD_SETDESTINATION, new Argument[]{new Argument("dest", destination)}));
        } else {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public Coordinate getDestination() {
        return this.destination;
    }

    private SpawnerTileEntity getDestinationTE() {
        if (this.destination == null) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.destination.getX(), this.destination.getY(), this.destination.getZ());
        if (te instanceof SpawnerTileEntity) {
            return (SpawnerTileEntity)te;
        }
        this.destination = null;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return null;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.destination = Coordinate.readFromNBT((NBTTagCompound)tagCompound, (String)"dest");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        Coordinate.writeToNBT((NBTTagCompound)tagCompound, (String)"dest", (Coordinate)this.destination);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public int[] func_94128_d(int side) {
        return MatterBeamerContainer.factory.getAccessibleSlots();
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        return MatterBeamerContainer.factory.isInputSlot(index);
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return MatterBeamerContainer.factory.isOutputSlot(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Beamer Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETDESTINATION.equals(command)) {
            this.setDestination(args.get("dest").getCoordinate());
            return true;
        }
        return false;
    }
}

