/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.Coordinate;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.blocks.storage.RemoteStorageTileEntity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class RemoteStorageIdRegistry
extends WorldSavedData {
    public static final String RFTOOLS_REMOTE_STORAGE = "RFToolsRemoteStorage";
    private static RemoteStorageIdRegistry instance = null;
    private int lastId = 0;
    private Map<Integer, GlobalCoordinate> storages = new HashMap<Integer, GlobalCoordinate>();
    private Map<Integer, Long> lastPublishTime = new HashMap<Integer, Long>();

    public RemoteStorageIdRegistry(String identifier) {
        super(identifier);
    }

    public void save(World world) {
        world.field_72988_C.func_75745_a(RFTOOLS_REMOTE_STORAGE, (WorldSavedData)this);
        this.func_76185_a();
    }

    public static void clearInstance() {
        instance = null;
    }

    public static RemoteStorageIdRegistry getRegistry(World world) {
        if (world.field_72995_K) {
            return null;
        }
        if (instance != null) {
            return instance;
        }
        instance = (RemoteStorageIdRegistry)world.field_72988_C.func_75742_a(RemoteStorageIdRegistry.class, RFTOOLS_REMOTE_STORAGE);
        if (instance == null) {
            instance = new RemoteStorageIdRegistry(RFTOOLS_REMOTE_STORAGE);
        }
        return instance;
    }

    public static RemoteStorageTileEntity getRemoteStorage(World world, int id) {
        RemoteStorageIdRegistry registry = RemoteStorageIdRegistry.getRegistry(world);
        if (registry == null) {
            return null;
        }
        GlobalCoordinate coordinate = registry.getStorage(id);
        if (coordinate == null) {
            return null;
        }
        WorldServer w = DimensionManager.getWorld((int)coordinate.getDimension());
        if (w == null) {
            return null;
        }
        Coordinate c = coordinate.getCoordinate();
        boolean exists = w.func_72863_F().func_73149_a(c.getX() >> 4, c.getZ() >> 4);
        if (!exists) {
            return null;
        }
        TileEntity te = w.func_147438_o(c.getX(), c.getY(), c.getZ());
        if (te instanceof RemoteStorageTileEntity) {
            RemoteStorageTileEntity remoteStorageTileEntity = (RemoteStorageTileEntity)te;
            int index = remoteStorageTileEntity.findRemoteIndex(id);
            if (index == -1) {
                return null;
            }
            if (remoteStorageTileEntity.isGlobal(index) || world.field_73011_w.field_76574_g == coordinate.getDimension()) {
                return remoteStorageTileEntity;
            }
            return null;
        }
        return null;
    }

    public void publishStorage(int id, GlobalCoordinate coordinate) {
        long time = System.currentTimeMillis();
        this.storages.put(id, coordinate);
        this.lastPublishTime.put(id, time);
    }

    public GlobalCoordinate getStorage(int id) {
        long time = System.currentTimeMillis();
        if (!this.storages.containsKey(id)) {
            return null;
        }
        long t = this.lastPublishTime.get(id);
        if (time > t + 500L) {
            return null;
        }
        return this.storages.get(id);
    }

    public int getNewId() {
        ++this.lastId;
        return this.lastId;
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        this.lastId = tagCompound.func_74762_e("lastId");
    }

    public void func_76187_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("lastId", this.lastId);
    }
}

