/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.commands;

import mcjty.rftools.commands.AbstractRfToolsCommand;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class CmdLoadDim
extends AbstractRfToolsCommand {
    @Override
    public String getHelp() {
        return "<dimension> <filename>";
    }

    @Override
    public String getCommand() {
        return "loaddim";
    }

    @Override
    public int getPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "The dimension and filename parameters are missing!"));
            return;
        }
        if (args.length > 3) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Too many parameters!"));
            return;
        }
        int dim = this.fetchInt(sender, args, 1, 0);
        String filename = this.fetchString(sender, args, 2, null);
        World world = sender.func_130014_f_();
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        if (dimensionManager.getDimensionDescriptor(dim) == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Not an RFTools dimension!"));
            return;
        }
        DimensionInformation information = dimensionManager.getDimensionInformation(dim);
        String error = information.loadFromJson(filename);
        if (error != null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Error: " + error));
        } else {
            dimensionManager.save(world);
        }
    }
}

