/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.dimlets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.WeightedRandomSelector;
import mcjty.rftools.dimension.description.MobDescriptor;
import mcjty.rftools.dimension.world.types.EffectType;
import mcjty.rftools.dimension.world.types.FeatureType;
import mcjty.rftools.dimension.world.types.StructureType;
import mcjty.rftools.items.dimlets.DimletEntry;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletMapping;
import mcjty.rftools.items.dimlets.DimletObjectMapping;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.tuple.Pair;

public class DimletRandomizer {
    public static final int RARITY_0 = 0;
    public static final int RARITY_1 = 1;
    public static final int RARITY_2 = 2;
    public static final int RARITY_3 = 3;
    public static final int RARITY_4 = 4;
    public static final int RARITY_5 = 5;
    public static final int RARITY_6 = 6;
    public static float rarity0;
    public static float rarity1;
    public static float rarity2;
    public static float rarity3;
    public static float rarity4;
    public static float rarity5;
    public static float rarity6;
    public static final List<DimletKey> dimletIds;
    static final Map<DimletKey, Integer> dimletBuiltinRarity;
    public static WeightedRandomSelector<Integer, DimletKey> randomDimlets;
    public static WeightedRandomSelector<Integer, DimletKey> randomMaterialDimlets;
    public static WeightedRandomSelector<Integer, DimletKey> randomLiquidDimlets;
    public static WeightedRandomSelector<Integer, DimletKey> randomMobDimlets;
    public static WeightedRandomSelector<Integer, DimletKey> randomStructureDimlets;
    public static WeightedRandomSelector<Integer, DimletKey> randomEffectDimlets;
    public static WeightedRandomSelector<Integer, DimletKey> randomFeatureDimlets;

    public static void clean() {
        randomDimlets = null;
        randomMaterialDimlets = null;
        randomLiquidDimlets = null;
        randomMobDimlets = null;
        randomStructureDimlets = null;
        randomEffectDimlets = null;
        randomFeatureDimlets = null;
    }

    public static void readRandomConfig(Configuration cfg) {
        rarity0 = (float)cfg.get("rarity", "level0", 500.0).getDouble();
        rarity1 = (float)cfg.get("rarity", "level1", 250.0).getDouble();
        rarity2 = (float)cfg.get("rarity", "level2", 150.0).getDouble();
        rarity3 = (float)cfg.get("rarity", "level3", 90.0).getDouble();
        rarity4 = (float)cfg.get("rarity", "level4", 40.0).getDouble();
        rarity5 = (float)cfg.get("rarity", "level5", 20.0).getDouble();
        rarity6 = (float)cfg.get("rarity", "level6", 1.0).getDouble();
    }

    static void setupWeightedRandomList() {
        randomDimlets = new WeightedRandomSelector();
        DimletRandomizer.setupRarity(randomDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
        randomMaterialDimlets = new WeightedRandomSelector();
        DimletRandomizer.setupRarity(randomMaterialDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
        randomLiquidDimlets = new WeightedRandomSelector();
        DimletRandomizer.setupRarity(randomLiquidDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
        randomMobDimlets = new WeightedRandomSelector();
        DimletRandomizer.setupRarity(randomMobDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
        randomStructureDimlets = new WeightedRandomSelector();
        DimletRandomizer.setupRarity(randomStructureDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
        randomEffectDimlets = new WeightedRandomSelector();
        DimletRandomizer.setupRarity(randomEffectDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
        randomFeatureDimlets = new WeightedRandomSelector();
        DimletRandomizer.setupRarity(randomFeatureDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
        for (Map.Entry<DimletKey, DimletEntry> entry : KnownDimletConfiguration.idToDimletEntry.entrySet()) {
            randomDimlets.addItem((Object)entry.getValue().getRarity(), (Object)entry.getKey());
            DimletKey key = entry.getValue().getKey();
            if (key.getType() == DimletType.DIMLET_MATERIAL) {
                if (DimletObjectMapping.idToBlock.get(key) == null) continue;
                randomMaterialDimlets.addItem((Object)entry.getValue().getRarity(), (Object)entry.getKey());
                continue;
            }
            if (key.getType() == DimletType.DIMLET_LIQUID) {
                if (DimletObjectMapping.idToFluid.get(key) == null) continue;
                randomLiquidDimlets.addItem((Object)entry.getValue().getRarity(), (Object)entry.getKey());
                continue;
            }
            if (key.getType() == DimletType.DIMLET_MOBS) {
                MobDescriptor descriptor = DimletObjectMapping.idtoMob.get(key);
                if (descriptor == null || descriptor.getEntityClass() == null) continue;
                randomMobDimlets.addItem((Object)entry.getValue().getRarity(), (Object)entry.getKey());
                continue;
            }
            if (key.getType() == DimletType.DIMLET_EFFECT) {
                if (DimletObjectMapping.idToEffectType.get(key) == EffectType.EFFECT_NONE) continue;
                randomEffectDimlets.addItem((Object)entry.getValue().getRarity(), (Object)entry.getKey());
                continue;
            }
            if (key.getType() == DimletType.DIMLET_FEATURE) {
                if (DimletObjectMapping.idToFeatureType.get(key) == FeatureType.FEATURE_NONE) continue;
                randomFeatureDimlets.addItem((Object)entry.getValue().getRarity(), (Object)entry.getKey());
                continue;
            }
            if (key.getType() != DimletType.DIMLET_STRUCTURE || DimletObjectMapping.idToStructureType.get(key) == StructureType.STRUCTURE_NONE) continue;
            randomStructureDimlets.addItem((Object)entry.getValue().getRarity(), (Object)entry.getKey());
        }
    }

    private static boolean isDimletNotAllowedForLoot(DimletKey key) {
        DimletEntry entry = KnownDimletConfiguration.getEntry(key);
        return entry.isLootNotAllowed();
    }

    private static boolean isDimletNotAllowedForWorldgen(boolean allowRandom, DimletKey key) {
        return !allowRandom && KnownDimletConfiguration.getEntry(key).isRandomNotAllowed();
    }

    public static DimletKey getRandomMob(Random random, boolean allowRandom) {
        DimletKey key = (DimletKey)randomMobDimlets.select(random);
        while (DimletRandomizer.isDimletNotAllowedForWorldgen(allowRandom, key)) {
            key = (DimletKey)randomMobDimlets.select(random);
        }
        return key;
    }

    public static DimletKey getRandomEffect(Random random, boolean allowRandom) {
        DimletKey key = (DimletKey)randomEffectDimlets.select(random);
        while (DimletRandomizer.isDimletNotAllowedForWorldgen(allowRandom, key)) {
            key = (DimletKey)randomEffectDimlets.select(random);
        }
        return key;
    }

    public static DimletKey getRandomFeature(Random random, boolean allowRandom) {
        DimletKey key = (DimletKey)randomFeatureDimlets.select(random);
        while (DimletRandomizer.isDimletNotAllowedForWorldgen(allowRandom, key)) {
            key = (DimletKey)randomFeatureDimlets.select(random);
        }
        return key;
    }

    public static DimletKey getRandomStructure(Random random, boolean allowRandom) {
        DimletKey key = (DimletKey)randomStructureDimlets.select(random);
        while (DimletRandomizer.isDimletNotAllowedForWorldgen(allowRandom, key)) {
            key = (DimletKey)randomStructureDimlets.select(random);
        }
        return key;
    }

    public static DimletKey getRandomFluidBlock(Random random, boolean allowRandom) {
        DimletKey key = (DimletKey)randomLiquidDimlets.select(random);
        while (DimletRandomizer.isDimletNotAllowedForWorldgen(allowRandom, key)) {
            key = (DimletKey)randomLiquidDimlets.select(random);
        }
        return key;
    }

    public static DimletKey getRandomMaterialBlock(Random random, boolean allowRandom) {
        DimletKey key = (DimletKey)randomMaterialDimlets.select(random);
        while (DimletRandomizer.isDimletNotAllowedForWorldgen(allowRandom, key)) {
            key = (DimletKey)randomMaterialDimlets.select(random);
        }
        return key;
    }

    private static void setupRarity(WeightedRandomSelector<Integer, DimletKey> randomDimlets, float rarity0, float rarity1, float rarity2, float rarity3, float rarity4, float rarity5, float rarity6) {
        randomDimlets.addRarity((Object)0, rarity0);
        randomDimlets.addRarity((Object)1, rarity1);
        randomDimlets.addRarity((Object)2, rarity2);
        randomDimlets.addRarity((Object)3, rarity3);
        randomDimlets.addRarity((Object)4, rarity4);
        randomDimlets.addRarity((Object)5, rarity5);
        randomDimlets.addRarity((Object)6, rarity6);
    }

    public static DimletKey getRandomDimlet(float bonus, Random random) {
        WeightedRandomSelector.Distribution distribution = randomDimlets.createDistribution(bonus);
        return DimletRandomizer.getRandomDimlet((WeightedRandomSelector.Distribution<Integer>)distribution, random);
    }

    public static DimletKey getRandomDimlet(Random random) {
        DimletKey key = (DimletKey)randomDimlets.select(random);
        while (DimletRandomizer.isDimletNotAllowedForLoot(key)) {
            key = (DimletKey)randomDimlets.select(random);
        }
        return key;
    }

    public static DimletKey getRandomDimlet(WeightedRandomSelector.Distribution<Integer> distribution, Random random) {
        DimletKey key = (DimletKey)randomDimlets.select(distribution, random);
        while (DimletRandomizer.isDimletNotAllowedForLoot(key)) {
            key = (DimletKey)randomDimlets.select(distribution, random);
        }
        return key;
    }

    public static void dumpRarityDistribution(float bonus) {
        Random random = new Random();
        HashMap<DimletKey, Integer> counter = new HashMap<DimletKey, Integer>();
        WeightedRandomSelector.Distribution distribution = randomDimlets.createDistribution(bonus);
        DimletMapping mapping = DimletMapping.getInstance();
        for (DimletKey key : dimletIds) {
            counter.put(key, 0);
        }
        int total = 10000000;
        for (int i = 0; i < 10000000; ++i) {
            DimletKey id = (DimletKey)randomDimlets.select(distribution, random);
            counter.put(id, (Integer)counter.get(id) + 1);
        }
        Logging.log((String)("#### Dumping with bonus=" + bonus));
        ArrayList<Pair> sortedCounters = new ArrayList<Pair>();
        for (Map.Entry entry : counter.entrySet()) {
            sortedCounters.add(Pair.of(entry.getValue(), entry.getKey()));
        }
        Collections.sort(sortedCounters, new Comparator<Pair<Integer, DimletKey>>(){

            @Override
            public int compare(Pair<Integer, DimletKey> o1, Pair<Integer, DimletKey> o2) {
                return ((Integer)o1.getLeft()).compareTo((Integer)o2.getLeft());
            }
        });
        for (Pair pair : sortedCounters) {
            int count = (Integer)pair.getKey();
            DimletKey key = (DimletKey)pair.getValue();
            int id = mapping.getId(key);
            float percentage = (float)count * 100.0f / 1.0E7f;
            DimletRandomizer.formatDimletOutput(count, key, id, percentage);
        }
    }

    public static void dumpMaterialRarityDistribution(World world) {
        Random random = new Random();
        HashMap<DimletKey, Integer> counter = new HashMap<DimletKey, Integer>();
        for (DimletKey id : DimletObjectMapping.idToBlock.keySet()) {
            counter.put(id, 0);
        }
        DimletMapping mapping = DimletMapping.getDimletMapping(world);
        int total = 10000000;
        for (int i = 0; i < 10000000; ++i) {
            DimletKey key = (DimletKey)randomMaterialDimlets.select(random);
            counter.put(key, (Integer)counter.get(key) + 1);
        }
        Logging.log((String)"#### Dumping material distribution");
        ArrayList<Pair> sortedCounters = new ArrayList<Pair>();
        for (Map.Entry entry : counter.entrySet()) {
            sortedCounters.add(Pair.of(entry.getValue(), entry.getKey()));
        }
        Collections.sort(sortedCounters, new Comparator<Pair<Integer, DimletKey>>(){

            @Override
            public int compare(Pair<Integer, DimletKey> o1, Pair<Integer, DimletKey> o2) {
                return ((Integer)o1.getLeft()).compareTo((Integer)o2.getLeft());
            }
        });
        for (Pair pair : sortedCounters) {
            int count = (Integer)pair.getKey();
            DimletKey key = (DimletKey)pair.getValue();
            int id = mapping.getId(key);
            float percentage = (float)count * 100.0f / 1.0E7f;
            DimletRandomizer.formatDimletOutput(count, key, id, percentage);
        }
    }

    private static void formatDimletOutput(int count, DimletKey key, int id, float percentage) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        String name = KnownDimletConfiguration.idToDisplayName.get(key);
        DimletEntry de = KnownDimletConfiguration.getEntry(key);
        int rarity = -1;
        if (de != null) {
            rarity = de.getRarity();
        }
        formatter.format("Id:%1$-5d  Key:%2$-40.40s Name:%3$-40.40s [Count:%4$-8d %5$g%% R:%6$d]", id, key.toString(), name, count, Float.valueOf(percentage), rarity);
        Logging.log((String)sb.toString());
    }

    static {
        dimletIds = new ArrayList<DimletKey>();
        dimletBuiltinRarity = new HashMap<DimletKey, Integer>();
    }
}

