/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.dimlets.types;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mcjty.lib.varia.BlockTools;
import mcjty.rftools.blocks.dimletconstruction.DimletConstructionSetup;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.world.types.ControllerType;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletObjectMapping;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.items.dimlets.types.DimletCraftingTools;
import mcjty.rftools.items.dimlets.types.IDimletType;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeDimletType
implements IDimletType {
    private static final String CATEGORY_TYPE = "type_biome";
    private static int rarity = 1;
    private static int baseCreationCost = 100;
    private static int baseMaintainCost = 0;
    private static int baseTickCost = 1;

    @Override
    public String getName() {
        return "Biome";
    }

    @Override
    public String getOpcode() {
        return "B";
    }

    @Override
    public String getTextureName() {
        return "biomeDimlet";
    }

    @Override
    public void setupFromConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_TYPE, "Settings for the biome dimlet type");
        rarity = cfg.get(CATEGORY_TYPE, "rarity", rarity, "Default rarity for this dimlet type").getInt();
        baseCreationCost = cfg.get(CATEGORY_TYPE, "creation.cost", baseCreationCost, "Dimlet creation cost (how much power this dimlets adds during creation time of a dimension)").getInt();
        baseMaintainCost = cfg.get(CATEGORY_TYPE, "maintenance.cost", baseMaintainCost, "Dimlet maintenance cost (how much power this dimlet will use up to keep the dimension running)").getInt();
        baseTickCost = cfg.get(CATEGORY_TYPE, "tick.cost", baseTickCost, "Dimlet tick cost (how long it takes to make a dimension with this dimlet in it)").getInt();
    }

    @Override
    public int getRarity() {
        return rarity;
    }

    @Override
    public int getCreationCost() {
        return baseCreationCost;
    }

    @Override
    public int getMaintenanceCost() {
        return baseMaintainCost;
    }

    @Override
    public int getTickCost() {
        return baseTickCost;
    }

    @Override
    public boolean isModifier() {
        return false;
    }

    @Override
    public boolean isModifiedBy(DimletType type) {
        return false;
    }

    @Override
    public float getModifierCreateCostFactor(DimletType modifierType, DimletKey key) {
        return 1.0f;
    }

    @Override
    public float getModifierMaintainCostFactor(DimletType modifierType, DimletKey key) {
        return 1.0f;
    }

    @Override
    public float getModifierTickCostFactor(DimletType modifierType, DimletKey key) {
        return 1.0f;
    }

    @Override
    public boolean isInjectable() {
        return false;
    }

    @Override
    public void inject(DimletKey key, DimensionInformation dimensionInformation) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void constructDimension(List<Pair<DimletKey, List<DimletKey>>> dimlets, Random random, DimensionInformation dimensionInformation) {
        ControllerType controllerType;
        HashSet<Object> biomeKeys = new HashSet<Object>();
        List<Pair<DimletKey, List<DimletKey>>> biomeDimlets = DimensionInformation.extractType(DimletType.DIMLET_BIOME, dimlets);
        List<Pair<DimletKey, List<DimletKey>>> controllerDimlets = DimensionInformation.extractType(DimletType.DIMLET_CONTROLLER, dimlets);
        if (controllerDimlets.isEmpty()) {
            if (random.nextFloat() < DimletConfiguration.randomControllerChance) {
                ArrayList<DimletKey> keys = new ArrayList<DimletKey>(DimletObjectMapping.idToControllerType.keySet());
                DimletKey dimletKey = (DimletKey)keys.get(random.nextInt(keys.size()));
                controllerType = DimletObjectMapping.idToControllerType.get(dimletKey);
            } else {
                controllerType = biomeDimlets.isEmpty() ? ControllerType.CONTROLLER_DEFAULT : (biomeDimlets.size() > 1 ? ControllerType.CONTROLLER_FILTERED : ControllerType.CONTROLLER_SINGLE);
            }
        } else {
            DimletKey key2 = (DimletKey)controllerDimlets.get(random.nextInt(controllerDimlets.size())).getLeft();
            controllerType = DimletObjectMapping.idToControllerType.get(key2);
        }
        dimensionInformation.setControllerType(controllerType);
        for (Pair pair : biomeDimlets) {
            DimletKey key3 = (DimletKey)pair.getKey();
            biomeKeys.add(key3);
        }
        int neededBiomes = controllerType.getNeededBiomes();
        if (neededBiomes == -1) {
            neededBiomes = biomeKeys.size() >= 2 ? biomeKeys.size() : random.nextInt(10) + 3;
        }
        while (biomeKeys.size() < neededBiomes) {
            void var9_14;
            ArrayList<DimletKey> keys = new ArrayList<DimletKey>(DimletObjectMapping.idToBiome.keySet());
            DimletKey dimletKey = (DimletKey)keys.get(random.nextInt(keys.size()));
            while (biomeKeys.contains(var9_14)) {
                DimletKey dimletKey2 = (DimletKey)keys.get(random.nextInt(keys.size()));
            }
            biomeKeys.add(var9_14);
        }
        List<BiomeGenBase> list = dimensionInformation.getBiomes();
        list.clear();
        for (DimletKey key4 : biomeKeys) {
            list.add(DimletObjectMapping.idToBiome.get(key4));
        }
    }

    @Override
    public String[] getInformation() {
        return new String[]{"This dimlet controls the biomes that can generate in a dimension", "The controller specifies how they can be used."};
    }

    private static boolean isValidBiomeEssence(ItemStack stackEssence, NBTTagCompound essenceCompound) {
        Block essenceBlock = BlockTools.getBlock((ItemStack)stackEssence);
        if (essenceBlock != DimletConstructionSetup.biomeAbsorberBlock) {
            return false;
        }
        if (essenceCompound == null) {
            return false;
        }
        int absorbing = essenceCompound.func_74762_e("absorbing");
        int biome = essenceCompound.func_74762_e("biome");
        return absorbing <= 0 && biome != -1;
    }

    private static DimletKey findBiomeDimlet(NBTTagCompound essenceCompound) {
        int biomeID = essenceCompound.func_74762_e("biome");
        for (Map.Entry<DimletKey, BiomeGenBase> entry : DimletObjectMapping.idToBiome.entrySet()) {
            if (entry.getValue().field_76756_M != biomeID) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public DimletKey attemptDimletCrafting(ItemStack stackController, ItemStack stackMemory, ItemStack stackEnergy, ItemStack stackEssence) {
        if (!BiomeDimletType.isValidBiomeEssence(stackEssence, stackEssence.func_77978_p())) {
            return null;
        }
        DimletKey biomeDimlet = BiomeDimletType.findBiomeDimlet(stackEssence.func_77978_p());
        if (biomeDimlet == null) {
            return null;
        }
        if (!DimletCraftingTools.matchDimletRecipe(biomeDimlet, stackController, stackMemory, stackEnergy)) {
            return null;
        }
        return biomeDimlet;
    }
}

