/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.shapecard;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import java.util.List;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.ButtonEvent;
import mcjty.lib.gui.events.ChoiceEvent;
import mcjty.lib.gui.events.TextEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketUpdateNBTItem;
import mcjty.lib.varia.Coordinate;
import mcjty.rftools.items.shapecard.ShapeCardItem;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiShapeCard
extends GuiScreen {
    protected int xSize = 360;
    protected int ySize = 46;
    private boolean isQuarryCard;
    private ChoiceLabel shapeLabel;
    private TextField dimX;
    private TextField dimY;
    private TextField dimZ;
    private TextField offsetX;
    private TextField offsetY;
    private TextField offsetZ;
    private Window window;
    private Label blocksLabel;
    private Panel voidPanel;
    private ToggleButton stone;
    private ToggleButton cobble;
    private ToggleButton dirt;
    private ToggleButton gravel;
    private ToggleButton sand;
    private ToggleButton netherrack;
    private ToggleButton oredict;
    private boolean countDirty = true;
    private static int updateCounter = 20;

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        AbstractContainerWidget toplevel;
        super.func_73866_w_();
        this.shapeLabel = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setDesiredWidth(100)).setDesiredHeight(16)).addChoices(new String[]{ShapeCardItem.Shape.SHAPE_BOX.getDescription(), ShapeCardItem.Shape.SHAPE_TOPDOME.getDescription(), ShapeCardItem.Shape.SHAPE_BOTTOMDOME.getDescription(), ShapeCardItem.Shape.SHAPE_SPHERE.getDescription(), ShapeCardItem.Shape.SHAPE_CYLINDER.getDescription(), ShapeCardItem.Shape.SHAPE_CAPPEDCYLINDER.getDescription(), ShapeCardItem.Shape.SHAPE_PRISM.getDescription(), ShapeCardItem.Shape.SHAPE_TORUS.getDescription(), ShapeCardItem.Shape.SHAPE_SOLIDBOX.getDescription(), ShapeCardItem.Shape.SHAPE_SOLIDSPHERE.getDescription(), ShapeCardItem.Shape.SHAPE_SOLIDCYLINDER.getDescription(), ShapeCardItem.Shape.SHAPE_SOLIDTORUS.getDescription()}).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiShapeCard.this.updateSettings();
            }
        });
        ItemStack heldItem = this.field_146297_k.field_71439_g.func_70694_bm();
        if (heldItem == null) {
            return;
        }
        this.isQuarryCard = ShapeCardItem.isQuarry(heldItem.func_77960_j());
        if (this.isQuarryCard) {
            this.ySize = 74;
        }
        ShapeCardItem.Shape shape = ShapeCardItem.getShape(heldItem);
        this.shapeLabel.setChoice(shape.getDescription());
        this.blocksLabel = new Label(this.field_146297_k, (Gui)this).setText("# ").setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.blocksLabel.setDesiredWidth(100).setDesiredHeight(16);
        Panel modePanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new VerticalLayout()).setDesiredWidth(100)).addChild((Widget)this.shapeLabel)).addChild((Widget)this.blocksLabel);
        Coordinate dim = ShapeCardItem.getDimension(heldItem);
        Coordinate offset = ShapeCardItem.getOffset(heldItem);
        this.dimX = new TextField(this.field_146297_k, (Gui)this).addTextEvent(new TextEvent(){

            public void textChanged(Widget parent, String newText) {
                if (GuiShapeCard.this.isTorus()) {
                    GuiShapeCard.this.dimZ.setText(newText);
                }
                GuiShapeCard.this.updateSettings();
            }
        }).setText(String.valueOf(dim.getX()));
        this.dimY = new TextField(this.field_146297_k, (Gui)this).addTextEvent(new TextEvent(){

            public void textChanged(Widget parent, String newText) {
                GuiShapeCard.this.updateSettings();
            }
        }).setText(String.valueOf(dim.getY()));
        this.dimZ = new TextField(this.field_146297_k, (Gui)this).addTextEvent(new TextEvent(){

            public void textChanged(Widget parent, String newText) {
                GuiShapeCard.this.updateSettings();
            }
        }).setText(String.valueOf(dim.getZ()));
        Panel dimPanel = (Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout().setHorizontalMargin(0)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Dim:").setHorizontalAlignment(HorizontalAlignment.ALIGN_RIGHT).setDesiredWidth(70))).setDesiredHeight(18)).addChild((Widget)this.dimX)).addChild((Widget)this.dimY)).addChild((Widget)this.dimZ);
        this.offsetX = new TextField(this.field_146297_k, (Gui)this).addTextEvent(new TextEvent(){

            public void textChanged(Widget parent, String newText) {
                GuiShapeCard.this.updateSettings();
            }
        }).setText(String.valueOf(offset.getX()));
        this.offsetY = new TextField(this.field_146297_k, (Gui)this).addTextEvent(new TextEvent(){

            public void textChanged(Widget parent, String newText) {
                GuiShapeCard.this.updateSettings();
            }
        }).setText(String.valueOf(offset.getY()));
        this.offsetZ = new TextField(this.field_146297_k, (Gui)this).addTextEvent(new TextEvent(){

            public void textChanged(Widget parent, String newText) {
                GuiShapeCard.this.updateSettings();
            }
        }).setText(String.valueOf(offset.getZ()));
        Panel offsetPanel = (Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout().setHorizontalMargin(0)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Offset:").setHorizontalAlignment(HorizontalAlignment.ALIGN_RIGHT).setDesiredWidth(70))).setDesiredHeight(18)).addChild((Widget)this.offsetX)).addChild((Widget)this.offsetY)).addChild((Widget)this.offsetZ);
        Panel settingsPanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((VerticalLayout)((VerticalLayout)new VerticalLayout().setSpacing(1)).setVerticalMargin(1)).setHorizontalMargin(0)).addChild((Widget)dimPanel)).addChild((Widget)offsetPanel);
        int k = (this.field_146294_l - this.xSize) / 2;
        int l = (this.field_146295_m - this.ySize) / 2;
        Panel modeSettingsPanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout().setHorizontalMargin(0)).addChild((Widget)modePanel)).addChild((Widget)settingsPanel);
        if (this.isQuarryCard) {
            this.setupVoidPanel(heldItem);
            toplevel = ((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new VerticalLayout()).setFilledRectThickness(2)).addChild((Widget)modeSettingsPanel)).addChild((Widget)this.voidPanel);
        } else {
            toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new VerticalLayout()).setFilledRectThickness(2)).addChild((Widget)modeSettingsPanel);
        }
        toplevel.setBounds(new Rectangle(k, l, this.xSize, this.ySize));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private void setupVoidPanel(ItemStack heldItem) {
        this.voidPanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(26)).setFilledRectThickness(-2)).setFilledBackground(StyleConfig.colorListBackground);
        Label label = new Label(this.field_146297_k, (Gui)this).setText("Void:");
        this.stone = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void stone"})).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget widget) {
                GuiShapeCard.this.updateVoidSettings();
            }
        });
        this.cobble = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void cobble"})).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget widget) {
                GuiShapeCard.this.updateVoidSettings();
            }
        });
        this.dirt = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void dirt"})).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget widget) {
                GuiShapeCard.this.updateVoidSettings();
            }
        });
        this.gravel = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void gravel"})).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget widget) {
                GuiShapeCard.this.updateVoidSettings();
            }
        });
        this.sand = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void sand"})).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget widget) {
                GuiShapeCard.this.updateVoidSettings();
            }
        });
        this.netherrack = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setDesiredWidth(20)).setDesiredHeight(20)).setTooltips(new String[]{"Void netherrack"})).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget widget) {
                GuiShapeCard.this.updateVoidSettings();
            }
        });
        this.oredict = ((ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setDesiredWidth(60)).setDesiredHeight(15)).setTooltips(new String[]{"Enable ore dictionary matching"})).setText("Oredict")).setCheckMarker(true).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget widget) {
                GuiShapeCard.this.updateVoidSettings();
            }
        });
        this.stone.setPressed(ShapeCardItem.isVoiding(heldItem, "stone"));
        this.cobble.setPressed(ShapeCardItem.isVoiding(heldItem, "cobble"));
        this.dirt.setPressed(ShapeCardItem.isVoiding(heldItem, "dirt"));
        this.gravel.setPressed(ShapeCardItem.isVoiding(heldItem, "gravel"));
        this.sand.setPressed(ShapeCardItem.isVoiding(heldItem, "sand"));
        this.netherrack.setPressed(ShapeCardItem.isVoiding(heldItem, "netherrack"));
        this.oredict.setPressed(ShapeCardItem.isOreDictionary(heldItem));
        ((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)this.voidPanel.addChild((Widget)label)).addChild((Widget)this.stone)).addChild((Widget)this.cobble)).addChild((Widget)this.dirt)).addChild((Widget)this.gravel)).addChild((Widget)this.sand)).addChild((Widget)this.netherrack)).addChild((Widget)this.oredict);
    }

    private boolean isTorus() {
        ShapeCardItem.Shape shape = this.getCurrentShape();
        return ShapeCardItem.Shape.SHAPE_TORUS.equals((Object)shape) || ShapeCardItem.Shape.SHAPE_SOLIDTORUS.equals((Object)shape);
    }

    private ShapeCardItem.Shape getCurrentShape() {
        return ShapeCardItem.Shape.getShape(this.shapeLabel.getCurrentChoice());
    }

    private Coordinate getCurrentDimension() {
        return new Coordinate(GuiShapeCard.parseInt(this.dimX.getText()), GuiShapeCard.parseInt(this.dimY.getText()), GuiShapeCard.parseInt(this.dimZ.getText()));
    }

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void updateSettings() {
        this.countDirty = true;
        if (this.isTorus()) {
            this.dimZ.setText(this.dimX.getText());
        }
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateNBTItem(new Argument[]{new Argument("shape", this.getCurrentShape().getIndex()), new Argument("dimX", GuiShapeCard.parseInt(this.dimX.getText())), new Argument("dimY", GuiShapeCard.parseInt(this.dimY.getText())), new Argument("dimZ", GuiShapeCard.parseInt(this.dimZ.getText())), new Argument("offsetX", GuiShapeCard.parseInt(this.offsetX.getText())), new Argument("offsetY", GuiShapeCard.parseInt(this.offsetY.getText())), new Argument("offsetZ", GuiShapeCard.parseInt(this.offsetZ.getText()))}));
    }

    private void updateVoidSettings() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateNBTItem(new Argument[]{new Argument("voidstone", this.stone.isPressed()), new Argument("voidcobble", this.cobble.isPressed()), new Argument("voiddirt", this.dirt.isPressed()), new Argument("voidgravel", this.gravel.isPressed()), new Argument("voidsand", this.sand.isPressed()), new Argument("voidnetherrack", this.netherrack.isPressed()), new Argument("oredict", this.oredict.isPressed())}));
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.window.mouseClicked(x, y, button);
    }

    public void func_146274_d() {
        super.func_146274_d();
        this.window.handleMouseInput();
    }

    protected void func_146286_b(int x, int y, int button) {
        super.func_146286_b(x, y, button);
        this.window.mouseMovedOrUp(x, y, button);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        super.func_73869_a(typedChar, keyCode);
        this.window.keyTyped(typedChar, keyCode);
    }

    public void func_73863_a(int xSize_lo, int ySize_lo, float par3) {
        List tooltips;
        super.func_73863_a(xSize_lo, ySize_lo, par3);
        this.dimZ.setEnabled(!this.isTorus());
        if (--updateCounter <= 0) {
            updateCounter = 10;
            if (this.countDirty) {
                this.countDirty = false;
                int count = ShapeCardItem.countBlocks(this.getCurrentShape(), this.getCurrentDimension());
                if (count >= 50000000) {
                    this.blocksLabel.setText("#Blocks: ++" + count);
                } else {
                    this.blocksLabel.setText("#Blocks: " + count);
                }
            }
        }
        this.window.draw();
        if (this.isQuarryCard) {
            int x = (int)(this.window.getToplevel().getBounds().getX() + this.voidPanel.getBounds().getX()) + 1;
            int y = (int)(this.window.getToplevel().getBounds().getY() + this.voidPanel.getBounds().getY() + this.stone.getBounds().getY()) + 1;
            this.renderVoidBlock(x, y, this.stone, Blocks.field_150348_b);
            this.renderVoidBlock(x, y, this.cobble, Blocks.field_150347_e);
            this.renderVoidBlock(x, y, this.dirt, Blocks.field_150346_d);
            this.renderVoidBlock(x, y, this.gravel, Blocks.field_150351_n);
            this.renderVoidBlock(x, y, this.sand, (Block)Blocks.field_150354_m);
            this.renderVoidBlock(x, y, this.netherrack, Blocks.field_150424_aL);
        }
        if ((tooltips = this.window.getTooltips()) != null) {
            int guiLeft = (this.field_146294_l - this.xSize) / 2;
            int guiTop = (this.field_146295_m - this.ySize) / 2;
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.drawHoveringText(tooltips, x - guiLeft, y - guiTop, this.field_146297_k.field_71466_p);
        }
    }

    private void renderVoidBlock(int x, int y, ToggleButton button, Block block) {
        RenderHelper.renderObject((Minecraft)Minecraft.func_71410_x(), (int)(x += (int)button.getBounds().getX()), (int)y, (Object)new ItemStack(block), (boolean)button.isPressed());
        if (button.isPressed()) {
            GuiShapeCard.drawLine(x - 1, y - 1, x + 18, y + 18, -65536);
            GuiShapeCard.drawLine(x + 18, y - 1, x - 1, y + 18, -65536);
        }
    }

    private static void drawLine(int x1, int y1, int x2, int y2, int color) {
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glLineWidth((float)2.0f);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)f, (float)f1, (float)f2, (float)f3);
        tessellator.func_78371_b(1);
        tessellator.func_78377_a((double)x1, (double)y1, 0.0);
        tessellator.func_78377_a((double)x2, (double)y2, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
    }
}

