/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.mac;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.unix.LibCAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.ByRef;
import oshi.jna.platform.mac.SystemB;

@ThreadSafe
public final class SysctlUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SysctlUtil.class);
    private static final String SYSCTL_FAIL = "Failed sysctl call: {}, Error code: {}";

    private SysctlUtil() {
    }

    public static int sysctl(String string, int n) {
        return SysctlUtil.sysctl(string, n, true);
    }

    public static int sysctl(String string, int n, boolean bl) {
        int n2 = com.sun.jna.platform.mac.SystemB.INT_SIZE;
        try (Memory memory = new Memory(n2);){
            ByRef.CloseableSizeTByReference closeableSizeTByReference;
            block13: {
                closeableSizeTByReference = new ByRef.CloseableSizeTByReference((long)n2);
                try {
                    if (0 == SystemB.INSTANCE.sysctlbyname(string, (Pointer)memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) break block13;
                    if (bl) {
                        LOG.warn(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
                    }
                    int n3 = n;
                    closeableSizeTByReference.close();
                    return n3;
                }
                catch (Throwable throwable) {
                    try {
                        closeableSizeTByReference.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            int n4 = memory.getInt(0L);
            closeableSizeTByReference.close();
            return n4;
        }
    }

    public static long sysctl(String string, long l) {
        int n = com.sun.jna.platform.mac.SystemB.UINT64_SIZE;
        try (Memory memory = new Memory(n);){
            ByRef.CloseableSizeTByReference closeableSizeTByReference;
            block12: {
                closeableSizeTByReference = new ByRef.CloseableSizeTByReference((long)n);
                try {
                    if (0 == SystemB.INSTANCE.sysctlbyname(string, (Pointer)memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) break block12;
                    LOG.warn(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
                    long l2 = l;
                    closeableSizeTByReference.close();
                    return l2;
                }
                catch (Throwable throwable) {
                    try {
                        closeableSizeTByReference.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            long l3 = memory.getLong(0L);
            closeableSizeTByReference.close();
            return l3;
        }
    }

    public static String sysctl(String string, String string2) {
        try (ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference();){
            Memory memory;
            block14: {
                if (0 != SystemB.INSTANCE.sysctlbyname(string, null, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                    LOG.warn(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
                    String string3 = string2;
                    return string3;
                }
                memory = new Memory(closeableSizeTByReference.longValue() + 1L);
                try {
                    if (0 == SystemB.INSTANCE.sysctlbyname(string, (Pointer)memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) break block14;
                    LOG.warn(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
                    String string4 = string2;
                    memory.close();
                    return string4;
                }
                catch (Throwable throwable) {
                    try {
                        memory.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            String string5 = memory.getString(0L);
            memory.close();
            return string5;
        }
    }

    public static boolean sysctl(String string, Structure structure) {
        try (ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference((long)structure.size());){
            if (0 != SystemB.INSTANCE.sysctlbyname(string, structure.getPointer(), closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                LOG.warn(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
                boolean bl = false;
                return bl;
            }
        }
        structure.read();
        return true;
    }

    public static Memory sysctl(String string) {
        try (ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference();){
            if (0 != SystemB.INSTANCE.sysctlbyname(string, null, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                LOG.warn(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
                Memory memory = null;
                return memory;
            }
            Memory memory = new Memory(closeableSizeTByReference.longValue());
            if (0 != SystemB.INSTANCE.sysctlbyname(string, (Pointer)memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                LOG.warn(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
                memory.close();
                Memory memory2 = null;
                return memory2;
            }
            Memory memory3 = memory;
            return memory3;
        }
    }
}

