/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.IOException;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.security.spec.InvalidKeySpecException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.managers.GsonManager;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public final class Launcher {
    public static final AtomicBoolean LAUNCHED = new AtomicBoolean(false);
    public static final String RUNTIME_DIR = "runtime";
    public static final String CONFIG_FILE = "config.bin";
    private static final AtomicReference<LauncherConfig> CONFIG = new AtomicReference();
    private static final Pattern UUID_PATTERN = Pattern.compile("-", 16);
    public static ClientProfile profile;
    public static GsonManager gsonManager;

    public static LauncherConfig getConfig() {
        LauncherConfig launcherConfig = CONFIG.get();
        if (launcherConfig == null) {
            try (HInput hInput = new HInput(IOHelper.newInput(IOHelper.getResourceURL(CONFIG_FILE)));){
                launcherConfig = new LauncherConfig(hInput);
            }
            catch (IOException | InvalidKeySpecException exception) {
                throw new SecurityException(exception);
            }
            CONFIG.set(launcherConfig);
        }
        return launcherConfig;
    }

    public static void setConfig(LauncherConfig launcherConfig) {
        CONFIG.set(launcherConfig);
    }

    public static URL getResourceURL(String string) throws IOException {
        LauncherConfig launcherConfig = Launcher.getConfig();
        byte[] byArray = launcherConfig.runtime.get(string);
        if (byArray == null) {
            throw new NoSuchFileException(string);
        }
        URL uRL = IOHelper.getResourceURL("runtime/" + string);
        return uRL;
    }

    public static URL getResourceURL(String string, String string2) throws IOException {
        LauncherConfig launcherConfig = Launcher.getConfig();
        byte[] byArray = launcherConfig.runtime.get(string);
        if (byArray == null) {
            throw new NoSuchFileException(string);
        }
        URL uRL = IOHelper.getResourceURL(string2 + '/' + string);
        return uRL;
    }

    public static String toHash(UUID uUID) {
        return UUID_PATTERN.matcher(uUID.toString()).replaceAll("");
    }

    public static void applyLauncherEnv(LauncherConfig.LauncherEnvironment launcherEnvironment) {
        switch (launcherEnvironment) {
            case DEV: {
                LogHelper.setDevEnabled(true);
                LogHelper.setStacktraceEnabled(true);
                LogHelper.setDebugEnabled(true);
                break;
            }
            case DEBUG: {
                LogHelper.setDebugEnabled(true);
                LogHelper.setStacktraceEnabled(true);
                break;
            }
            case STD: {
                break;
            }
            case PROD: {
                LogHelper.setStacktraceEnabled(false);
                LogHelper.setDebugEnabled(false);
                LogHelper.setDevEnabled(false);
            }
        }
    }

    public static String makeSpecialGuardDirName(JVMHelper.ARCH aRCH, JVMHelper.OS oS) {
        return String.format("%s-%s", aRCH.name, oS.name);
    }
}

