/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pro.gravit.launcher.BasicLauncherEventHandler;
import pro.gravit.launcher.ClientLauncherMethods;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherAgent;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.api.AuthService;
import pro.gravit.launcher.api.ClientService;
import pro.gravit.launcher.api.KeyService;
import pro.gravit.launcher.client.ClientLauncherCoreModule;
import pro.gravit.launcher.client.ClientModuleManager;
import pro.gravit.launcher.client.ClientParams;
import pro.gravit.launcher.client.events.client.ClientProcessClassLoaderEvent;
import pro.gravit.launcher.client.events.client.ClientProcessInitPhase;
import pro.gravit.launcher.client.events.client.ClientProcessLaunchEvent;
import pro.gravit.launcher.client.events.client.ClientProcessPreInvokeMainClassEvent;
import pro.gravit.launcher.client.events.client.ClientProcessReadyEvent;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.hasher.HashedEntry;
import pro.gravit.launcher.modules.events.PreConfigPhase;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.ClientProfileVersions;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.profiles.optional.actions.OptionalActionClassPath;
import pro.gravit.launcher.profiles.optional.actions.OptionalActionClientArgs;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.websockets.StdWebSocketService;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.utils.DirWatcher;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.launch.BasicLaunch;
import pro.gravit.utils.launch.ClassLoaderControl;
import pro.gravit.utils.launch.Launch;
import pro.gravit.utils.launch.LaunchOptions;
import pro.gravit.utils.launch.LegacyLaunch;
import pro.gravit.utils.launch.ModuleLaunch;

public class ClientLauncherEntryPoint {
    public static ClientModuleManager modulesManager;
    public static ClientParams clientParams;
    private static Launch launch;
    private static ClassLoaderControl classLoaderControl;

    private static ClientParams readParams(SocketAddress socketAddress) throws IOException {
        try (Socket socket = IOHelper.newSocket();){
            ClientParams clientParams;
            socket.connect(socketAddress);
            try (HInput hInput = new HInput(socket.getInputStream());){
                byte[] byArray = hInput.readByteArray(0);
                ClientParams clientParams2 = Launcher.gsonManager.gson.fromJson(IOHelper.decode(byArray), ClientParams.class);
                clientParams2.clientHDir = new HashedDir(hInput);
                clientParams2.assetHDir = new HashedDir(hInput);
                boolean bl = hInput.readBoolean();
                if (bl) {
                    clientParams2.javaHDir = new HashedDir(hInput);
                }
                clientParams = clientParams2;
            }
            return clientParams;
        }
    }

    public static void main(String[] stringArray) {
        JVMHelper.verifySystemProperties(ClientLauncherEntryPoint.class, true);
        EnvHelper.checkDangerousParams();
        JVMHelper.checkStackTrace(ClientLauncherEntryPoint.class);
        LogHelper.printVersion("Client Launcher");
        ClientLauncherMethods.checkClass(ClientLauncherEntryPoint.class);
        try {
            ClientLauncherEntryPoint.realMain(stringArray);
        }
        catch (Throwable throwable) {
            LogHelper.error(throwable);
        }
    }

    private static void realMain(String[] stringArray) throws Throwable {
        Object object;
        RequestService requestService;
        ClientProfile clientProfile;
        modulesManager = new ClientModuleManager();
        modulesManager.loadModule(new ClientLauncherCoreModule());
        LauncherConfig.initModules(modulesManager);
        modulesManager.initModules(null);
        ClientLauncherMethods.initGson(modulesManager);
        modulesManager.invokeEvent(new PreConfigPhase());
        LogHelper.debug("Reading ClientLauncher params");
        ClientParams clientParams = ClientLauncherEntryPoint.readParams(new InetSocketAddress("127.0.0.1", Launcher.getConfig().clientPort));
        if (clientParams.profile.getClassLoaderConfig() != ClientProfile.ClassLoaderConfig.AGENT) {
            ClientLauncherMethods.verifyNoAgent();
        }
        Launcher.profile = clientProfile = clientParams.profile;
        AuthService.profile = clientProfile;
        ClientLauncherEntryPoint.clientParams = clientParams;
        if (clientParams.oauth != null) {
            LogHelper.info("Using OAuth");
            if (clientParams.oauthExpiredTime != 0L) {
                Request.setOAuth(clientParams.authId, clientParams.oauth, clientParams.oauthExpiredTime);
            } else {
                Request.setOAuth(clientParams.authId, clientParams.oauth);
            }
            if (clientParams.extendedTokens != null) {
                Request.addAllExtendedToken(clientParams.extendedTokens);
            }
        } else if (clientParams.session != null) {
            throw new UnsupportedOperationException("Legacy session not supported");
        }
        modulesManager.invokeEvent(new ClientProcessInitPhase(clientParams));
        Path path = Paths.get(clientParams.clientDir, new String[0]);
        Path path3 = Paths.get(clientParams.assetDir, new String[0]);
        LogHelper.debug("Verifying ClientLauncher sign and classpath");
        List list = ClientLauncherEntryPoint.resolveClassPath(path, clientParams.actions, clientParams.profile).filter(path2 -> !clientProfile.getModulePath().contains(path.relativize((Path)path2).toString())).collect(Collectors.toCollection(ArrayList::new));
        List<URL> list2 = list.stream().map(IOHelper::toURL).collect(Collectors.toList());
        if (clientParams.offlineMode) {
            requestService = ClientLauncherMethods.initOffline(modulesManager, clientParams);
            Request.setRequestService(requestService);
        } else {
            requestService = StdWebSocketService.initWebSockets(Launcher.getConfig().address).get();
            Request.setRequestService(requestService);
            LogHelper.debug("Restore sessions");
            Request.restore(false, false, true);
            requestService.registerEventHandler(new BasicLauncherEventHandler());
            ((StdWebSocketService)requestService).reconnectCallback = () -> {
                LogHelper.debug("WebSocket connect closed. Try reconnect");
                try {
                    Request.reconnect();
                }
                catch (Exception exception) {
                    LogHelper.error(exception);
                    throw new RequestException("Connection failed", exception);
                }
            };
        }
        LogHelper.debug("Natives dir %s", clientParams.nativesDir);
        ClientProfile.ClassLoaderConfig classLoaderConfig = clientProfile.getClassLoaderConfig();
        LaunchOptions launchOptions = new LaunchOptions();
        launchOptions.enableHacks = clientProfile.hasFlag(ClientProfile.CompatibilityFlags.ENABLE_HACKS);
        launchOptions.moduleConf = clientProfile.getModuleConf();
        if (classLoaderConfig == ClientProfile.ClassLoaderConfig.LAUNCHER) {
            launch = JVMHelper.JVM_VERSION <= 11 ? new LegacyLaunch() : new ModuleLaunch();
            classLoaderControl = launch.init(list, clientParams.nativesDir, launchOptions);
            System.setProperty("java.class.path", list.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
            modulesManager.invokeEvent(new ClientProcessClassLoaderEvent(launch, classLoaderControl, clientProfile));
            ClientService.nativePath = clientParams.nativesDir;
            ClientService.baseURLs = classLoaderControl.getURLs();
        } else if (classLoaderConfig == ClientProfile.ClassLoaderConfig.AGENT) {
            launch = new BasicLaunch(LauncherAgent.inst);
            list2.add(IOHelper.getCodeSource(ClientLauncherEntryPoint.class).toUri().toURL());
            classLoaderControl = launch.init(list, clientParams.nativesDir, launchOptions);
            for (URL object22 : list2) {
                LauncherAgent.addJVMClassPath(Paths.get(object22.toURI()));
            }
            ClientService.instrumentation = LauncherAgent.inst;
            ClientService.nativePath = clientParams.nativesDir;
            modulesManager.invokeEvent(new ClientProcessClassLoaderEvent(launch, null, clientProfile));
            ClientService.baseURLs = list2.toArray(new URL[0]);
        } else if (classLoaderConfig == ClientProfile.ClassLoaderConfig.SYSTEM_ARGS) {
            launch = new BasicLaunch();
            classLoaderControl = launch.init(list, clientParams.nativesDir, launchOptions);
            ClientService.baseURLs = list2.toArray(new URL[0]);
            ClientService.nativePath = clientParams.nativesDir;
        }
        if (clientProfile.hasFlag(ClientProfile.CompatibilityFlags.CLASS_CONTROL_API)) {
            ClientService.classLoaderControl = classLoaderControl;
        }
        if (clientParams.lwjglGlfwWayland) {
            object = ClientService.findLibrary("glfw_wayland");
            System.setProperty("org.lwjgl.glfw.libname", (String)object);
        }
        AuthService.username = clientParams.playerProfile.username;
        AuthService.uuid = clientParams.playerProfile.uuid;
        KeyService.serverRsaPublicKey = Launcher.getConfig().rsaPublicKey;
        KeyService.serverEcPublicKey = Launcher.getConfig().ecdsaPublicKey;
        modulesManager.invokeEvent(new ClientProcessReadyEvent(clientParams));
        LogHelper.debug("Starting JVM and client WatchService");
        object = clientProfile.getAssetUpdateMatcher();
        FileNameMatcher fileNameMatcher = clientProfile.getClientUpdateMatcher();
        Path path4 = Paths.get(System.getProperty("java.home"), new String[0]);
        try (DirWatcher dirWatcher = new DirWatcher(path3, clientParams.assetHDir, (FileNameMatcher)object, true);
             DirWatcher dirWatcher2 = new DirWatcher(path, clientParams.clientHDir, fileNameMatcher, true);
             DirWatcher dirWatcher3 = clientParams.javaHDir == null ? null : new DirWatcher(path4, clientParams.javaHDir, null, true);){
            CommonHelper.newThread("Asset Directory Watcher", true, dirWatcher).start();
            CommonHelper.newThread("Client Directory Watcher", true, dirWatcher2).start();
            if (dirWatcher3 != null) {
                CommonHelper.newThread("Java Directory Watcher", true, dirWatcher3).start();
            }
            ClientLauncherEntryPoint.verifyHDir(path3, clientParams.assetHDir, (FileNameMatcher)object, false, false);
            ClientLauncherEntryPoint.verifyHDir(path, clientParams.clientHDir, fileNameMatcher, false, true);
            if (dirWatcher3 != null) {
                ClientLauncherEntryPoint.verifyHDir(path4, clientParams.javaHDir, null, false, true);
            }
            modulesManager.invokeEvent(new ClientProcessLaunchEvent(clientParams));
            ClientLauncherEntryPoint.launch(clientProfile, clientParams);
        }
    }

    public static void verifyHDir(Path path, HashedDir hashedDir, FileNameMatcher fileNameMatcher, boolean bl, boolean bl2) throws IOException {
        HashedDir hashedDir2 = new HashedDir(path, fileNameMatcher, true, bl);
        HashedDir.Diff diff = hashedDir.diff(hashedDir2, fileNameMatcher);
        AtomicReference<String> atomicReference = new AtomicReference<String>("unknown");
        if (!diff.mismatch.isEmpty() || bl2 && !diff.extra.isEmpty()) {
            diff.extra.walk(File.separator, (string, string2, hashedEntry) -> {
                if (hashedEntry.getType().equals(HashedEntry.Type.FILE)) {
                    LogHelper.error("Extra file %s", string);
                    atomicReference.set(string);
                } else {
                    LogHelper.error("Extra %s", string);
                }
                return HashedDir.WalkAction.CONTINUE;
            });
            diff.mismatch.walk(File.separator, (string, string2, hashedEntry) -> {
                if (hashedEntry.getType().equals(HashedEntry.Type.FILE)) {
                    LogHelper.error("Mismatch file %s", string);
                    atomicReference.set(string);
                } else {
                    LogHelper.error("Mismatch %s", string);
                }
                return HashedDir.WalkAction.CONTINUE;
            });
            throw new SecurityException(String.format("Forbidden modification: '%s' file '%s'", IOHelper.getFileName(path), atomicReference.get()));
        }
    }

    private static LinkedList<Path> resolveClassPathList(Path path, String ... stringArray) throws IOException {
        return ClientLauncherEntryPoint.resolveClassPathStream(path, stringArray).collect(Collectors.toCollection(LinkedList::new));
    }

    private static Stream<Path> resolveClassPathStream(Path path, String ... stringArray) throws IOException {
        Stream.Builder<Path> builder = Stream.builder();
        for (String string : stringArray) {
            Path path2 = path.resolve(IOHelper.toPath(string.replace("/", IOHelper.PLATFORM_SEPARATOR)));
            if (IOHelper.isDir(path2)) {
                IOHelper.walk(path2, new ClassPathFileVisitor(builder), false);
                continue;
            }
            builder.accept(path2);
        }
        return builder.build();
    }

    public static Stream<Path> resolveClassPath(Path path, Set<OptionalAction> set, ClientProfile clientProfile) throws IOException {
        Stream<Path> stream = ClientLauncherEntryPoint.resolveClassPathStream(path, clientProfile.getClassPath());
        for (OptionalAction optionalAction : set) {
            if (!(optionalAction instanceof OptionalActionClassPath)) continue;
            stream = Stream.concat(stream, ClientLauncherEntryPoint.resolveClassPathStream(path, ((OptionalActionClassPath)optionalAction).args));
        }
        return stream;
    }

    private static void launch(ClientProfile clientProfile, ClientParams clientParams) throws Throwable {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (clientProfile.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_6_4) >= 0) {
            clientParams.addClientArgs(linkedList);
        } else {
            clientParams.addClientLegacyArgs(linkedList);
            System.setProperty("minecraft.applet.TargetDirectory", clientParams.clientDir);
        }
        Collections.addAll(linkedList, clientProfile.getClientArgs());
        for (OptionalAction optionalAction : clientParams.actions) {
            if (!(optionalAction instanceof OptionalActionClientArgs)) continue;
            linkedList.addAll(((OptionalActionClientArgs)optionalAction).args);
        }
        ArrayList<String> arrayList = new ArrayList<String>(linkedList);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            if (i + 1 >= n || !"--accessToken".equals(string) && !"--session".equals(string)) continue;
            arrayList.set(i + 1, "censored");
        }
        LogHelper.debug("Args: " + arrayList);
        modulesManager.invokeEvent(new ClientProcessPreInvokeMainClassEvent(clientParams, clientProfile, linkedList));
        try {
            List<String> list = clientProfile.getCompatClasses();
            for (String string : list) {
                Class<?> clazz = classLoaderControl.getClass(string);
                MethodHandle methodHandle = MethodHandles.lookup().findStatic(clazz, "run", MethodType.methodType(Void.TYPE, ClassLoaderControl.class));
                methodHandle.invoke(classLoaderControl);
            }
            Launcher.LAUNCHED.set(true);
            JVMHelper.fullGC();
            launch.launch(clientParams.profile.getMainClass(), clientParams.profile.getMainModule(), linkedList);
            LogHelper.debug("Main exit successful");
        }
        catch (Throwable throwable) {
            LogHelper.error(throwable);
            throw throwable;
        }
        finally {
            ClientLauncherMethods.exitLauncher(0);
        }
    }

    private static final class ClassPathFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Stream.Builder<Path> result;

        private ClassPathFileVisitor(Stream.Builder<Path> builder) {
            this.result = builder;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            if (IOHelper.hasExtension(path, "jar") || IOHelper.hasExtension(path, "zip")) {
                this.result.accept(path);
            }
            return super.visitFile(path, basicFileAttributes);
        }
    }
}

