/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.impl;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashSet;
import java.util.Set;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.client.gui.overlays.ProcessingOverlay;
import pro.gravit.launcher.client.gui.overlays.UploadAssetOverlay;
import pro.gravit.launcher.client.gui.overlays.WelcomeOverlay;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.console.ConsoleScene;
import pro.gravit.launcher.client.gui.scenes.debug.DebugScene;
import pro.gravit.launcher.client.gui.scenes.internal.BrowserScene;
import pro.gravit.launcher.client.gui.scenes.login.LoginScene;
import pro.gravit.launcher.client.gui.scenes.options.OptionsScene;
import pro.gravit.launcher.client.gui.scenes.serverinfo.ServerInfoScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerMenuScene;
import pro.gravit.launcher.client.gui.scenes.settings.SettingsScene;
import pro.gravit.launcher.client.gui.scenes.update.UpdateScene;
import pro.gravit.launcher.client.gui.stage.ConsoleStage;
import pro.gravit.utils.helper.LogHelper;

public class GuiObjectsContainer {
    private final JavaFXApplication application;
    private final Set<AbstractOverlay> overlays = new HashSet<AbstractOverlay>();
    private final Set<AbstractScene> scenes = new HashSet<AbstractScene>();
    public ProcessingOverlay processingOverlay;
    public WelcomeOverlay welcomeOverlay;
    public UploadAssetOverlay uploadAssetOverlay;
    public UpdateScene updateScene;
    public DebugScene debugScene;
    public ServerMenuScene serverMenuScene;
    public ServerInfoScene serverInfoScene;
    public LoginScene loginScene;
    public OptionsScene optionsScene;
    public SettingsScene settingsScene;
    public ConsoleScene consoleScene;
    public ConsoleStage consoleStage;
    public BrowserScene browserScene;

    public GuiObjectsContainer(JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
    }

    public void init() {
        this.loginScene = this.registerScene(LoginScene.class);
        this.processingOverlay = this.registerOverlay(ProcessingOverlay.class);
        this.welcomeOverlay = this.registerOverlay(WelcomeOverlay.class);
        this.uploadAssetOverlay = this.registerOverlay(UploadAssetOverlay.class);
        this.serverMenuScene = this.registerScene(ServerMenuScene.class);
        this.serverInfoScene = this.registerScene(ServerInfoScene.class);
        this.optionsScene = this.registerScene(OptionsScene.class);
        this.settingsScene = this.registerScene(SettingsScene.class);
        this.consoleScene = this.registerScene(ConsoleScene.class);
        this.updateScene = this.registerScene(UpdateScene.class);
        this.debugScene = this.registerScene(DebugScene.class);
        this.browserScene = this.registerScene(BrowserScene.class);
    }

    public void reload() throws Exception {
        Class<?> clazz = this.application.getCurrentScene().getClass();
        ContextHelper.runInFxThreadStatic(() -> {
            this.application.getMainStage().setScene(null);
            this.application.resetDirectory();
            this.overlays.clear();
            this.scenes.clear();
            this.init();
            for (AbstractScene abstractScene : this.scenes) {
                if (abstractScene.getClass() != clazz) continue;
                this.application.getMainStage().setScene(abstractScene);
            }
        }).get();
    }

    public AbstractScene getSceneByName(String string) {
        for (AbstractScene abstractScene : this.scenes) {
            if (!string.equals(abstractScene.getName())) continue;
            return abstractScene;
        }
        return null;
    }

    public AbstractOverlay getOverlayByName(String string) {
        for (AbstractOverlay abstractOverlay : this.overlays) {
            if (!string.equals(abstractOverlay.getName())) continue;
            return abstractOverlay;
        }
        return null;
    }

    public <T extends AbstractOverlay> T registerOverlay(Class<T> clazz) {
        try {
            AbstractOverlay abstractOverlay = (AbstractOverlay)MethodHandles.publicLookup().findConstructor(clazz, MethodType.methodType(Void.TYPE, JavaFXApplication.class)).invokeWithArguments(new Object[]{this.application});
            this.overlays.add(abstractOverlay);
            return (T)abstractOverlay;
        }
        catch (Throwable throwable) {
            LogHelper.error(throwable);
            throw new RuntimeException(throwable);
        }
    }

    public <T extends AbstractScene> T registerScene(Class<T> clazz) {
        try {
            AbstractScene abstractScene = (AbstractScene)MethodHandles.publicLookup().findConstructor(clazz, MethodType.methodType(Void.TYPE, JavaFXApplication.class)).invokeWithArguments(new Object[]{this.application});
            this.scenes.add(abstractScene);
            return (T)abstractScene;
        }
        catch (Throwable throwable) {
            LogHelper.error(throwable);
            throw new RuntimeException(throwable);
        }
    }
}

