/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.overlays;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.FadeTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.util.Duration;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.impl.AbstractStage;
import pro.gravit.launcher.client.gui.impl.AbstractVisualComponent;

public abstract class AbstractOverlay
extends AbstractVisualComponent {
    private final AtomicInteger useCounter = new AtomicInteger(0);
    private final AtomicReference<FadeTransition> fadeTransition = new AtomicReference();

    protected AbstractOverlay(String string, JavaFXApplication javaFXApplication) {
        super(string, javaFXApplication);
    }

    @Override
    public final void init() throws Exception {
        super.init();
    }

    public final void hide(double d, EventHandler<ActionEvent> eventHandler) {
        if (this.useCounter.decrementAndGet() != 0) {
            this.contextHelper.runInFxThread(() -> {
                if (eventHandler != null) {
                    eventHandler.handle(null);
                }
            });
            return;
        }
        if (!this.isInit()) {
            throw new IllegalStateException("Using method hide before init");
        }
        this.fadeTransition.set(AbstractOverlay.fade((Node)this.getFxmlRoot(), d, 1.0, 0.0, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (eventHandler != null) {
                eventHandler.handle(actionEvent);
            }
            this.currentStage.pull((Node)this.getFxmlRoot());
            this.currentStage.enable();
            this.fadeTransition.set(null);
        })));
    }

    @Override
    protected abstract void doInit();

    @Override
    protected void doPostInit() {
    }

    @Override
    public abstract void reset();

    @Override
    public void disable() {
    }

    @Override
    public void enable() {
    }

    public void show(AbstractStage abstractStage, EventHandler<ActionEvent> eventHandler) throws Exception {
        if (!this.isInit()) {
            this.init();
        }
        if (this.useCounter.incrementAndGet() != 1) {
            this.contextHelper.runInFxThread(() -> {
                if (eventHandler != null) {
                    eventHandler.handle(null);
                }
            });
            return;
        }
        if (this.fadeTransition.get() != null) {
            this.fadeTransition.get().jumpTo(Duration.ZERO);
            this.fadeTransition.get().stop();
            this.contextHelper.runInFxThread(() -> {
                if (eventHandler != null) {
                    eventHandler.handle(null);
                }
            });
            this.fadeTransition.set(null);
            return;
        }
        Parent parent = this.getFxmlRoot();
        this.currentStage = abstractStage;
        this.currentStage.enableMouseDrag((Node)this.layout);
        this.currentStage.push((Node)parent);
        this.currentStage.disable();
        AbstractOverlay.fade((Node)parent, 100.0, 0.0, 1.0, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (eventHandler != null) {
                eventHandler.handle(actionEvent);
            }
        }));
    }
}

