/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.debug;

import java.io.EOFException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.TextArea;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import pro.gravit.launcher.client.JavaRuntimeModule;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.service.LaunchService;
import pro.gravit.utils.helper.LogHelper;

public class DebugScene
extends AbstractScene
implements LaunchService.ClientInstance.ProcessListener {
    private static final long MAX_LENGTH = 32768L;
    private static final int REMOVE_LENGTH = 4096;
    private LaunchService.ClientInstance clientInstance;
    private TextArea output;
    private final Object syncObject = new Object();
    private String appendString = "";
    private boolean isOutputRunned;

    public DebugScene(JavaFXApplication javaFXApplication) {
        super("scenes/debug/debug.fxml", javaFXApplication);
        this.isResetOnShow = true;
    }

    @Override
    protected void doInit() {
        this.output = (TextArea)LookupHelper.lookup((Node)this.layout, "#output");
        LookupHelper.lookupIfPossible((Node)this.header, "#controls", "#kill").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> {
            if (this.clientInstance != null) {
                this.clientInstance.kill();
            }
        }));
        LookupHelper.lookupIfPossible((Node)this.layout, "#version").ifPresent(label -> label.setText(JavaRuntimeModule.getMiniLauncherInfo()));
        LookupHelper.lookupIfPossible((Node)this.header, "#controls", "#copy").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> {
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.putString(this.output.getText());
            Clipboard clipboard = Clipboard.getSystemClipboard();
            clipboard.setContent((Map)clipboardContent);
        }));
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#back")).setOnAction(actionEvent -> {
            if (this.clientInstance != null) {
                this.clientInstance.unregisterListener(this);
            }
            try {
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
    }

    @Override
    public void reset() {
        this.output.clear();
    }

    public void onClientInstance(LaunchService.ClientInstance clientInstance) {
        this.clientInstance = clientInstance;
        this.clientInstance.registerListener(this);
        ((CompletableFuture)this.clientInstance.getOnWriteParamsFuture().thenAccept(void_ -> this.append("[START] Write param successful\n"))).exceptionally(throwable -> {
            this.errorHandle((Throwable)throwable);
            return null;
        });
        ((CompletableFuture)this.clientInstance.start().thenAccept(n -> this.append(String.format("[START] Process exit with code %d", n)))).exceptionally(throwable -> {
            this.errorHandle((Throwable)throwable);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String string) {
        boolean bl = false;
        Object object = this.syncObject;
        synchronized (object) {
            this.appendString = (long)this.appendString.length() > 32768L ? "<logs buffer overflow>\n".concat(string) : this.appendString.concat(string);
            if (!this.isOutputRunned) {
                bl = true;
                this.isOutputRunned = true;
            }
        }
        if (bl) {
            ContextHelper.runInFxThreadStatic(() -> {
                Object object = this.syncObject;
                synchronized (object) {
                    if ((long)this.output.lengthProperty().get() > 32768L) {
                        this.output.deleteText(0, 4096);
                    }
                    this.output.appendText(this.appendString);
                    this.appendString = "";
                    this.isOutputRunned = false;
                }
            });
        }
    }

    @Override
    public void errorHandle(Throwable throwable) {
        if (!(throwable instanceof EOFException) && LogHelper.isDebugEnabled()) {
            this.append(throwable.toString());
        }
    }

    @Override
    public String getName() {
        return "debug";
    }

    @Override
    public void onNext(byte[] byArray, int n, int n2) {
        this.append(new String(byArray, n, n2));
    }
}

