/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.login.methods;

import java.util.concurrent.CompletableFuture;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.scenes.login.LoginScene;
import pro.gravit.launcher.client.gui.scenes.login.methods.AbstractAuthMethod;
import pro.gravit.launcher.request.auth.details.AuthTotpDetails;
import pro.gravit.launcher.request.auth.password.AuthTOTPPassword;

public class TotpAuthMethod
extends AbstractAuthMethod<AuthTotpDetails> {
    private final TotpOverlay overlay;
    private final JavaFXApplication application;
    private final LoginScene.LoginSceneAccessor accessor;

    public TotpAuthMethod(LoginScene.LoginSceneAccessor loginSceneAccessor) {
        this.accessor = loginSceneAccessor;
        this.application = loginSceneAccessor.getApplication();
        this.overlay = new TotpOverlay(this.application);
        this.overlay.accessor = loginSceneAccessor;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void reset() {
        this.overlay.reset();
    }

    @Override
    public CompletableFuture<Void> show(AuthTotpDetails authTotpDetails) {
        this.overlay.maxLength = authTotpDetails.maxKeyLength;
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        try {
            ContextHelper.runInFxThreadStatic(() -> {
                this.accessor.showContent(this.overlay);
                completableFuture.complete(null);
            });
        }
        catch (Exception exception) {
            this.accessor.errorHandle(exception);
        }
        return completableFuture;
    }

    @Override
    public CompletableFuture<LoginScene.LoginAndPasswordResult> auth(AuthTotpDetails authTotpDetails) {
        this.overlay.future = new CompletableFuture();
        String string = this.overlay.getCode();
        if (string != null && !string.isEmpty()) {
            AuthTOTPPassword authTOTPPassword = new AuthTOTPPassword();
            authTOTPPassword.totp = string;
            return CompletableFuture.completedFuture(new LoginScene.LoginAndPasswordResult(null, authTOTPPassword));
        }
        return this.overlay.future;
    }

    @Override
    public void onAuthClicked() {
        this.overlay.complete();
    }

    @Override
    public void onUserCancel() {
        this.overlay.future.completeExceptionally(TotpOverlay.USER_AUTH_CANCELED_EXCEPTION);
    }

    @Override
    public CompletableFuture<Void> hide() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isOverlay() {
        return true;
    }

    public static class TotpOverlay
    extends AbstractVisualComponent {
        private static final AbstractAuthMethod.UserAuthCanceledException USER_AUTH_CANCELED_EXCEPTION = new AbstractAuthMethod.UserAuthCanceledException();
        private TextField totpField;
        private CompletableFuture<LoginScene.LoginAndPasswordResult> future;
        private LoginScene.LoginSceneAccessor accessor;
        private int maxLength;

        public TotpOverlay(JavaFXApplication javaFXApplication) {
            super("scenes/login/methods/totp.fxml", javaFXApplication);
        }

        @Override
        public String getName() {
            return "totp";
        }

        @Override
        protected void doInit() {
            this.totpField = (TextField)LookupHelper.lookup((Node)this.layout, "#totp");
            this.totpField.textProperty().addListener((observableValue, string, string2) -> {
                if (string2 != null && string2.length() == this.maxLength) {
                    this.complete();
                }
            });
            this.totpField.setOnAction(actionEvent -> {
                if (this.totpField.getText() != null && this.totpField.getText().length() > 0) {
                    this.complete();
                }
            });
        }

        @Override
        protected void doPostInit() {
        }

        public void complete() {
            AuthTOTPPassword authTOTPPassword = new AuthTOTPPassword();
            authTOTPPassword.totp = this.getCode();
            this.future.complete(new LoginScene.LoginAndPasswordResult(null, authTOTPPassword));
        }

        public void requestFocus() {
            this.totpField.requestFocus();
        }

        public String getCode() {
            return this.totpField.getText();
        }

        @Override
        public void reset() {
            if (this.totpField == null) {
                return;
            }
            this.totpField.setText("");
        }

        @Override
        public void disable() {
        }

        @Override
        public void enable() {
        }
    }
}

