/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.serverinfo;

import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerButton;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerMenuScene;
import pro.gravit.launcher.client.gui.service.LaunchService;
import pro.gravit.launcher.client.gui.utils.JavaFxUtils;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.utils.helper.LogHelper;

public class ServerInfoScene
extends AbstractScene {
    private ImageView avatar;
    private Image originalAvatarImage;
    private ServerButton serverButton;

    public ServerInfoScene(JavaFXApplication javaFXApplication) {
        super("scenes/serverinfo/serverinfo.fxml", javaFXApplication);
    }

    @Override
    protected void doInit() {
        this.avatar = (ImageView)LookupHelper.lookup((Node)this.layout, "#avatar");
        this.originalAvatarImage = this.avatar.getImage();
        LookupHelper.lookupIfPossible((Node)this.layout, "#avatar").ifPresent(imageView -> {
            try {
                JavaFxUtils.setStaticRadius(imageView, 8.0);
                imageView.setImage(this.originalAvatarImage);
            }
            catch (Throwable throwable) {
                LogHelper.warning("Skin head error");
            }
        });
        ((Button)LookupHelper.lookup((Node)this.header, "#back")).setOnAction(actionEvent -> {
            try {
                this.switchScene(this.application.gui.serverMenuScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#clientSettings")).setOnAction(actionEvent -> {
            try {
                if (this.application.profilesService.getProfile() == null) {
                    return;
                }
                this.switchScene(this.application.gui.optionsScene);
                this.application.gui.optionsScene.reset();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#settings")).setOnAction(actionEvent -> {
            try {
                this.switchScene(this.application.gui.settingsScene);
                this.application.gui.settingsScene.reset();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        this.reset();
    }

    @Override
    public void reset() {
        this.avatar.setImage(this.originalAvatarImage);
        ClientProfile clientProfile = this.application.profilesService.getProfile();
        LookupHelper.lookupIfPossible((Node)this.layout, "#serverName").ifPresent(label -> label.setText(clientProfile.getTitle()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#serverDescriptionPane").ifPresent(scrollPane -> {
            Label label = (Label)scrollPane.getContent();
            label.setText(clientProfile.getInfo());
        });
        LookupHelper.lookupIfPossible((Node)this.layout, "#nickname").ifPresent(label -> label.setText(this.application.authService.getUsername()));
        Pane pane = (Pane)LookupHelper.lookup((Node)this.layout, "#serverButton");
        pane.getChildren().clear();
        this.serverButton = ServerMenuScene.getServerButton(this.application, clientProfile);
        this.serverButton.addTo(pane);
        this.resetAvatar();
        this.serverButton.enableSaveButton(this.application.getTranslation("runtime.scenes.serverinfo.serverButton.game"), (EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.runClient()));
    }

    public void resetAvatar() {
        if (this.avatar == null) {
            return;
        }
        JavaFxUtils.putAvatarToImageView(this.application, this.application.authService.getUsername(), this.avatar);
    }

    private void runClient() {
        ((CompletableFuture)this.application.launchService.launchClient().thenAccept(clientInstance -> {
            if (clientInstance.getSettings().debug) {
                this.contextHelper.runInFxThread(() -> {
                    try {
                        this.switchScene(this.application.gui.debugScene);
                        this.application.gui.debugScene.onClientInstance((LaunchService.ClientInstance)clientInstance);
                    }
                    catch (Exception exception) {
                        this.errorHandle(exception);
                    }
                });
            } else {
                clientInstance.start();
                ((CompletableFuture)clientInstance.getOnWriteParamsFuture().thenAccept(void_ -> {
                    LogHelper.info("Params write successful. Exit...");
                    Platform.exit();
                })).exceptionally(throwable -> {
                    this.contextHelper.runInFxThread(() -> this.errorHandle((Throwable)throwable));
                    return null;
                });
            }
        })).exceptionally(throwable -> {
            this.contextHelper.runInFxThread(() -> this.errorHandle((Throwable)throwable));
            return null;
        });
    }

    @Override
    public String getName() {
        return null;
    }
}

