/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.settings;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Slider;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import javafx.util.StringConverter;
import oshi.SystemInfo;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.config.RuntimeSettings;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerButton;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerMenuScene;
import pro.gravit.launcher.client.gui.scenes.settings.JavaSelectorComponent;
import pro.gravit.launcher.client.gui.stage.ConsoleStage;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class SettingsScene
extends AbstractScene {
    private static final long MAX_JAVA_MEMORY_X64 = 32768L;
    private static final long MAX_JAVA_MEMORY_X32 = 1536L;
    private Pane componentList;
    private Pane settingsList;
    private Label ramLabel;
    private Slider ramSlider;
    private RuntimeSettings.ProfileSettingsView profileSettings;
    private JavaSelectorComponent javaSelector;

    public SettingsScene(JavaFXApplication javaFXApplication) {
        super("scenes/settings/settings.fxml", javaFXApplication);
    }

    @Override
    protected void doInit() {
        long l;
        SystemInfo systemInfo;
        this.componentList = (Pane)((ScrollPane)LookupHelper.lookup((Node)this.layout, "#settingslist")).getContent();
        this.settingsList = (Pane)LookupHelper.lookup((Node)this.componentList, "#settings-list");
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#console")).setOnAction(actionEvent -> {
            try {
                if (this.application.gui.consoleStage == null) {
                    this.application.gui.consoleStage = new ConsoleStage(this.application);
                }
                if (this.application.gui.consoleStage.isNullScene()) {
                    this.application.gui.consoleStage.setScene(this.application.gui.consoleScene);
                }
                this.application.gui.consoleStage.show();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        this.ramSlider = (Slider)LookupHelper.lookup((Node)this.componentList, "#ramSlider");
        this.ramLabel = (Label)LookupHelper.lookup((Node)this.componentList, "#ramLabel");
        try {
            systemInfo = new SystemInfo();
            l = systemInfo.getHardware().getMemory().getTotal() >> 20;
        }
        catch (Throwable throwable) {
            LogHelper.error(throwable);
            l = 2048L;
        }
        this.ramSlider.setMax((double)Math.min(l, this.getJavaMaxMemory()));
        this.ramSlider.setSnapToTicks(true);
        this.ramSlider.setShowTickMarks(true);
        this.ramSlider.setShowTickLabels(true);
        this.ramSlider.setMinorTickCount(1);
        this.ramSlider.setMajorTickUnit(1024.0);
        this.ramSlider.setBlockIncrement(1024.0);
        this.ramSlider.setLabelFormatter((StringConverter)new StringConverter<Double>(){

            public String toString(Double d) {
                return "%.0fG".formatted(d / 1024.0);
            }

            public Double fromString(String string) {
                return null;
            }
        });
        systemInfo = (Hyperlink)LookupHelper.lookup((Node)this.componentList, "#folder", "#path");
        systemInfo.setText(DirBridge.dirUpdates.toAbsolutePath().toString());
        systemInfo.setOnAction(actionEvent -> this.application.openURL(DirBridge.dirUpdates.toAbsolutePath().toString()));
        ((ButtonBase)LookupHelper.lookup((Node)this.componentList, "#changeDir")).setOnAction(arg_0 -> this.lambda$doInit$2((Hyperlink)systemInfo, arg_0));
        LookupHelper.lookupIfPossible((Node)this.layout, "#deleteDir").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> this.application.messageManager.showApplyDialog(this.application.getTranslation("runtime.scenes.settings.deletedir.header"), this.application.getTranslation("runtime.scenes.settings.deletedir.description"), () -> {
            LogHelper.debug("Delete dir: %s", DirBridge.dirUpdates);
            try {
                IOHelper.deleteDir(DirBridge.dirUpdates, false);
            }
            catch (IOException iOException) {
                LogHelper.error(iOException);
                this.application.messageManager.createNotification(this.application.getTranslation("runtime.scenes.settings.deletedir.fail.header"), this.application.getTranslation("runtime.scenes.settings.deletedir.fail.description"));
            }
        }, () -> {}, true)));
        LookupHelper.lookupIfPossible((Node)this.header, "#back").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> {
            try {
                this.profileSettings = null;
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        this.reset();
    }

    private long getJavaMaxMemory() {
        if (this.application.javaService.isArchAvailable(JVMHelper.ARCH.X86_64) || this.application.javaService.isArchAvailable(JVMHelper.ARCH.ARM64)) {
            return 32768L;
        }
        return 1536L;
    }

    @Override
    public void reset() {
        this.profileSettings = new RuntimeSettings.ProfileSettingsView(this.application.getProfileSettings());
        this.javaSelector = new JavaSelectorComponent(this.application.javaService, this.componentList, this.profileSettings, this.application.profilesService.getProfile());
        this.ramSlider.setValue((double)this.profileSettings.ram);
        this.ramSlider.valueProperty().addListener((observableValue, number, number2) -> {
            this.profileSettings.ram = number2.intValue();
            this.updateRamLabel();
        });
        this.updateRamLabel();
        Pane pane = (Pane)LookupHelper.lookup((Node)this.layout, "#serverButton");
        pane.getChildren().clear();
        ClientProfile clientProfile = this.application.profilesService.getProfile();
        ServerButton serverButton = ServerMenuScene.getServerButton(this.application, clientProfile);
        serverButton.addTo(pane);
        serverButton.enableSaveButton(null, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            try {
                this.profileSettings.apply();
                this.application.triggerManager.process(clientProfile, this.application.profilesService.getOptionalView());
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        serverButton.enableResetButton(null, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.reset()));
        this.settingsList.getChildren().clear();
        this.add("Debug", this.profileSettings.debug, bl -> {
            this.profileSettings.debug = bl;
        });
        this.add("AutoEnter", this.profileSettings.autoEnter, bl -> {
            this.profileSettings.autoEnter = bl;
        });
        this.add("Fullscreen", this.profileSettings.fullScreen, bl -> {
            this.profileSettings.fullScreen = bl;
        });
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            this.add("WaylandSupport", this.profileSettings.waylandSupport, bl -> {
                this.profileSettings.waylandSupport = bl;
            });
        }
    }

    @Override
    public String getName() {
        return "settings";
    }

    public void add(String string, boolean bl, Consumer<Boolean> consumer) {
        String string2 = "runtime.scenes.settings.properties.%s.name".formatted(string.toLowerCase());
        String string3 = "runtime.scenes.settings.properties.%s.description".formatted(string.toLowerCase());
        this.add(this.application.getTranslation(string2, string), this.application.getTranslation(string3, string), bl, consumer);
    }

    public void add(String string, String string2, boolean bl, Consumer<Boolean> consumer) {
        HBox hBox = new HBox();
        CheckBox checkBox = new CheckBox();
        Label label = new Label();
        Label label2 = new Label();
        VBox vBox = new VBox();
        hBox.getStyleClass().add((Object)"settings-container");
        checkBox.getStyleClass().add((Object)"settings-checkbox");
        label.getStyleClass().add((Object)"settings-label-header");
        label2.getStyleClass().add((Object)"settings-label");
        checkBox.setSelected(bl);
        checkBox.setOnAction(actionEvent -> consumer.accept(checkBox.isSelected()));
        label.setText(string);
        label2.setText(string2);
        label2.setWrapText(true);
        vBox.getChildren().add((Object)label);
        vBox.getChildren().add((Object)label2);
        hBox.getChildren().add((Object)checkBox);
        hBox.getChildren().add((Object)vBox);
        this.settingsList.getChildren().add((Object)hBox);
    }

    public void updateRamLabel() {
        this.ramLabel.setText(this.profileSettings.ram == 0 ? this.application.getTranslation("runtime.scenes.settings.ramAuto") : MessageFormat.format(this.application.getTranslation("runtime.scenes.settings.ram"), this.profileSettings.ram));
    }

    private /* synthetic */ void lambda$doInit$2(Hyperlink hyperlink, ActionEvent actionEvent) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle(this.application.getTranslation("runtime.scenes.settings.dirTitle"));
        directoryChooser.setInitialDirectory(DirBridge.dir.toFile());
        File file = directoryChooser.showDialog((Window)this.application.getMainStage().getStage());
        if (file == null) {
            return;
        }
        Path path = file.toPath().toAbsolutePath();
        try {
            DirBridge.move(path);
        }
        catch (IOException iOException) {
            this.errorHandle(iOException);
        }
        this.application.runtimeSettings.updatesDirPath = path.toString();
        this.application.runtimeSettings.updatesDir = path;
        String string = DirBridge.dirUpdates.toString();
        DirBridge.dirUpdates = path;
        for (ClientProfile clientProfile : this.application.profilesService.getProfiles()) {
            RuntimeSettings.ProfileSettings profileSettings = this.application.getProfileSettings(clientProfile);
            if (profileSettings.javaPath == null || !profileSettings.javaPath.startsWith(string)) continue;
            profileSettings.javaPath = path.toString().concat(profileSettings.javaPath.substring(string.length()));
        }
        this.application.javaService.update();
        this.javaSelector.reset();
        hyperlink.setText(this.application.runtimeSettings.updatesDirPath);
    }
}

