/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.update;

import java.nio.file.Path;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.update.VisualDownloader;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.profiles.optional.OptionalView;
import pro.gravit.utils.helper.LogHelper;

public class UpdateScene
extends AbstractScene {
    private ProgressBar progressBar;
    private Label speed;
    private Label volume;
    private TextArea logOutput;
    private Button cancel;
    private Label speedtext;
    private Label speederr;
    private Pane speedon;
    private VisualDownloader downloader;
    private volatile DownloadStatus downloadStatus = DownloadStatus.COMPLETE;

    public UpdateScene(JavaFXApplication javaFXApplication) {
        super("scenes/update/update.fxml", javaFXApplication);
    }

    @Override
    protected void doInit() {
        this.progressBar = (ProgressBar)LookupHelper.lookup((Node)this.layout, "#progress");
        this.speed = (Label)LookupHelper.lookup((Node)this.layout, "#speed");
        this.speederr = (Label)LookupHelper.lookup((Node)this.layout, "#speedErr");
        this.speedon = (Pane)LookupHelper.lookup((Node)this.layout, "#speedOn");
        this.speedtext = (Label)LookupHelper.lookup((Node)this.layout, "#speed-text");
        this.cancel = (Button)LookupHelper.lookup((Node)this.layout, "#cancel");
        this.volume = (Label)LookupHelper.lookup((Node)this.layout, "#volume");
        this.logOutput = (TextArea)LookupHelper.lookup((Node)this.layout, "#outputUpdate");
        this.logOutput.setText("");
        this.downloader = new VisualDownloader(this.application, this.progressBar, this.speed, this.volume, this::errorHandle, string -> this.contextHelper.runInFxThread(() -> this.addLog((String)string)), this::onUpdateStatus);
        ((ButtonBase)LookupHelper.lookup((Node)this.layout, "#cancel")).setOnAction(actionEvent -> {
            if (this.downloadStatus == DownloadStatus.DOWNLOAD && this.downloader.isDownload()) {
                this.downloader.cancel();
            } else if (this.downloadStatus == DownloadStatus.ERROR || this.downloadStatus == DownloadStatus.COMPLETE) {
                try {
                    this.switchScene(this.application.gui.serverInfoScene);
                }
                catch (Exception exception) {
                    this.errorHandle(exception);
                }
            }
        });
    }

    private void onUpdateStatus(DownloadStatus downloadStatus) {
        this.downloadStatus = downloadStatus;
        LogHelper.debug("Update download status: %s", downloadStatus.toString());
    }

    public void sendUpdateAssetRequest(String string, Path path, FileNameMatcher fileNameMatcher, boolean bl, String string2, Consumer<HashedDir> consumer) {
        this.downloader.sendUpdateAssetRequest(string, path, fileNameMatcher, bl, string2, consumer);
    }

    public void sendUpdateRequest(String string, Path path, FileNameMatcher fileNameMatcher, boolean bl, OptionalView optionalView, boolean bl2, Consumer<HashedDir> consumer) {
        this.downloader.sendUpdateRequest(string, path, fileNameMatcher, bl, optionalView, bl2, consumer);
    }

    public void addLog(String string) {
        LogHelper.dev("Update event %s", string);
        this.logOutput.appendText(string.concat("\n"));
    }

    @Override
    public void reset() {
        this.progressBar.progressProperty().setValue((Number)0);
        this.logOutput.clear();
        this.volume.setText("");
        this.speed.setText("0");
        this.progressBar.getStyleClass().removeAll((Object[])new String[]{"progress"});
        this.speed.getStyleClass().removeAll((Object[])new String[]{"speedError"});
        this.speederr.setVisible(false);
        this.speedon.setVisible(true);
    }

    @Override
    public void errorHandle(Throwable throwable) {
        if (throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        this.addLog("Exception %s: %s".formatted(throwable.getClass(), throwable.getMessage() == null ? "" : throwable.getMessage()));
        this.progressBar.getStyleClass().add((Object)"progressError");
        this.speederr.setVisible(true);
        this.speedon.setVisible(false);
        LogHelper.error(throwable);
    }

    @Override
    public String getName() {
        return "update";
    }

    public static enum DownloadStatus {
        ERROR,
        HASHING,
        REQUEST,
        DOWNLOAD,
        COMPLETE,
        DELETE;

    }
}

