/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.service;

import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.OptionalView;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class ProfilesService {
    private final JavaFXApplication application;
    private List<ClientProfile> profiles;
    private ClientProfile profile;
    private Map<ClientProfile, OptionalView> optionalViewMap;

    public ProfilesService(JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
    }

    public Map<ClientProfile, OptionalView> getOptionalViewMap() {
        return this.optionalViewMap;
    }

    public OptionalView getOptionalView() {
        return this.optionalViewMap.get(this.profile);
    }

    public OptionalView getOptionalView(ClientProfile clientProfile) {
        return this.optionalViewMap.get(clientProfile);
    }

    public void setOptionalView(ClientProfile clientProfile, OptionalView optionalView) {
        this.optionalViewMap.put(clientProfile, optionalView);
    }

    public void setProfilesResult(ProfilesRequestEvent profilesRequestEvent) {
        this.profiles = profilesRequestEvent.profiles;
        this.profiles.sort(ClientProfile::compareTo);
        if (this.optionalViewMap == null) {
            this.optionalViewMap = new HashMap<ClientProfile, OptionalView>();
        }
        for (ClientProfile clientProfile : this.profiles) {
            clientProfile.updateOptionalGraph();
            OptionalView optionalView = this.optionalViewMap.get(clientProfile);
            OptionalView optionalView2 = optionalView != null ? new OptionalView(clientProfile, optionalView) : new OptionalView(clientProfile);
            this.optionalViewMap.put(clientProfile, optionalView2);
        }
        for (ClientProfile clientProfile : this.profiles) {
            this.application.triggerManager.process(clientProfile, this.getOptionalView(clientProfile));
        }
    }

    public List<ClientProfile> getProfiles() {
        return this.profiles;
    }

    public ClientProfile getProfile() {
        return this.profile;
    }

    public void setProfile(ClientProfile clientProfile) {
        this.profile = clientProfile;
    }

    public void saveAll() throws IOException {
        if (this.profiles == null) {
            return;
        }
        Path path = DirBridge.dir.resolve("options.json");
        ArrayList<OptionalListEntry> arrayList = new ArrayList<OptionalListEntry>(5);
        for (ClientProfile clientProfile : this.profiles) {
            OptionalListEntry optionalListEntry = new OptionalListEntry();
            optionalListEntry.name = clientProfile.getTitle();
            optionalListEntry.profileUUID = clientProfile.getUUID();
            OptionalView optionalView = this.optionalViewMap.get(clientProfile);
            optionalView.all.forEach(optionalFile -> {
                if (optionalFile.visible) {
                    boolean bl = optionalView.enabled.contains(optionalFile);
                    OptionalView.OptionalFileInstallInfo optionalFileInstallInfo = optionalView.installInfo.get(optionalFile);
                    optionalListEntry.enabled.add(new OptionalListEntryPair((OptionalFile)optionalFile, bl, optionalFileInstallInfo));
                }
            });
            arrayList.add(optionalListEntry);
        }
        try (BufferedWriter bufferedWriter = IOHelper.newWriter(path);){
            Launcher.gsonManager.gson.toJson(arrayList, (Appendable)bufferedWriter);
        }
    }

    public void loadAll() throws IOException {
        if (this.profiles == null) {
            return;
        }
        Path path = DirBridge.dir.resolve("options.json");
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Type type = new TypeToken<List<OptionalListEntry>>(){}.getType();
        try (BufferedReader bufferedReader = IOHelper.newReader(path);){
            List list = (List)Launcher.gsonManager.gson.fromJson((Reader)bufferedReader, type);
            for (OptionalListEntry optionalListEntry : list) {
                ClientProfile object2 = null;
                for (ClientProfile clientProfile : this.profiles) {
                    if (!(optionalListEntry.profileUUID != null ? optionalListEntry.profileUUID.equals(clientProfile.getUUID()) : clientProfile.getTitle().equals(optionalListEntry.name))) continue;
                    object2 = clientProfile;
                }
                if (object2 == null) {
                    LogHelper.warning("Optional: profile %s(%s) not found", optionalListEntry.name, optionalListEntry.profileUUID);
                    continue;
                }
                OptionalView optionalView = this.optionalViewMap.get(object2);
                for (OptionalListEntryPair optionalListEntryPair : optionalListEntry.enabled) {
                    try {
                        OptionalFile optionalFile = object2.getOptionalFile(optionalListEntryPair.name);
                        if (!optionalFile.visible) continue;
                        if (optionalListEntryPair.mark) {
                            optionalView.enable(optionalFile, optionalListEntryPair.installInfo != null && optionalListEntryPair.installInfo.isManual, null);
                            continue;
                        }
                        optionalView.disable(optionalFile, null);
                    }
                    catch (Exception exception) {
                        LogHelper.warning("Optional: in profile %s markOptional mod %s failed", object2.getTitle(), optionalListEntryPair.name);
                    }
                }
            }
        }
    }

    public static class OptionalListEntry {
        @LauncherNetworkAPI
        public List<OptionalListEntryPair> enabled = new LinkedList<OptionalListEntryPair>();
        @LauncherNetworkAPI
        public String name;
        @LauncherNetworkAPI
        public UUID profileUUID;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            OptionalListEntry optionalListEntry = (OptionalListEntry)object;
            return Objects.equals(this.profileUUID, optionalListEntry.profileUUID) && Objects.equals(this.name, optionalListEntry.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.profileUUID);
        }
    }

    public static class OptionalListEntryPair {
        @LauncherNetworkAPI
        public String name;
        @LauncherNetworkAPI
        public boolean mark;
        @LauncherNetworkAPI
        public OptionalView.OptionalFileInstallInfo installInfo;

        public OptionalListEntryPair(OptionalFile optionalFile, boolean bl, OptionalView.OptionalFileInstallInfo optionalFileInstallInfo) {
            this.name = optionalFile.name;
            this.mark = bl;
            this.installInfo = optionalFileInstallInfo;
        }
    }
}

