/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.hasher.HashedEntry;
import pro.gravit.utils.helper.IOHelper;

public class AssetIndexHelper {
    public static AssetIndex parse(Path path) throws IOException {
        try (BufferedReader bufferedReader = IOHelper.newReader(path);){
            AssetIndex assetIndex = Launcher.gsonManager.gson.fromJson((Reader)bufferedReader, AssetIndex.class);
            return assetIndex;
        }
    }

    public static void modifyHashedDir(AssetIndex assetIndex, HashedDir hashedDir) {
        HashSet<String> hashSet = new HashSet<String>();
        for (AssetIndexObject object2 : assetIndex.objects.values()) {
            hashSet.add(object2.hash);
        }
        HashedDir hashedDir2 = (HashedDir)hashedDir.getEntry("objects");
        ArrayList<String> arrayList = new ArrayList<String>(16);
        for (Map.Entry<String, HashedEntry> entry : hashedDir2.map().entrySet()) {
            if (entry.getValue().getType() != HashedEntry.Type.DIR) continue;
            HashedDir hashedDir3 = (HashedDir)entry.getValue();
            ArrayList<String> arrayList2 = new ArrayList<String>(16);
            for (String string : hashedDir3.map().keySet()) {
                if (hashSet.contains(string)) continue;
                arrayList2.add(string);
            }
            for (String string : arrayList2) {
                hashedDir3.remove(string);
            }
            if (!hashedDir3.map().isEmpty()) continue;
            arrayList.add((String)entry.getKey());
        }
        for (Map.Entry<String, HashedEntry> entry : arrayList) {
            hashedDir2.remove((String)((Object)entry));
        }
    }

    public static class AssetIndex {
        @LauncherNetworkAPI
        public boolean virtual;
        @LauncherNetworkAPI
        public Map<String, AssetIndexObject> objects;
    }

    public static class AssetIndexObject {
        @LauncherNetworkAPI
        public String hash;
        @LauncherNetworkAPI
        public long size;
    }
}

