/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.hasher;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.hasher.HashedEntry;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class HashedFile
extends HashedEntry {
    public static final SecurityHelper.DigestAlgorithm DIGEST_ALGO = SecurityHelper.DigestAlgorithm.SHA1;
    @LauncherNetworkAPI
    public final long size;
    @LauncherNetworkAPI
    private final byte[] digest;

    public HashedFile(HInput hInput) throws IOException {
        this(hInput.readVarLong(), hInput.readBoolean() ? hInput.readByteArray(-HashedFile.DIGEST_ALGO.bytes) : null);
    }

    public HashedFile(long l, byte[] byArray) {
        this.size = VerifyHelper.verifyLong(l, VerifyHelper.L_NOT_NEGATIVE, "Illegal size: " + l);
        this.digest = byArray == null ? null : (byte[])DIGEST_ALGO.verify(byArray).clone();
    }

    public HashedFile(Path path, long l, boolean bl) throws IOException {
        this(l, bl ? SecurityHelper.digest(DIGEST_ALGO, path) : null);
    }

    @Override
    public HashedEntry.Type getType() {
        return HashedEntry.Type.FILE;
    }

    public boolean isSame(HashedFile hashedFile) {
        return this.size == hashedFile.size && (this.digest == null || hashedFile.digest == null || Arrays.equals(this.digest, hashedFile.digest));
    }

    public boolean isSame(Path path, boolean bl) throws IOException {
        if (this.size != IOHelper.readAttributes(path).size()) {
            return false;
        }
        if (!bl || this.digest == null) {
            return true;
        }
        byte[] byArray = SecurityHelper.digest(DIGEST_ALGO, path);
        return Arrays.equals(this.digest, byArray);
    }

    public boolean isSameDigest(byte[] byArray) {
        return this.digest == null || byArray == null || Arrays.equals(this.digest, byArray);
    }

    @Override
    public long size() {
        return this.size;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    @Override
    public void write(HOutput hOutput) throws IOException {
        hOutput.writeVarLong(this.size);
        hOutput.writeBoolean(this.digest != null);
        if (this.digest != null) {
            hOutput.writeByteArray(this.digest, -HashedFile.DIGEST_ALGO.bytes);
        }
    }
}

