/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.websockets;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLException;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.ErrorRequestEvent;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.websockets.ClientWebSocketService;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class StdWebSocketService
extends ClientWebSocketService
implements RequestService {
    private final ConcurrentHashMap<UUID, CompletableFuture> futureMap = new ConcurrentHashMap();
    private final HashSet<RequestService.EventHandler> eventHandlers = new HashSet();
    private final HashSet<ClientWebSocketService.EventHandler> legacyEventHandlers = new HashSet();

    public StdWebSocketService(String string) throws SSLException {
        super(string);
    }

    public static CompletableFuture<StdWebSocketService> initWebSockets(String string) {
        StdWebSocketService stdWebSocketService;
        try {
            stdWebSocketService = new StdWebSocketService(string);
        }
        catch (SSLException sSLException) {
            throw new SecurityException(sSLException);
        }
        stdWebSocketService.registerResults();
        stdWebSocketService.registerRequests();
        CompletableFuture<StdWebSocketService> completableFuture = new CompletableFuture<StdWebSocketService>();
        stdWebSocketService.openAsync(() -> {
            completableFuture.complete(stdWebSocketService);
            JVMHelper.RUNTIME.addShutdownHook(new Thread(() -> {
                try {
                    stdWebSocketService.close();
                }
                catch (InterruptedException interruptedException) {
                    LogHelper.error(interruptedException);
                }
            }));
        }, completableFuture::completeExceptionally);
        return completableFuture;
    }

    @Deprecated
    public void registerEventHandler(ClientWebSocketService.EventHandler eventHandler) {
        this.legacyEventHandlers.add(eventHandler);
    }

    @Deprecated
    public void unregisterEventHandler(ClientWebSocketService.EventHandler eventHandler) {
        this.legacyEventHandlers.remove(eventHandler);
    }

    public <T extends WebSocketEvent> void processEventHandlers(T t) {
        for (RequestService.EventHandler object : this.eventHandlers) {
            if (!object.eventHandle(t)) continue;
            return;
        }
        for (ClientWebSocketService.EventHandler eventHandler : this.legacyEventHandlers) {
            if (!eventHandler.eventHandle(t)) continue;
            return;
        }
    }

    @Override
    public <T extends WebSocketEvent> void eventHandle(T t) {
        if (t instanceof RequestEvent) {
            RequestEvent requestEvent = (RequestEvent)t;
            if (requestEvent.requestUUID == null) {
                LogHelper.warning("Request event type %s.requestUUID is null", requestEvent.getType() == null ? "null" : requestEvent.getType());
                return;
            }
            if (requestEvent.requestUUID.equals(RequestEvent.eventUUID)) {
                this.processEventHandlers(t);
                return;
            }
            CompletableFuture completableFuture = this.futureMap.get(requestEvent.requestUUID);
            if (completableFuture != null) {
                if (requestEvent instanceof ErrorRequestEvent) {
                    completableFuture.completeExceptionally(new RequestException(((ErrorRequestEvent)requestEvent).error));
                } else {
                    completableFuture.complete(requestEvent);
                }
                this.futureMap.remove(requestEvent.requestUUID);
            } else {
                this.processEventHandlers(requestEvent);
                return;
            }
        }
        this.processEventHandlers(t);
    }

    @Override
    public <T extends WebSocketEvent> CompletableFuture<T> request(Request<T> request) throws IOException {
        CompletableFuture completableFuture = new CompletableFuture();
        this.futureMap.put(request.requestUUID, completableFuture);
        this.sendObject(request, (Type)((Object)WebSocketRequest.class));
        return completableFuture;
    }

    @Override
    public void registerEventHandler(RequestService.EventHandler eventHandler) {
        this.eventHandlers.add(eventHandler);
    }

    @Override
    public void unregisterEventHandler(RequestService.EventHandler eventHandler) {
        this.eventHandlers.remove(eventHandler);
    }

    @Override
    public <T extends WebSocketEvent> T requestSync(Request<T> request) throws IOException {
        try {
            return (T)((WebSocketEvent)this.request(request).get());
        }
        catch (InterruptedException interruptedException) {
            throw new RequestException("Request interrupted");
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)executionException.getCause();
            }
            throw new RequestException(throwable);
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }
}

