/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.serialize.signed;

import java.io.IOException;
import java.security.SignatureException;
import java.util.Arrays;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.launcher.serialize.stream.StreamObject;
import pro.gravit.utils.helper.SecurityHelper;

public class DigestBytesHolder
extends StreamObject {
    protected final byte[] bytes;
    private final byte[] digest;

    public DigestBytesHolder(byte[] byArray, byte[] byArray2, SecurityHelper.DigestAlgorithm digestAlgorithm) throws SignatureException {
        if (Arrays.equals(SecurityHelper.digest(digestAlgorithm, byArray), byArray2)) {
            throw new SignatureException("Invalid digest");
        }
        this.bytes = (byte[])byArray.clone();
        this.digest = (byte[])byArray2.clone();
    }

    public DigestBytesHolder(byte[] byArray, SecurityHelper.DigestAlgorithm digestAlgorithm) {
        this.bytes = (byte[])byArray.clone();
        this.digest = SecurityHelper.digest(digestAlgorithm, byArray);
    }

    public DigestBytesHolder(HInput hInput, SecurityHelper.DigestAlgorithm digestAlgorithm) throws IOException, SignatureException {
        this(hInput.readByteArray(0), hInput.readByteArray(-256), digestAlgorithm);
    }

    public final byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }

    public final byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    @Override
    public final void write(HOutput hOutput) throws IOException {
        hOutput.writeByteArray(this.bytes, 0);
        hOutput.writeByteArray(this.digest, -256);
    }
}

