/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchermodules.discordgame;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.CreateParams;
import de.jcm.discordgamesdk.GameSDKException;
import de.jcm.discordgamesdk.LogLevel;
import de.jcm.discordgamesdk.activity.Activity;
import java.io.IOException;
import java.nio.file.Path;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.api.DiscordActivityService;
import pro.gravit.launcher.client.ClientLauncherEntryPoint;
import pro.gravit.launchermodules.discordgame.DiscordUpdateTask;
import pro.gravit.launchermodules.discordgame.event.DiscordInitEvent;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.UnpackHelper;

public class DiscordBridge {
    public static final DiscordActivityService activityService = new DiscordActivityService();
    private static Thread thread;
    private static Core core;
    private static CreateParams params;
    private static Activity activity;

    private static void initCore() throws IOException {
    }

    public static void init(long l, boolean bl) throws IOException {
        if (JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM32 || JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM64) {
            LogHelper.info("Cannot initialize Discord Game SDK because of launcher started at unsupported system && arch");
            return;
        }
        DiscordBridge.initCore();
        params = new CreateParams();
        params.setClientID(l);
        params.setFlags(CreateParams.getDefaultFlags() | 1L);
        try {
            core = new Core(params);
            core.setLogHook(DiscordBridge.getLogLevel(), (logLevel, string) -> {
                switch (logLevel) {
                    case ERROR: {
                        LogHelper.error(string);
                        break;
                    }
                    case WARN: {
                        LogHelper.warning(string);
                        break;
                    }
                    case INFO: {
                        LogHelper.info(string);
                        break;
                    }
                    case DEBUG: {
                        LogHelper.debug(string);
                        break;
                    }
                    case VERBOSE: {
                        LogHelper.dev(string);
                    }
                }
            });
            activity = new Activity();
            activityService.applyToActivity(activity);
            activityService.resetStartTime();
            core.activityManager().updateActivity(DiscordBridge.getActivity());
        }
        catch (GameSDKException gameSDKException) {
            LogHelper.info("Failed to start Discord Game SDK. Most surely because local discord app is down");
            DiscordBridge.close();
            return;
        }
        if (bl) {
            ClientLauncherEntryPoint.modulesManager.invokeEvent(new DiscordInitEvent(core));
        } else {
            LauncherEngine.modulesManager.invokeEvent(new DiscordInitEvent(core));
        }
        LogHelper.debug("Initialized Discord Game. Application ID %d", l);
        thread = CommonHelper.newThread("DiscordGameBridge callbacks", true, new DiscordUpdateTask(core));
        thread.start();
    }

    private static LogLevel getLogLevel() {
        if (LogHelper.isDevEnabled()) {
            return LogLevel.VERBOSE;
        }
        if (LogHelper.isDebugEnabled()) {
            return LogLevel.INFO;
        }
        return LogLevel.ERROR;
    }

    public static Core getCore() {
        return core;
    }

    public static Activity getActivity() {
        return activity;
    }

    public static void close() {
        if (thread != null) {
            thread.interrupt();
        }
        if (core != null) {
            try {
                core.close();
            }
            catch (Throwable throwable) {
                if (LogHelper.isDebugEnabled()) {
                    LogHelper.error(throwable);
                }
                LogHelper.warning("DiscordGame core object not closed correctly. Discord is down?");
            }
        }
    }

    private static String loadNative(Path path, String string, String string2, String string3) throws IOException {
        String string4 = JVMHelper.NATIVE_PREFIX.concat(string).concat(JVMHelper.NATIVE_EXTENSION);
        Path path2 = path.resolve(string4);
        String string5 = String.join((CharSequence)"/", "native", string2, string3, string4);
        UnpackHelper.unpack(IOHelper.getResourceURL(string5), path2);
        System.load(path2.toAbsolutePath().toString());
        return path2.toAbsolutePath().toString();
    }
}

