/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.pool;

import java.io.Closeable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import pro.gravit.repackage.io.netty.channel.pool.ChannelPool;
import pro.gravit.repackage.io.netty.channel.pool.ChannelPoolMap;
import pro.gravit.repackage.io.netty.channel.pool.SimpleChannelPool;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.concurrent.GenericFutureListener;
import pro.gravit.repackage.io.netty.util.concurrent.GlobalEventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.Promise;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.ReadOnlyIterator;

public abstract class AbstractChannelPoolMap<K, P extends ChannelPool>
implements ChannelPoolMap<K, P>,
Iterable<Map.Entry<K, P>>,
Closeable {
    private final ConcurrentMap<K, P> map = PlatformDependent.newConcurrentHashMap();

    @Override
    public final P get(K k) {
        ChannelPool channelPool;
        ChannelPool channelPool2 = (ChannelPool)this.map.get(ObjectUtil.checkNotNull(k, "key"));
        if (channelPool2 == null && (channelPool = this.map.putIfAbsent(k, channelPool2 = this.newPool(k))) != null) {
            AbstractChannelPoolMap.poolCloseAsyncIfSupported(channelPool2);
            channelPool2 = channelPool;
        }
        return (P)channelPool2;
    }

    public final boolean remove(K k) {
        ChannelPool channelPool = (ChannelPool)this.map.remove(ObjectUtil.checkNotNull(k, "key"));
        if (channelPool != null) {
            AbstractChannelPoolMap.poolCloseAsyncIfSupported(channelPool);
            return true;
        }
        return false;
    }

    private Future<Boolean> removeAsyncIfSupported(K k) {
        ChannelPool channelPool = (ChannelPool)this.map.remove(ObjectUtil.checkNotNull(k, "key"));
        if (channelPool != null) {
            final Promise<Boolean> promise = GlobalEventExecutor.INSTANCE.newPromise();
            AbstractChannelPoolMap.poolCloseAsyncIfSupported(channelPool).addListener((GenericFutureListener<Future<Void>>)new GenericFutureListener<Future<? super Void>>(){

                @Override
                public void operationComplete(Future<? super Void> future) throws Exception {
                    if (future.isSuccess()) {
                        promise.setSuccess(Boolean.TRUE);
                    } else {
                        promise.setFailure(future.cause());
                    }
                }
            });
            return promise;
        }
        return GlobalEventExecutor.INSTANCE.newSucceededFuture(Boolean.FALSE);
    }

    private static Future<Void> poolCloseAsyncIfSupported(ChannelPool channelPool) {
        if (channelPool instanceof SimpleChannelPool) {
            return ((SimpleChannelPool)channelPool).closeAsync();
        }
        try {
            channelPool.close();
            return GlobalEventExecutor.INSTANCE.newSucceededFuture(null);
        }
        catch (Exception exception) {
            return GlobalEventExecutor.INSTANCE.newFailedFuture(exception);
        }
    }

    @Override
    public final Iterator<Map.Entry<K, P>> iterator() {
        return new ReadOnlyIterator<Map.Entry<K, P>>(this.map.entrySet().iterator());
    }

    public final int size() {
        return this.map.size();
    }

    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final boolean contains(K k) {
        return this.map.containsKey(ObjectUtil.checkNotNull(k, "key"));
    }

    protected abstract P newPool(K var1);

    @Override
    public final void close() {
        for (Object k : this.map.keySet()) {
            this.removeAsyncIfSupported(k).syncUninterruptibly();
        }
    }
}

