/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.pool;

import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import pro.gravit.repackage.io.netty.bootstrap.Bootstrap;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.pool.ChannelHealthChecker;
import pro.gravit.repackage.io.netty.channel.pool.ChannelPoolHandler;
import pro.gravit.repackage.io.netty.channel.pool.SimpleChannelPool;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.concurrent.FutureListener;
import pro.gravit.repackage.io.netty.util.concurrent.GlobalEventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.Promise;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class FixedChannelPool
extends SimpleChannelPool {
    private final EventExecutor executor;
    private final long acquireTimeoutNanos;
    private final Runnable timeoutTask;
    private final Queue<AcquireTask> pendingAcquireQueue = new ArrayDeque<AcquireTask>();
    private final int maxConnections;
    private final int maxPendingAcquires;
    private final AtomicInteger acquiredChannelCount = new AtomicInteger();
    private int pendingAcquireCount;
    private boolean closed;

    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, int n) {
        this(bootstrap, channelPoolHandler, n, Integer.MAX_VALUE);
    }

    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, int n, int n2) {
        this(bootstrap, channelPoolHandler, ChannelHealthChecker.ACTIVE, null, -1L, n, n2);
    }

    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker, AcquireTimeoutAction acquireTimeoutAction, long l, int n, int n2) {
        this(bootstrap, channelPoolHandler, channelHealthChecker, acquireTimeoutAction, l, n, n2, true);
    }

    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker, AcquireTimeoutAction acquireTimeoutAction, long l, int n, int n2, boolean bl) {
        this(bootstrap, channelPoolHandler, channelHealthChecker, acquireTimeoutAction, l, n, n2, bl, true);
    }

    public FixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker, AcquireTimeoutAction acquireTimeoutAction, long l, int n, int n2, boolean bl, boolean bl2) {
        super(bootstrap, channelPoolHandler, channelHealthChecker, bl, bl2);
        ObjectUtil.checkPositive(n, "maxConnections");
        ObjectUtil.checkPositive(n2, "maxPendingAcquires");
        if (acquireTimeoutAction == null && l == -1L) {
            this.timeoutTask = null;
            this.acquireTimeoutNanos = -1L;
        } else {
            if (acquireTimeoutAction == null && l != -1L) {
                throw new NullPointerException("action");
            }
            if (acquireTimeoutAction != null && l < 0L) {
                throw new IllegalArgumentException("acquireTimeoutMillis: " + l + " (expected: >= 0)");
            }
            this.acquireTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(l);
            switch (acquireTimeoutAction) {
                case FAIL: {
                    this.timeoutTask = new TimeoutTask(){

                        @Override
                        public void onTimeout(AcquireTask acquireTask) {
                            acquireTask.promise.setFailure(new AcquireTimeoutException());
                        }
                    };
                    break;
                }
                case NEW: {
                    this.timeoutTask = new TimeoutTask(){

                        @Override
                        public void onTimeout(AcquireTask acquireTask) {
                            acquireTask.acquired();
                            FixedChannelPool.super.acquire(acquireTask.promise);
                        }
                    };
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
        this.executor = bootstrap.config().group().next();
        this.maxConnections = n;
        this.maxPendingAcquires = n2;
    }

    public int acquiredChannelCount() {
        return this.acquiredChannelCount.get();
    }

    @Override
    public Future<Channel> acquire(final Promise<Channel> promise) {
        try {
            if (this.executor.inEventLoop()) {
                this.acquire0(promise);
            } else {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        FixedChannelPool.this.acquire0(promise);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            promise.tryFailure(throwable);
        }
        return promise;
    }

    private void acquire0(Promise<Channel> promise) {
        try {
            assert (this.executor.inEventLoop());
            if (this.closed) {
                promise.setFailure(new IllegalStateException("FixedChannelPool was closed"));
                return;
            }
            if (this.acquiredChannelCount.get() < this.maxConnections) {
                assert (this.acquiredChannelCount.get() >= 0);
                Promise<Channel> promise2 = this.executor.newPromise();
                AcquireListener acquireListener = new AcquireListener(promise);
                acquireListener.acquired();
                promise2.addListener(acquireListener);
                super.acquire(promise2);
            } else {
                if (this.pendingAcquireCount >= this.maxPendingAcquires) {
                    this.tooManyOutstanding(promise);
                } else {
                    AcquireTask acquireTask = new AcquireTask(promise);
                    if (this.pendingAcquireQueue.offer(acquireTask)) {
                        ++this.pendingAcquireCount;
                        if (this.timeoutTask != null) {
                            acquireTask.timeoutFuture = this.executor.schedule(this.timeoutTask, this.acquireTimeoutNanos, TimeUnit.NANOSECONDS);
                        }
                    } else {
                        this.tooManyOutstanding(promise);
                    }
                }
                assert (this.pendingAcquireCount > 0);
            }
        }
        catch (Throwable throwable) {
            promise.tryFailure(throwable);
        }
    }

    private void tooManyOutstanding(Promise<?> promise) {
        promise.setFailure(new IllegalStateException("Too many outstanding acquire operations"));
    }

    @Override
    public Future<Void> release(final Channel channel, final Promise<Void> promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        Promise<Void> promise2 = this.executor.newPromise();
        super.release(channel, promise2.addListener(new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) {
                try {
                    assert (FixedChannelPool.this.executor.inEventLoop());
                    if (FixedChannelPool.this.closed) {
                        channel.close();
                        promise.setFailure(new IllegalStateException("FixedChannelPool was closed"));
                        return;
                    }
                    if (future.isSuccess()) {
                        FixedChannelPool.this.decrementAndRunTaskQueue();
                        promise.setSuccess(null);
                    } else {
                        Throwable throwable = future.cause();
                        if (!(throwable instanceof IllegalArgumentException)) {
                            FixedChannelPool.this.decrementAndRunTaskQueue();
                        }
                        promise.setFailure(future.cause());
                    }
                }
                catch (Throwable throwable) {
                    promise.tryFailure(throwable);
                }
            }
        }));
        return promise;
    }

    private void decrementAndRunTaskQueue() {
        int n = this.acquiredChannelCount.decrementAndGet();
        assert (n >= 0);
        this.runTaskQueue();
    }

    private void runTaskQueue() {
        AcquireTask acquireTask;
        while (this.acquiredChannelCount.get() < this.maxConnections && (acquireTask = this.pendingAcquireQueue.poll()) != null) {
            ScheduledFuture<?> scheduledFuture = acquireTask.timeoutFuture;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            --this.pendingAcquireCount;
            acquireTask.acquired();
            super.acquire(acquireTask.promise);
        }
        assert (this.pendingAcquireCount >= 0);
        assert (this.acquiredChannelCount.get() >= 0);
    }

    @Override
    public void close() {
        try {
            this.closeAsync().await();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(interruptedException);
        }
    }

    @Override
    public Future<Void> closeAsync() {
        if (this.executor.inEventLoop()) {
            return this.close0();
        }
        final Promise<Void> promise = this.executor.newPromise();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                FixedChannelPool.this.close0().addListener(new FutureListener<Void>(){

                    @Override
                    public void operationComplete(Future<Void> future) throws Exception {
                        if (future.isSuccess()) {
                            promise.setSuccess(null);
                        } else {
                            promise.setFailure(future.cause());
                        }
                    }
                });
            }
        });
        return promise;
    }

    private Future<Void> close0() {
        assert (this.executor.inEventLoop());
        if (!this.closed) {
            AcquireTask acquireTask;
            this.closed = true;
            while ((acquireTask = this.pendingAcquireQueue.poll()) != null) {
                ScheduledFuture<?> scheduledFuture = acquireTask.timeoutFuture;
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(false);
                }
                acquireTask.promise.setFailure(new ClosedChannelException());
            }
            this.acquiredChannelCount.set(0);
            this.pendingAcquireCount = 0;
            return GlobalEventExecutor.INSTANCE.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    FixedChannelPool.super.close();
                    return null;
                }
            });
        }
        return GlobalEventExecutor.INSTANCE.newSucceededFuture(null);
    }

    private static final class AcquireTimeoutException
    extends TimeoutException {
        private AcquireTimeoutException() {
            super("Acquire operation took longer then configured maximum time");
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private class AcquireListener
    implements FutureListener<Channel> {
        private final Promise<Channel> originalPromise;
        protected boolean acquired;

        AcquireListener(Promise<Channel> promise) {
            this.originalPromise = promise;
        }

        @Override
        public void operationComplete(Future<Channel> future) throws Exception {
            try {
                assert (FixedChannelPool.this.executor.inEventLoop());
                if (FixedChannelPool.this.closed) {
                    if (future.isSuccess()) {
                        future.getNow().close();
                    }
                    this.originalPromise.setFailure(new IllegalStateException("FixedChannelPool was closed"));
                    return;
                }
                if (future.isSuccess()) {
                    this.originalPromise.setSuccess(future.getNow());
                } else {
                    if (this.acquired) {
                        FixedChannelPool.this.decrementAndRunTaskQueue();
                    } else {
                        FixedChannelPool.this.runTaskQueue();
                    }
                    this.originalPromise.setFailure(future.cause());
                }
            }
            catch (Throwable throwable) {
                this.originalPromise.tryFailure(throwable);
            }
        }

        public void acquired() {
            if (this.acquired) {
                return;
            }
            FixedChannelPool.this.acquiredChannelCount.incrementAndGet();
            this.acquired = true;
        }
    }

    private abstract class TimeoutTask
    implements Runnable {
        private TimeoutTask() {
        }

        @Override
        public final void run() {
            AcquireTask acquireTask;
            assert (FixedChannelPool.this.executor.inEventLoop());
            long l = System.nanoTime();
            while ((acquireTask = (AcquireTask)FixedChannelPool.this.pendingAcquireQueue.peek()) != null && l - acquireTask.expireNanoTime >= 0L) {
                FixedChannelPool.this.pendingAcquireQueue.remove();
                --FixedChannelPool.this.pendingAcquireCount;
                this.onTimeout(acquireTask);
            }
        }

        public abstract void onTimeout(AcquireTask var1);
    }

    private final class AcquireTask
    extends AcquireListener {
        final Promise<Channel> promise;
        final long expireNanoTime;
        ScheduledFuture<?> timeoutFuture;

        AcquireTask(Promise<Channel> promise) {
            super(promise);
            this.expireNanoTime = System.nanoTime() + FixedChannelPool.this.acquireTimeoutNanos;
            this.promise = FixedChannelPool.this.executor.newPromise().addListener(this);
        }
    }

    public static enum AcquireTimeoutAction {
        NEW,
        FAIL;

    }
}

