/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.socket.nio;

import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.Channel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Set;
import pro.gravit.repackage.io.netty.channel.ChannelException;
import pro.gravit.repackage.io.netty.channel.ChannelOption;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;

@SuppressJava6Requirement(reason="Usage explicit by the user")
public final class NioChannelOption<T>
extends ChannelOption<T> {
    private final SocketOption<T> option;

    private NioChannelOption(SocketOption<T> socketOption) {
        super(socketOption.name());
        this.option = socketOption;
    }

    public static <T> ChannelOption<T> of(SocketOption<T> socketOption) {
        return new NioChannelOption<T>(socketOption);
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    static <T> boolean setOption(Channel channel, NioChannelOption<T> nioChannelOption, T t) {
        NetworkChannel networkChannel = (NetworkChannel)channel;
        if (!networkChannel.supportedOptions().contains(nioChannelOption.option)) {
            return false;
        }
        if (networkChannel instanceof ServerSocketChannel && nioChannelOption.option == StandardSocketOptions.IP_TOS) {
            return false;
        }
        try {
            networkChannel.setOption(nioChannelOption.option, t);
            return true;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    static <T> T getOption(Channel channel, NioChannelOption<T> nioChannelOption) {
        NetworkChannel networkChannel = (NetworkChannel)channel;
        if (!networkChannel.supportedOptions().contains(nioChannelOption.option)) {
            return null;
        }
        if (networkChannel instanceof ServerSocketChannel && nioChannelOption.option == StandardSocketOptions.IP_TOS) {
            return null;
        }
        try {
            return networkChannel.getOption(nioChannelOption.option);
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    static ChannelOption[] getOptions(Channel channel) {
        NetworkChannel networkChannel = (NetworkChannel)channel;
        Set<SocketOption<?>> set = networkChannel.supportedOptions();
        if (networkChannel instanceof ServerSocketChannel) {
            ArrayList arrayList = new ArrayList(set.size());
            for (SocketOption<?> socketOption : set) {
                if (socketOption == StandardSocketOptions.IP_TOS) continue;
                arrayList.add(new NioChannelOption(socketOption));
            }
            return arrayList.toArray(new ChannelOption[0]);
        }
        ChannelOption[] channelOptionArray = new ChannelOption[set.size()];
        int n = 0;
        for (SocketOption<?> socketOption : set) {
            channelOptionArray[n++] = new NioChannelOption(socketOption);
        }
        return channelOptionArray;
    }
}

