/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import pro.gravit.repackage.io.netty.handler.codec.Headers;
import pro.gravit.repackage.io.netty.handler.codec.HeadersUtils;
import pro.gravit.repackage.io.netty.handler.codec.ValueConverter;
import pro.gravit.repackage.io.netty.util.HashingStrategy;
import pro.gravit.repackage.io.netty.util.internal.MathUtil;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class DefaultHeaders<K, V, T extends Headers<K, V, T>>
implements Headers<K, V, T> {
    static final int HASH_CODE_SEED = -1028477387;
    private final HeaderEntry<K, V>[] entries;
    protected final HeaderEntry<K, V> head;
    private final byte hashMask;
    private final ValueConverter<V> valueConverter;
    private final NameValidator<K> nameValidator;
    private final ValueValidator<V> valueValidator;
    private final HashingStrategy<K> hashingStrategy;
    int size;

    public DefaultHeaders(ValueConverter<V> valueConverter) {
        this(HashingStrategy.JAVA_HASHER, valueConverter);
    }

    public DefaultHeaders(ValueConverter<V> valueConverter, NameValidator<K> nameValidator) {
        this(HashingStrategy.JAVA_HASHER, valueConverter, nameValidator);
    }

    public DefaultHeaders(HashingStrategy<K> hashingStrategy, ValueConverter<V> valueConverter) {
        this(hashingStrategy, valueConverter, NameValidator.NOT_NULL);
    }

    public DefaultHeaders(HashingStrategy<K> hashingStrategy, ValueConverter<V> valueConverter, NameValidator<K> nameValidator) {
        this(hashingStrategy, valueConverter, nameValidator, 16);
    }

    public DefaultHeaders(HashingStrategy<K> hashingStrategy, ValueConverter<V> valueConverter, NameValidator<K> nameValidator, int n) {
        this(hashingStrategy, valueConverter, nameValidator, n, ValueValidator.NO_VALIDATION);
    }

    public DefaultHeaders(HashingStrategy<K> hashingStrategy, ValueConverter<V> valueConverter, NameValidator<K> nameValidator, int n, ValueValidator<V> valueValidator) {
        this.valueConverter = ObjectUtil.checkNotNull(valueConverter, "valueConverter");
        this.nameValidator = ObjectUtil.checkNotNull(nameValidator, "nameValidator");
        this.hashingStrategy = ObjectUtil.checkNotNull(hashingStrategy, "nameHashingStrategy");
        this.valueValidator = ObjectUtil.checkNotNull(valueValidator, "valueValidator");
        this.entries = new HeaderEntry[MathUtil.findNextPositivePowerOfTwo(Math.max(2, Math.min(n, 128)))];
        this.hashMask = (byte)(this.entries.length - 1);
        this.head = new HeaderEntry();
    }

    @Override
    public V get(K k) {
        ObjectUtil.checkNotNull(k, "name");
        int n = this.hashingStrategy.hashCode(k);
        int n2 = this.index(n);
        HeaderEntry<K, V> headerEntry = this.entries[n2];
        V v = null;
        while (headerEntry != null) {
            if (headerEntry.hash == n && this.hashingStrategy.equals(k, headerEntry.key)) {
                v = headerEntry.value;
            }
            headerEntry = headerEntry.next;
        }
        return v;
    }

    @Override
    public V get(K k, V v) {
        V v2 = this.get(k);
        if (v2 == null) {
            return v;
        }
        return v2;
    }

    @Override
    public V getAndRemove(K k) {
        int n = this.hashingStrategy.hashCode(k);
        return this.remove0(n, this.index(n), ObjectUtil.checkNotNull(k, "name"));
    }

    @Override
    public V getAndRemove(K k, V v) {
        V v2 = this.getAndRemove(k);
        if (v2 == null) {
            return v;
        }
        return v2;
    }

    @Override
    public List<V> getAll(K k) {
        ObjectUtil.checkNotNull(k, "name");
        LinkedList<V> linkedList = new LinkedList<V>();
        int n = this.hashingStrategy.hashCode(k);
        int n2 = this.index(n);
        HeaderEntry<K, V> headerEntry = this.entries[n2];
        while (headerEntry != null) {
            if (headerEntry.hash == n && this.hashingStrategy.equals(k, headerEntry.key)) {
                linkedList.addFirst(headerEntry.getValue());
            }
            headerEntry = headerEntry.next;
        }
        return linkedList;
    }

    public Iterator<V> valueIterator(K k) {
        return new ValueIterator(k);
    }

    @Override
    public List<V> getAllAndRemove(K k) {
        List<V> list = this.getAll(k);
        this.remove(k);
        return list;
    }

    @Override
    public boolean contains(K k) {
        return this.get(k) != null;
    }

    @Override
    public boolean containsObject(K k, Object object) {
        return this.contains(k, this.fromObject(k, object));
    }

    @Override
    public boolean containsBoolean(K k, boolean bl) {
        return this.contains(k, this.fromBoolean(k, bl));
    }

    @Override
    public boolean containsByte(K k, byte by) {
        return this.contains(k, this.fromByte(k, by));
    }

    @Override
    public boolean containsChar(K k, char c) {
        return this.contains(k, this.fromChar(k, c));
    }

    @Override
    public boolean containsShort(K k, short s) {
        return this.contains(k, this.fromShort(k, s));
    }

    @Override
    public boolean containsInt(K k, int n) {
        return this.contains(k, this.fromInt(k, n));
    }

    @Override
    public boolean containsLong(K k, long l) {
        return this.contains(k, this.fromLong(k, l));
    }

    @Override
    public boolean containsFloat(K k, float f) {
        return this.contains(k, this.fromFloat(k, f));
    }

    @Override
    public boolean containsDouble(K k, double d) {
        return this.contains(k, this.fromDouble(k, d));
    }

    @Override
    public boolean containsTimeMillis(K k, long l) {
        return this.contains(k, this.fromTimeMillis(k, l));
    }

    @Override
    public boolean contains(K k, V v) {
        return this.contains(k, v, HashingStrategy.JAVA_HASHER);
    }

    public final boolean contains(K k, V v, HashingStrategy<? super V> hashingStrategy) {
        ObjectUtil.checkNotNull(k, "name");
        int n = this.hashingStrategy.hashCode(k);
        int n2 = this.index(n);
        HeaderEntry<K, V> headerEntry = this.entries[n2];
        while (headerEntry != null) {
            if (headerEntry.hash == n && this.hashingStrategy.equals(k, headerEntry.key) && hashingStrategy.equals(v, headerEntry.value)) {
                return true;
            }
            headerEntry = headerEntry.next;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    @Override
    public Set<K> names() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet(this.size());
        HeaderEntry headerEntry = this.head.after;
        while (headerEntry != this.head) {
            linkedHashSet.add(headerEntry.getKey());
            headerEntry = headerEntry.after;
        }
        return linkedHashSet;
    }

    @Override
    public T add(K k, V v) {
        this.validateName(this.nameValidator, true, k);
        this.validateValue(this.valueValidator, k, v);
        ObjectUtil.checkNotNull(v, "value");
        int n = this.hashingStrategy.hashCode(k);
        int n2 = this.index(n);
        this.add0(n, n2, k, v);
        return this.thisT();
    }

    @Override
    public T add(K k, Iterable<? extends V> iterable) {
        this.validateName(this.nameValidator, true, k);
        int n = this.hashingStrategy.hashCode(k);
        int n2 = this.index(n);
        for (V v : iterable) {
            this.validateValue(this.valueValidator, k, v);
            this.add0(n, n2, k, v);
        }
        return this.thisT();
    }

    @Override
    public T add(K k, V ... VArray) {
        this.validateName(this.nameValidator, true, k);
        int n = this.hashingStrategy.hashCode(k);
        int n2 = this.index(n);
        for (V v : VArray) {
            this.validateValue(this.valueValidator, k, v);
            this.add0(n, n2, k, v);
        }
        return this.thisT();
    }

    @Override
    public T addObject(K k, Object object) {
        return this.add(k, this.fromObject(k, object));
    }

    @Override
    public T addObject(K k, Iterable<?> iterable) {
        for (Object obj : iterable) {
            this.addObject(k, obj);
        }
        return this.thisT();
    }

    @Override
    public T addObject(K k, Object ... objectArray) {
        for (Object object : objectArray) {
            this.addObject(k, object);
        }
        return this.thisT();
    }

    @Override
    public T addInt(K k, int n) {
        return this.add(k, this.fromInt(k, n));
    }

    @Override
    public T addLong(K k, long l) {
        return this.add(k, this.fromLong(k, l));
    }

    @Override
    public T addDouble(K k, double d) {
        return this.add(k, this.fromDouble(k, d));
    }

    @Override
    public T addTimeMillis(K k, long l) {
        return this.add(k, this.fromTimeMillis(k, l));
    }

    @Override
    public T addChar(K k, char c) {
        return this.add(k, this.fromChar(k, c));
    }

    @Override
    public T addBoolean(K k, boolean bl) {
        return this.add(k, this.fromBoolean(k, bl));
    }

    @Override
    public T addFloat(K k, float f) {
        return this.add(k, this.fromFloat(k, f));
    }

    @Override
    public T addByte(K k, byte by) {
        return this.add(k, this.fromByte(k, by));
    }

    @Override
    public T addShort(K k, short s) {
        return this.add(k, this.fromShort(k, s));
    }

    @Override
    public T add(Headers<? extends K, ? extends V, ?> headers) {
        if (headers == this) {
            throw new IllegalArgumentException("can't add to itself.");
        }
        this.addImpl(headers);
        return this.thisT();
    }

    protected void addImpl(Headers<? extends K, ? extends V, ?> headers) {
        if (headers instanceof DefaultHeaders) {
            DefaultHeaders defaultHeaders = (DefaultHeaders)headers;
            HeaderEntry headerEntry = defaultHeaders.head.after;
            if (defaultHeaders.hashingStrategy == this.hashingStrategy && defaultHeaders.nameValidator == this.nameValidator) {
                while (headerEntry != defaultHeaders.head) {
                    this.add0(headerEntry.hash, this.index(headerEntry.hash), headerEntry.key, headerEntry.value);
                    headerEntry = headerEntry.after;
                }
            } else {
                while (headerEntry != defaultHeaders.head) {
                    this.add((K)headerEntry.key, (V)headerEntry.value);
                    headerEntry = headerEntry.after;
                }
            }
        } else {
            for (Map.Entry<K, V> entry : headers) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public T set(K k, V v) {
        this.validateName(this.nameValidator, false, k);
        this.validateValue(this.valueValidator, k, v);
        ObjectUtil.checkNotNull(v, "value");
        int n = this.hashingStrategy.hashCode(k);
        int n2 = this.index(n);
        this.remove0(n, n2, k);
        this.add0(n, n2, k, v);
        return this.thisT();
    }

    @Override
    public T set(K k, Iterable<? extends V> iterable) {
        this.validateName(this.nameValidator, false, k);
        ObjectUtil.checkNotNull(iterable, "values");
        int n = this.hashingStrategy.hashCode(k);
        int n2 = this.index(n);
        this.remove0(n, n2, k);
        for (V v : iterable) {
            if (v == null) break;
            this.validateValue(this.valueValidator, k, v);
            this.add0(n, n2, k, v);
        }
        return this.thisT();
    }

    @Override
    public T set(K k, V ... VArray) {
        this.validateName(this.nameValidator, false, k);
        ObjectUtil.checkNotNull(VArray, "values");
        int n = this.hashingStrategy.hashCode(k);
        int n2 = this.index(n);
        this.remove0(n, n2, k);
        for (V v : VArray) {
            if (v == null) break;
            this.validateValue(this.valueValidator, k, v);
            this.add0(n, n2, k, v);
        }
        return this.thisT();
    }

    @Override
    public T setObject(K k, Object object) {
        V v = ObjectUtil.checkNotNull(this.fromObject(k, object), "convertedValue");
        return this.set(k, v);
    }

    @Override
    public T setObject(K k, Iterable<?> iterable) {
        this.validateName(this.nameValidator, false, k);
        int n = this.hashingStrategy.hashCode(k);
        int n2 = this.index(n);
        this.remove0(n, n2, k);
        for (Object obj : iterable) {
            if (obj == null) break;
            V v = this.fromObject(k, obj);
            this.validateValue(this.valueValidator, k, v);
            this.add0(n, n2, k, v);
        }
        return this.thisT();
    }

    @Override
    public T setObject(K k, Object ... objectArray) {
        this.validateName(this.nameValidator, false, k);
        int n = this.hashingStrategy.hashCode(k);
        int n2 = this.index(n);
        this.remove0(n, n2, k);
        for (Object object : objectArray) {
            if (object == null) break;
            V v = this.fromObject(k, object);
            this.validateValue(this.valueValidator, k, v);
            this.add0(n, n2, k, v);
        }
        return this.thisT();
    }

    @Override
    public T setInt(K k, int n) {
        return this.set(k, this.fromInt(k, n));
    }

    @Override
    public T setLong(K k, long l) {
        return this.set(k, this.fromLong(k, l));
    }

    @Override
    public T setDouble(K k, double d) {
        return this.set(k, this.fromDouble(k, d));
    }

    @Override
    public T setTimeMillis(K k, long l) {
        return this.set(k, this.fromTimeMillis(k, l));
    }

    @Override
    public T setFloat(K k, float f) {
        return this.set(k, this.fromFloat(k, f));
    }

    @Override
    public T setChar(K k, char c) {
        return this.set(k, this.fromChar(k, c));
    }

    @Override
    public T setBoolean(K k, boolean bl) {
        return this.set(k, this.fromBoolean(k, bl));
    }

    @Override
    public T setByte(K k, byte by) {
        return this.set(k, this.fromByte(k, by));
    }

    @Override
    public T setShort(K k, short s) {
        return this.set(k, this.fromShort(k, s));
    }

    @Override
    public T set(Headers<? extends K, ? extends V, ?> headers) {
        if (headers != this) {
            this.clear();
            this.addImpl(headers);
        }
        return this.thisT();
    }

    @Override
    public T setAll(Headers<? extends K, ? extends V, ?> headers) {
        if (headers != this) {
            for (K k : headers.names()) {
                this.remove(k);
            }
            this.addImpl(headers);
        }
        return this.thisT();
    }

    @Override
    public boolean remove(K k) {
        return this.getAndRemove(k) != null;
    }

    @Override
    public T clear() {
        Arrays.fill(this.entries, null);
        this.head.after = this.head;
        this.head.before = this.head.after;
        this.size = 0;
        return this.thisT();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new HeaderIterator();
    }

    @Override
    public Boolean getBoolean(K k) {
        V v = this.get(k);
        try {
            return v != null ? Boolean.valueOf(this.toBoolean(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public boolean getBoolean(K k, boolean bl) {
        Boolean bl2 = this.getBoolean(k);
        return bl2 != null ? bl2 : bl;
    }

    @Override
    public Byte getByte(K k) {
        V v = this.get(k);
        try {
            return v != null ? Byte.valueOf(this.toByte(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public byte getByte(K k, byte by) {
        Byte by2 = this.getByte(k);
        return by2 != null ? by2 : by;
    }

    @Override
    public Character getChar(K k) {
        V v = this.get(k);
        try {
            return v != null ? Character.valueOf(this.toChar(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public char getChar(K k, char c) {
        Character c2 = this.getChar(k);
        return c2 != null ? c2.charValue() : c;
    }

    @Override
    public Short getShort(K k) {
        V v = this.get(k);
        try {
            return v != null ? Short.valueOf(this.toShort(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public short getShort(K k, short s) {
        Short s2 = this.getShort(k);
        return s2 != null ? s2 : s;
    }

    @Override
    public Integer getInt(K k) {
        V v = this.get(k);
        try {
            return v != null ? Integer.valueOf(this.toInt(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public int getInt(K k, int n) {
        Integer n2 = this.getInt(k);
        return n2 != null ? n2 : n;
    }

    @Override
    public Long getLong(K k) {
        V v = this.get(k);
        try {
            return v != null ? Long.valueOf(this.toLong(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public long getLong(K k, long l) {
        Long l2 = this.getLong(k);
        return l2 != null ? l2 : l;
    }

    @Override
    public Float getFloat(K k) {
        V v = this.get(k);
        try {
            return v != null ? Float.valueOf(this.toFloat(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public float getFloat(K k, float f) {
        Float f2 = this.getFloat(k);
        return f2 != null ? f2.floatValue() : f;
    }

    @Override
    public Double getDouble(K k) {
        V v = this.get(k);
        try {
            return v != null ? Double.valueOf(this.toDouble(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public double getDouble(K k, double d) {
        Double d2 = this.getDouble(k);
        return d2 != null ? d2 : d;
    }

    @Override
    public Long getTimeMillis(K k) {
        V v = this.get(k);
        try {
            return v != null ? Long.valueOf(this.toTimeMillis(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public long getTimeMillis(K k, long l) {
        Long l2 = this.getTimeMillis(k);
        return l2 != null ? l2 : l;
    }

    @Override
    public Boolean getBooleanAndRemove(K k) {
        V v = this.getAndRemove(k);
        try {
            return v != null ? Boolean.valueOf(this.toBoolean(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public boolean getBooleanAndRemove(K k, boolean bl) {
        Boolean bl2 = this.getBooleanAndRemove(k);
        return bl2 != null ? bl2 : bl;
    }

    @Override
    public Byte getByteAndRemove(K k) {
        V v = this.getAndRemove(k);
        try {
            return v != null ? Byte.valueOf(this.toByte(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public byte getByteAndRemove(K k, byte by) {
        Byte by2 = this.getByteAndRemove(k);
        return by2 != null ? by2 : by;
    }

    @Override
    public Character getCharAndRemove(K k) {
        V v = this.getAndRemove(k);
        try {
            return v != null ? Character.valueOf(this.toChar(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public char getCharAndRemove(K k, char c) {
        Character c2 = this.getCharAndRemove(k);
        return c2 != null ? c2.charValue() : c;
    }

    @Override
    public Short getShortAndRemove(K k) {
        V v = this.getAndRemove(k);
        try {
            return v != null ? Short.valueOf(this.toShort(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public short getShortAndRemove(K k, short s) {
        Short s2 = this.getShortAndRemove(k);
        return s2 != null ? s2 : s;
    }

    @Override
    public Integer getIntAndRemove(K k) {
        V v = this.getAndRemove(k);
        try {
            return v != null ? Integer.valueOf(this.toInt(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public int getIntAndRemove(K k, int n) {
        Integer n2 = this.getIntAndRemove(k);
        return n2 != null ? n2 : n;
    }

    @Override
    public Long getLongAndRemove(K k) {
        V v = this.getAndRemove(k);
        try {
            return v != null ? Long.valueOf(this.toLong(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public long getLongAndRemove(K k, long l) {
        Long l2 = this.getLongAndRemove(k);
        return l2 != null ? l2 : l;
    }

    @Override
    public Float getFloatAndRemove(K k) {
        V v = this.getAndRemove(k);
        try {
            return v != null ? Float.valueOf(this.toFloat(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public float getFloatAndRemove(K k, float f) {
        Float f2 = this.getFloatAndRemove(k);
        return f2 != null ? f2.floatValue() : f;
    }

    @Override
    public Double getDoubleAndRemove(K k) {
        V v = this.getAndRemove(k);
        try {
            return v != null ? Double.valueOf(this.toDouble(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public double getDoubleAndRemove(K k, double d) {
        Double d2 = this.getDoubleAndRemove(k);
        return d2 != null ? d2 : d;
    }

    @Override
    public Long getTimeMillisAndRemove(K k) {
        V v = this.getAndRemove(k);
        try {
            return v != null ? Long.valueOf(this.toTimeMillis(k, v)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public long getTimeMillisAndRemove(K k, long l) {
        Long l2 = this.getTimeMillisAndRemove(k);
        return l2 != null ? l2 : l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Headers)) {
            return false;
        }
        return this.equals((Headers)object, HashingStrategy.JAVA_HASHER);
    }

    public int hashCode() {
        return this.hashCode(HashingStrategy.JAVA_HASHER);
    }

    public final boolean equals(Headers<K, V, ?> headers, HashingStrategy<V> hashingStrategy) {
        if (headers.size() != this.size()) {
            return false;
        }
        if (this == headers) {
            return true;
        }
        for (K k : this.names()) {
            List<V> list = headers.getAll(k);
            List<V> list2 = this.getAll(k);
            if (list.size() != list2.size()) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                if (hashingStrategy.equals(list.get(i), list2.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public final int hashCode(HashingStrategy<V> hashingStrategy) {
        int n = -1028477387;
        for (K k : this.names()) {
            n = 31 * n + this.hashingStrategy.hashCode(k);
            List<V> list = this.getAll(k);
            for (int i = 0; i < list.size(); ++i) {
                n = 31 * n + hashingStrategy.hashCode(list.get(i));
            }
        }
        return n;
    }

    public String toString() {
        return HeadersUtils.toString(this.getClass(), this.iterator(), this.size());
    }

    protected void validateName(NameValidator<K> nameValidator, boolean bl, K k) {
        nameValidator.validateName(k);
    }

    protected void validateValue(ValueValidator<V> valueValidator, K k, V v) {
        try {
            valueValidator.validate(v);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Validation failed for header '" + k + "'", illegalArgumentException);
        }
    }

    protected HeaderEntry<K, V> newHeaderEntry(int n, K k, V v, HeaderEntry<K, V> headerEntry) {
        return new HeaderEntry<K, V>(n, k, v, headerEntry, this.head);
    }

    protected ValueConverter<V> valueConverter() {
        return this.valueConverter;
    }

    protected NameValidator<K> nameValidator() {
        return this.nameValidator;
    }

    protected ValueValidator<V> valueValidator() {
        return this.valueValidator;
    }

    private int index(int n) {
        return n & this.hashMask;
    }

    private void add0(int n, int n2, K k, V v) {
        this.entries[n2] = this.newHeaderEntry(n, k, v, this.entries[n2]);
        ++this.size;
    }

    private V remove0(int n, int n2, K k) {
        HeaderEntry<K, V> headerEntry = this.entries[n2];
        if (headerEntry == null) {
            return null;
        }
        V v = null;
        HeaderEntry headerEntry2 = headerEntry.next;
        while (headerEntry2 != null) {
            if (headerEntry2.hash == n && this.hashingStrategy.equals(k, headerEntry2.key)) {
                v = headerEntry2.value;
                headerEntry.next = headerEntry2.next;
                headerEntry2.remove();
                --this.size;
            } else {
                headerEntry = headerEntry2;
            }
            headerEntry2 = headerEntry.next;
        }
        headerEntry = this.entries[n2];
        if (headerEntry.hash == n && this.hashingStrategy.equals(k, headerEntry.key)) {
            if (v == null) {
                v = headerEntry.value;
            }
            this.entries[n2] = headerEntry.next;
            headerEntry.remove();
            --this.size;
        }
        return v;
    }

    HeaderEntry<K, V> remove0(HeaderEntry<K, V> headerEntry, HeaderEntry<K, V> headerEntry2) {
        int n = this.index(headerEntry.hash);
        HeaderEntry<K, V> headerEntry3 = this.entries[n];
        if (headerEntry3 == headerEntry) {
            this.entries[n] = headerEntry.next;
            headerEntry2 = this.entries[n];
        } else if (headerEntry2 == null) {
            headerEntry2 = headerEntry3;
            HeaderEntry headerEntry4 = headerEntry3.next;
            while (headerEntry4 != null && headerEntry4 != headerEntry) {
                headerEntry2 = headerEntry4;
                headerEntry4 = headerEntry4.next;
            }
            assert (headerEntry4 != null) : "Entry not found in its hash bucket: " + headerEntry;
            headerEntry2.next = headerEntry.next;
        } else {
            headerEntry2.next = headerEntry.next;
        }
        headerEntry.remove();
        --this.size;
        return headerEntry2;
    }

    private T thisT() {
        return (T)this;
    }

    private V fromObject(K k, Object object) {
        try {
            return this.valueConverter.convertObject(ObjectUtil.checkNotNull(object, "value"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert object value for header '" + k + '\'', illegalArgumentException);
        }
    }

    private V fromBoolean(K k, boolean bl) {
        try {
            return this.valueConverter.convertBoolean(bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert boolean value for header '" + k + '\'', illegalArgumentException);
        }
    }

    private V fromByte(K k, byte by) {
        try {
            return this.valueConverter.convertByte(by);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert byte value for header '" + k + '\'', illegalArgumentException);
        }
    }

    private V fromChar(K k, char c) {
        try {
            return this.valueConverter.convertChar(c);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert char value for header '" + k + '\'', illegalArgumentException);
        }
    }

    private V fromShort(K k, short s) {
        try {
            return this.valueConverter.convertShort(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert short value for header '" + k + '\'', illegalArgumentException);
        }
    }

    private V fromInt(K k, int n) {
        try {
            return this.valueConverter.convertInt(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert int value for header '" + k + '\'', illegalArgumentException);
        }
    }

    private V fromLong(K k, long l) {
        try {
            return this.valueConverter.convertLong(l);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert long value for header '" + k + '\'', illegalArgumentException);
        }
    }

    private V fromFloat(K k, float f) {
        try {
            return this.valueConverter.convertFloat(f);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert float value for header '" + k + '\'', illegalArgumentException);
        }
    }

    private V fromDouble(K k, double d) {
        try {
            return this.valueConverter.convertDouble(d);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert double value for header '" + k + '\'', illegalArgumentException);
        }
    }

    private V fromTimeMillis(K k, long l) {
        try {
            return this.valueConverter.convertTimeMillis(l);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert millsecond value for header '" + k + '\'', illegalArgumentException);
        }
    }

    private boolean toBoolean(K k, V v) {
        try {
            return this.valueConverter.convertToBoolean(v);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert header value to boolean for header '" + k + '\'');
        }
    }

    private byte toByte(K k, V v) {
        try {
            return this.valueConverter.convertToByte(v);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert header value to byte for header '" + k + '\'');
        }
    }

    private char toChar(K k, V v) {
        try {
            return this.valueConverter.convertToChar(v);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert header value to char for header '" + k + '\'');
        }
    }

    private short toShort(K k, V v) {
        try {
            return this.valueConverter.convertToShort(v);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert header value to short for header '" + k + '\'');
        }
    }

    private int toInt(K k, V v) {
        try {
            return this.valueConverter.convertToInt(v);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert header value to int for header '" + k + '\'');
        }
    }

    private long toLong(K k, V v) {
        try {
            return this.valueConverter.convertToLong(v);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert header value to long for header '" + k + '\'');
        }
    }

    private float toFloat(K k, V v) {
        try {
            return this.valueConverter.convertToFloat(v);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert header value to float for header '" + k + '\'');
        }
    }

    private double toDouble(K k, V v) {
        try {
            return this.valueConverter.convertToDouble(v);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert header value to double for header '" + k + '\'');
        }
    }

    private long toTimeMillis(K k, V v) {
        try {
            return this.valueConverter.convertToTimeMillis(v);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert header value to millsecond for header '" + k + '\'');
        }
    }

    public DefaultHeaders<K, V, T> copy() {
        DefaultHeaders<K, V, T> defaultHeaders = new DefaultHeaders<K, V, T>(this.hashingStrategy, this.valueConverter, this.nameValidator, this.entries.length);
        defaultHeaders.addImpl(this);
        return defaultHeaders;
    }

    protected static class HeaderEntry<K, V>
    implements Map.Entry<K, V> {
        protected final int hash;
        protected final K key;
        protected V value;
        protected HeaderEntry<K, V> next;
        protected HeaderEntry<K, V> before;
        protected HeaderEntry<K, V> after;

        protected HeaderEntry(int n, K k) {
            this.hash = n;
            this.key = k;
        }

        HeaderEntry(int n, K k, V v, HeaderEntry<K, V> headerEntry, HeaderEntry<K, V> headerEntry2) {
            this.hash = n;
            this.key = k;
            this.value = v;
            this.next = headerEntry;
            this.after = headerEntry2;
            this.before = headerEntry2.before;
            this.pointNeighborsToThis();
        }

        HeaderEntry() {
            this.hash = -1;
            this.key = null;
            this.before = this.after = this;
        }

        protected final void pointNeighborsToThis() {
            this.before.after = this;
            this.after.before = this;
        }

        public final HeaderEntry<K, V> before() {
            return this.before;
        }

        public final HeaderEntry<K, V> after() {
            return this.after;
        }

        protected void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V v) {
            ObjectUtil.checkNotNull(v, "value");
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        public final String toString() {
            return this.key.toString() + '=' + this.value.toString();
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    private final class ValueIterator
    implements Iterator<V> {
        private final K name;
        private final int hash;
        private HeaderEntry<K, V> removalPrevious;
        private HeaderEntry<K, V> previous;
        private HeaderEntry<K, V> next;

        ValueIterator(K k) {
            this.name = ObjectUtil.checkNotNull(k, "name");
            this.hash = DefaultHeaders.this.hashingStrategy.hashCode(k);
            this.calculateNext(DefaultHeaders.this.entries[DefaultHeaders.this.index(this.hash)]);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.previous != null) {
                this.removalPrevious = this.previous;
            }
            this.previous = this.next;
            this.calculateNext(this.next.next);
            return this.previous.value;
        }

        @Override
        public void remove() {
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            this.removalPrevious = DefaultHeaders.this.remove0(this.previous, this.removalPrevious);
            this.previous = null;
        }

        private void calculateNext(HeaderEntry<K, V> headerEntry) {
            while (headerEntry != null) {
                if (headerEntry.hash == this.hash && DefaultHeaders.this.hashingStrategy.equals(this.name, headerEntry.key)) {
                    this.next = headerEntry;
                    return;
                }
                headerEntry = headerEntry.next;
            }
            this.next = null;
        }
    }

    private final class HeaderIterator
    implements Iterator<Map.Entry<K, V>> {
        private HeaderEntry<K, V> current;

        private HeaderIterator() {
            this.current = DefaultHeaders.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.current.after != DefaultHeaders.this.head;
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.current.after;
            if (this.current == DefaultHeaders.this.head) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("read only");
        }
    }

    public static interface ValueValidator<V> {
        public static final ValueValidator<?> NO_VALIDATION = new ValueValidator<Object>(){

            @Override
            public void validate(Object object) {
            }
        };

        public void validate(V var1);
    }

    public static interface NameValidator<K> {
        public static final NameValidator NOT_NULL = new NameValidator(){

            public void validateName(Object object) {
                ObjectUtil.checkNotNull(object, "name");
            }
        };

        public void validateName(K var1);
    }
}

