/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx;

import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelFutureListener;
import pro.gravit.repackage.io.netty.channel.ChannelHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelInboundHandlerAdapter;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundInvoker;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultFullHttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.EmptyHttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpContentCompressor;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpObject;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpObjectAggregator;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequestDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponseEncoder;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpServerCodec;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpUtil;
import pro.gravit.repackage.io.netty.handler.codec.http.LastHttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.internal.EmptyArrays;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class WebSocketServerHandshaker {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerHandshaker.class);
    private final String uri;
    private final String[] subprotocols;
    private final WebSocketVersion version;
    private final WebSocketDecoderConfig decoderConfig;
    private String selectedSubprotocol;
    public static final String SUB_PROTOCOL_WILDCARD = "*";

    protected WebSocketServerHandshaker(WebSocketVersion webSocketVersion, String string, String string2, int n) {
        this(webSocketVersion, string, string2, WebSocketDecoderConfig.newBuilder().maxFramePayloadLength(n).build());
    }

    protected WebSocketServerHandshaker(WebSocketVersion webSocketVersion, String string, String string2, WebSocketDecoderConfig webSocketDecoderConfig) {
        this.version = webSocketVersion;
        this.uri = string;
        if (string2 != null) {
            String[] stringArray = string2.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
            this.subprotocols = stringArray;
        } else {
            this.subprotocols = EmptyArrays.EMPTY_STRINGS;
        }
        this.decoderConfig = ObjectUtil.checkNotNull(webSocketDecoderConfig, "decoderConfig");
    }

    public String uri() {
        return this.uri;
    }

    public Set<String> subprotocols() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Collections.addAll(linkedHashSet, this.subprotocols);
        return linkedHashSet;
    }

    public WebSocketVersion version() {
        return this.version;
    }

    public int maxFramePayloadLength() {
        return this.decoderConfig.maxFramePayloadLength();
    }

    public WebSocketDecoderConfig decoderConfig() {
        return this.decoderConfig;
    }

    public ChannelFuture handshake(Channel channel, FullHttpRequest fullHttpRequest) {
        return this.handshake(channel, fullHttpRequest, null, channel.newPromise());
    }

    public final ChannelFuture handshake(Channel channel, FullHttpRequest fullHttpRequest, HttpHeaders httpHeaders, final ChannelPromise channelPromise) {
        String string;
        ChannelHandlerContext channelHandlerContext;
        if (logger.isDebugEnabled()) {
            logger.debug("{} WebSocket version {} server handshake", (Object)channel, (Object)this.version());
        }
        FullHttpResponse fullHttpResponse = this.newHandshakeResponse(fullHttpRequest, httpHeaders);
        ChannelPipeline channelPipeline = channel.pipeline();
        if (channelPipeline.get(HttpObjectAggregator.class) != null) {
            channelPipeline.remove(HttpObjectAggregator.class);
        }
        if (channelPipeline.get(HttpContentCompressor.class) != null) {
            channelPipeline.remove(HttpContentCompressor.class);
        }
        if ((channelHandlerContext = channelPipeline.context(HttpRequestDecoder.class)) == null) {
            channelHandlerContext = channelPipeline.context(HttpServerCodec.class);
            if (channelHandlerContext == null) {
                channelPromise.setFailure(new IllegalStateException("No HttpDecoder and no HttpServerCodec in the pipeline"));
                fullHttpResponse.release();
                return channelPromise;
            }
            channelPipeline.addBefore(channelHandlerContext.name(), "wsencoder", this.newWebSocketEncoder());
            channelPipeline.addBefore(channelHandlerContext.name(), "wsdecoder", this.newWebsocketDecoder());
            string = channelHandlerContext.name();
        } else {
            channelPipeline.replace(channelHandlerContext.name(), "wsdecoder", (ChannelHandler)this.newWebsocketDecoder());
            string = channelPipeline.context(HttpResponseEncoder.class).name();
            channelPipeline.addBefore(string, "wsencoder", this.newWebSocketEncoder());
        }
        channel.writeAndFlush(fullHttpResponse).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (channelFuture.isSuccess()) {
                    ChannelPipeline channelPipeline = channelFuture.channel().pipeline();
                    channelPipeline.remove(string);
                    channelPromise.setSuccess();
                } else {
                    channelPromise.setFailure(channelFuture.cause());
                }
            }
        });
        return channelPromise;
    }

    public ChannelFuture handshake(Channel channel, HttpRequest httpRequest) {
        return this.handshake(channel, httpRequest, null, channel.newPromise());
    }

    public final ChannelFuture handshake(final Channel channel, HttpRequest httpRequest, final HttpHeaders httpHeaders, final ChannelPromise channelPromise) {
        ChannelPipeline channelPipeline;
        ChannelHandlerContext channelHandlerContext;
        if (httpRequest instanceof FullHttpRequest) {
            return this.handshake(channel, (FullHttpRequest)httpRequest, httpHeaders, channelPromise);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} WebSocket version {} server handshake", (Object)channel, (Object)this.version());
        }
        if ((channelHandlerContext = (channelPipeline = channel.pipeline()).context(HttpRequestDecoder.class)) == null && (channelHandlerContext = channelPipeline.context(HttpServerCodec.class)) == null) {
            channelPromise.setFailure(new IllegalStateException("No HttpDecoder and no HttpServerCodec in the pipeline"));
            return channelPromise;
        }
        String string = channelHandlerContext.name();
        if (HttpUtil.isContentLengthSet(httpRequest) || HttpUtil.isTransferEncodingChunked(httpRequest) || this.version == WebSocketVersion.V00) {
            string = "httpAggregator";
            channelPipeline.addAfter(channelHandlerContext.name(), string, new HttpObjectAggregator(8192));
        }
        channelPipeline.addAfter(string, "handshaker", new ChannelInboundHandlerAdapter(){
            private FullHttpRequest fullHttpRequest;

            @Override
            public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
                if (object instanceof HttpObject) {
                    try {
                        this.handleHandshakeRequest(channelHandlerContext, (HttpObject)object);
                    }
                    finally {
                        ReferenceCountUtil.release(object);
                    }
                } else {
                    super.channelRead(channelHandlerContext, object);
                }
            }

            @Override
            public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
                channelHandlerContext.pipeline().remove(this);
                channelPromise.tryFailure(throwable);
                channelHandlerContext.fireExceptionCaught(throwable);
            }

            @Override
            public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
                try {
                    if (!channelPromise.isDone()) {
                        channelPromise.tryFailure(new ClosedChannelException());
                    }
                    channelHandlerContext.fireChannelInactive();
                }
                finally {
                    this.releaseFullHttpRequest();
                }
            }

            @Override
            public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
                this.releaseFullHttpRequest();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void handleHandshakeRequest(ChannelHandlerContext channelHandlerContext, HttpObject httpObject) {
                if (httpObject instanceof FullHttpRequest) {
                    channelHandlerContext.pipeline().remove(this);
                    WebSocketServerHandshaker.this.handshake(channel, (FullHttpRequest)httpObject, httpHeaders, channelPromise);
                    return;
                }
                if (httpObject instanceof LastHttpContent) {
                    assert (this.fullHttpRequest != null);
                    FullHttpRequest fullHttpRequest = this.fullHttpRequest;
                    this.fullHttpRequest = null;
                    try {
                        channelHandlerContext.pipeline().remove(this);
                        WebSocketServerHandshaker.this.handshake(channel, fullHttpRequest, httpHeaders, channelPromise);
                    }
                    finally {
                        fullHttpRequest.release();
                    }
                    return;
                }
                if (httpObject instanceof HttpRequest) {
                    HttpRequest httpRequest = (HttpRequest)httpObject;
                    this.fullHttpRequest = new DefaultFullHttpRequest(httpRequest.protocolVersion(), httpRequest.method(), httpRequest.uri(), Unpooled.EMPTY_BUFFER, httpRequest.headers(), EmptyHttpHeaders.INSTANCE);
                    if (httpRequest.decoderResult().isFailure()) {
                        this.fullHttpRequest.setDecoderResult(httpRequest.decoderResult());
                    }
                }
            }

            private void releaseFullHttpRequest() {
                if (this.fullHttpRequest != null) {
                    this.fullHttpRequest.release();
                    this.fullHttpRequest = null;
                }
            }
        });
        try {
            channelHandlerContext.fireChannelRead(ReferenceCountUtil.retain(httpRequest));
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
        return channelPromise;
    }

    protected abstract FullHttpResponse newHandshakeResponse(FullHttpRequest var1, HttpHeaders var2);

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame) {
        ObjectUtil.checkNotNull(channel, "channel");
        return this.close(channel, closeWebSocketFrame, channel.newPromise());
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        return this.close0(channel, closeWebSocketFrame, channelPromise);
    }

    public ChannelFuture close(ChannelHandlerContext channelHandlerContext, CloseWebSocketFrame closeWebSocketFrame) {
        ObjectUtil.checkNotNull(channelHandlerContext, "ctx");
        return this.close(channelHandlerContext, closeWebSocketFrame, channelHandlerContext.newPromise());
    }

    public ChannelFuture close(ChannelHandlerContext channelHandlerContext, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(channelHandlerContext, "ctx");
        return this.close0(channelHandlerContext, closeWebSocketFrame, channelPromise).addListener(ChannelFutureListener.CLOSE);
    }

    private ChannelFuture close0(ChannelOutboundInvoker channelOutboundInvoker, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        return channelOutboundInvoker.writeAndFlush(closeWebSocketFrame, channelPromise).addListener(ChannelFutureListener.CLOSE);
    }

    protected String selectSubprotocol(String string) {
        String[] stringArray;
        if (string == null || this.subprotocols.length == 0) {
            return null;
        }
        for (String string2 : stringArray = string.split(",")) {
            String string3 = string2.trim();
            for (String string4 : this.subprotocols) {
                if (!SUB_PROTOCOL_WILDCARD.equals(string4) && !string3.equals(string4)) continue;
                this.selectedSubprotocol = string3;
                return string3;
            }
        }
        return null;
    }

    public String selectedSubprotocol() {
        return this.selectedSubprotocol;
    }

    protected abstract WebSocketFrameDecoder newWebsocketDecoder();

    protected abstract WebSocketFrameEncoder newWebSocketEncoder();
}

