/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx;

import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultFullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponseStatus;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpUtil;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpVersion;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker00;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker07;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker08;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker13;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class WebSocketServerHandshakerFactory {
    private final String webSocketURL;
    private final String subprotocols;
    private final WebSocketDecoderConfig decoderConfig;

    public WebSocketServerHandshakerFactory(String string, String string2, boolean bl) {
        this(string, string2, bl, 65536);
    }

    public WebSocketServerHandshakerFactory(String string, String string2, boolean bl, int n) {
        this(string, string2, bl, n, false);
    }

    public WebSocketServerHandshakerFactory(String string, String string2, boolean bl, int n, boolean bl2) {
        this(string, string2, WebSocketDecoderConfig.newBuilder().allowExtensions(bl).maxFramePayloadLength(n).allowMaskMismatch(bl2).build());
    }

    public WebSocketServerHandshakerFactory(String string, String string2, WebSocketDecoderConfig webSocketDecoderConfig) {
        this.webSocketURL = string;
        this.subprotocols = string2;
        this.decoderConfig = ObjectUtil.checkNotNull(webSocketDecoderConfig, "decoderConfig");
    }

    public WebSocketServerHandshaker newHandshaker(HttpRequest httpRequest) {
        String string = httpRequest.headers().get(HttpHeaderNames.SEC_WEBSOCKET_VERSION);
        if (string != null) {
            if (string.equals(WebSocketVersion.V13.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker13(this.webSocketURL, this.subprotocols, this.decoderConfig);
            }
            if (string.equals(WebSocketVersion.V08.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker08(this.webSocketURL, this.subprotocols, this.decoderConfig);
            }
            if (string.equals(WebSocketVersion.V07.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker07(this.webSocketURL, this.subprotocols, this.decoderConfig);
            }
            return null;
        }
        return new WebSocketServerHandshaker00(this.webSocketURL, this.subprotocols, this.decoderConfig);
    }

    @Deprecated
    public static void sendUnsupportedWebSocketVersionResponse(Channel channel) {
        WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channel);
    }

    public static ChannelFuture sendUnsupportedVersionResponse(Channel channel) {
        return WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channel, channel.newPromise());
    }

    public static ChannelFuture sendUnsupportedVersionResponse(Channel channel, ChannelPromise channelPromise) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UPGRADE_REQUIRED, channel.alloc().buffer(0));
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)WebSocketVersion.V13.toHttpHeaderValue());
        HttpUtil.setContentLength(defaultFullHttpResponse, 0L);
        return channel.writeAndFlush(defaultFullHttpResponse, channelPromise);
    }
}

