/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.compression;

import java.util.List;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.compression.DeflateDecoder;

class PerMessageDeflateDecoder
extends DeflateDecoder {
    private boolean compressing;

    PerMessageDeflateDecoder(boolean bl) {
        super(bl, WebSocketExtensionFilter.NEVER_SKIP);
    }

    PerMessageDeflateDecoder(boolean bl, WebSocketExtensionFilter webSocketExtensionFilter) {
        super(bl, webSocketExtensionFilter);
    }

    @Override
    public boolean acceptInboundMessage(Object object) throws Exception {
        if (!super.acceptInboundMessage(object)) {
            return false;
        }
        WebSocketFrame webSocketFrame = (WebSocketFrame)object;
        if (this.extensionDecoderFilter().mustSkip(webSocketFrame)) {
            if (this.compressing) {
                throw new IllegalStateException("Cannot skip per message deflate decoder, compression in progress");
            }
            return false;
        }
        return (webSocketFrame instanceof TextWebSocketFrame || webSocketFrame instanceof BinaryWebSocketFrame) && (webSocketFrame.rsv() & 4) > 0 || webSocketFrame instanceof ContinuationWebSocketFrame && this.compressing;
    }

    @Override
    protected int newRsv(WebSocketFrame webSocketFrame) {
        return (webSocketFrame.rsv() & 4) > 0 ? webSocketFrame.rsv() ^ 4 : webSocketFrame.rsv();
    }

    @Override
    protected boolean appendFrameTail(WebSocketFrame webSocketFrame) {
        return webSocketFrame.isFinalFragment();
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) throws Exception {
        super.decode(channelHandlerContext, webSocketFrame, list);
        if (webSocketFrame.isFinalFragment()) {
            this.compressing = false;
        } else if (webSocketFrame instanceof TextWebSocketFrame || webSocketFrame instanceof BinaryWebSocketFrame) {
            this.compressing = true;
        }
    }
}

