/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.pcap;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicReference;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelDuplexHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.channel.socket.DatagramChannel;
import pro.gravit.repackage.io.netty.channel.socket.DatagramPacket;
import pro.gravit.repackage.io.netty.channel.socket.ServerSocketChannel;
import pro.gravit.repackage.io.netty.channel.socket.SocketChannel;
import pro.gravit.repackage.io.netty.handler.pcap.EthernetPacket;
import pro.gravit.repackage.io.netty.handler.pcap.IPPacket;
import pro.gravit.repackage.io.netty.handler.pcap.PcapHeaders;
import pro.gravit.repackage.io.netty.handler.pcap.PcapWriter;
import pro.gravit.repackage.io.netty.handler.pcap.State;
import pro.gravit.repackage.io.netty.handler.pcap.TCPPacket;
import pro.gravit.repackage.io.netty.handler.pcap.UDPPacket;
import pro.gravit.repackage.io.netty.util.NetUtil;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public final class PcapWriteHandler
extends ChannelDuplexHandler
implements Closeable {
    private final InternalLogger logger = InternalLoggerFactory.getInstance(PcapWriteHandler.class);
    private PcapWriter pCapWriter;
    private final OutputStream outputStream;
    private final boolean captureZeroByte;
    private final boolean writePcapGlobalHeader;
    private final boolean sharedOutputStream;
    private int sendSegmentNumber = 1;
    private int receiveSegmentNumber = 1;
    private ChannelType channelType;
    private InetSocketAddress initiatorAddr;
    private InetSocketAddress handlerAddr;
    private boolean isServerPipeline;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);

    @Deprecated
    public PcapWriteHandler(OutputStream outputStream) {
        this(outputStream, false, true);
    }

    @Deprecated
    public PcapWriteHandler(OutputStream outputStream, boolean bl, boolean bl2) {
        this.outputStream = ObjectUtil.checkNotNull(outputStream, "OutputStream");
        this.captureZeroByte = bl;
        this.writePcapGlobalHeader = bl2;
        this.sharedOutputStream = false;
    }

    private PcapWriteHandler(Builder builder, OutputStream outputStream) {
        this.outputStream = outputStream;
        this.captureZeroByte = builder.captureZeroByte;
        this.sharedOutputStream = builder.sharedOutputStream;
        this.writePcapGlobalHeader = builder.writePcapGlobalHeader;
        this.channelType = builder.channelType;
        this.handlerAddr = builder.handlerAddr;
        this.initiatorAddr = builder.initiatorAddr;
        this.isServerPipeline = builder.isServerPipeline;
    }

    public static void writeGlobalHeader(OutputStream outputStream) throws IOException {
        PcapHeaders.writeGlobalHeader(outputStream);
    }

    private void initializeIfNecessary(ChannelHandlerContext channelHandlerContext) throws Exception {
        Comparable<ByteBuf> comparable;
        if (this.state.get() != State.INIT) {
            return;
        }
        this.pCapWriter = new PcapWriter(this);
        if (this.channelType == null) {
            if (channelHandlerContext.channel() instanceof SocketChannel) {
                this.channelType = ChannelType.TCP;
                if (channelHandlerContext.channel().parent() instanceof ServerSocketChannel) {
                    this.isServerPipeline = true;
                    this.initiatorAddr = (InetSocketAddress)channelHandlerContext.channel().remoteAddress();
                    this.handlerAddr = PcapWriteHandler.getLocalAddress(channelHandlerContext.channel(), this.initiatorAddr);
                } else {
                    this.isServerPipeline = false;
                    this.handlerAddr = (InetSocketAddress)channelHandlerContext.channel().remoteAddress();
                    this.initiatorAddr = PcapWriteHandler.getLocalAddress(channelHandlerContext.channel(), this.handlerAddr);
                }
            } else if (channelHandlerContext.channel() instanceof DatagramChannel) {
                this.channelType = ChannelType.UDP;
                comparable = (DatagramChannel)channelHandlerContext.channel();
                if (comparable.isConnected()) {
                    this.handlerAddr = (InetSocketAddress)channelHandlerContext.channel().remoteAddress();
                    this.initiatorAddr = PcapWriteHandler.getLocalAddress(channelHandlerContext.channel(), this.handlerAddr);
                }
            }
        }
        if (this.channelType == ChannelType.TCP) {
            this.logger.debug("Initiating Fake TCP 3-Way Handshake");
            comparable = channelHandlerContext.alloc().buffer();
            try {
                TCPPacket.writePacket((ByteBuf)comparable, null, 0, 0, this.initiatorAddr.getPort(), this.handlerAddr.getPort(), TCPPacket.TCPFlag.SYN);
                this.completeTCPWrite(this.initiatorAddr, this.handlerAddr, (ByteBuf)comparable, channelHandlerContext.alloc(), channelHandlerContext);
                TCPPacket.writePacket(comparable, null, 0, 1, this.handlerAddr.getPort(), this.initiatorAddr.getPort(), new TCPPacket.TCPFlag[]{TCPPacket.TCPFlag.SYN, TCPPacket.TCPFlag.ACK});
                this.completeTCPWrite(this.handlerAddr, this.initiatorAddr, (ByteBuf)comparable, channelHandlerContext.alloc(), channelHandlerContext);
                TCPPacket.writePacket(comparable, null, 1, 1, this.initiatorAddr.getPort(), this.handlerAddr.getPort(), new TCPPacket.TCPFlag[]{TCPPacket.TCPFlag.ACK});
                this.completeTCPWrite(this.initiatorAddr, this.handlerAddr, (ByteBuf)comparable, channelHandlerContext.alloc(), channelHandlerContext);
            }
            finally {
                comparable.release();
            }
            this.logger.debug("Finished Fake TCP 3-Way Handshake");
        }
        this.state.set(State.WRITING);
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.initializeIfNecessary(channelHandlerContext);
        super.channelActive(channelHandlerContext);
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (this.state.get() == State.INIT) {
            this.initializeIfNecessary(channelHandlerContext);
        }
        if (this.state.get() == State.WRITING) {
            if (this.channelType == ChannelType.TCP) {
                this.handleTCP(channelHandlerContext, object, false);
            } else if (this.channelType == ChannelType.UDP) {
                this.handleUDP(channelHandlerContext, object);
            } else {
                this.logDiscard();
            }
        }
        super.channelRead(channelHandlerContext, object);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        if (this.state.get() == State.INIT) {
            this.initializeIfNecessary(channelHandlerContext);
        }
        if (this.state.get() == State.WRITING) {
            if (this.channelType == ChannelType.TCP) {
                this.handleTCP(channelHandlerContext, object, true);
            } else if (this.channelType == ChannelType.UDP) {
                this.handleUDP(channelHandlerContext, object);
            } else {
                this.logDiscard();
            }
        }
        super.write(channelHandlerContext, object, channelPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTCP(ChannelHandlerContext channelHandlerContext, Object object, boolean bl) {
        if (object instanceof ByteBuf) {
            if (((ByteBuf)object).readableBytes() == 0 && !this.captureZeroByte) {
                this.logger.debug("Discarding Zero Byte TCP Packet. isWriteOperation {}", (Object)bl);
                return;
            }
            ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
            ByteBuf byteBuf = ((ByteBuf)object).duplicate();
            ByteBuf byteBuf2 = byteBufAllocator.buffer();
            int n = byteBuf.readableBytes();
            try {
                InetSocketAddress inetSocketAddress;
                InetSocketAddress inetSocketAddress2;
                if (bl) {
                    InetSocketAddress inetSocketAddress3;
                    InetSocketAddress inetSocketAddress4;
                    if (this.isServerPipeline) {
                        inetSocketAddress4 = this.handlerAddr;
                        inetSocketAddress3 = this.initiatorAddr;
                    } else {
                        inetSocketAddress4 = this.initiatorAddr;
                        inetSocketAddress3 = this.handlerAddr;
                    }
                    TCPPacket.writePacket(byteBuf2, byteBuf, this.sendSegmentNumber, this.receiveSegmentNumber, inetSocketAddress4.getPort(), inetSocketAddress3.getPort(), TCPPacket.TCPFlag.ACK);
                    this.completeTCPWrite(inetSocketAddress4, inetSocketAddress3, byteBuf2, byteBufAllocator, channelHandlerContext);
                    this.logTCP(true, n, this.sendSegmentNumber, this.receiveSegmentNumber, inetSocketAddress4, inetSocketAddress3, false);
                    this.sendSegmentNumber += n;
                    TCPPacket.writePacket(byteBuf2, null, this.receiveSegmentNumber, this.sendSegmentNumber, inetSocketAddress3.getPort(), inetSocketAddress4.getPort(), TCPPacket.TCPFlag.ACK);
                    this.completeTCPWrite(inetSocketAddress3, inetSocketAddress4, byteBuf2, byteBufAllocator, channelHandlerContext);
                    this.logTCP(true, n, this.sendSegmentNumber, this.receiveSegmentNumber, inetSocketAddress3, inetSocketAddress4, true);
                }
                if (this.isServerPipeline) {
                    inetSocketAddress2 = this.initiatorAddr;
                    inetSocketAddress = this.handlerAddr;
                } else {
                    inetSocketAddress2 = this.handlerAddr;
                    inetSocketAddress = this.initiatorAddr;
                }
                TCPPacket.writePacket(byteBuf2, byteBuf, this.receiveSegmentNumber, this.sendSegmentNumber, inetSocketAddress2.getPort(), inetSocketAddress.getPort(), TCPPacket.TCPFlag.ACK);
                this.completeTCPWrite(inetSocketAddress2, inetSocketAddress, byteBuf2, byteBufAllocator, channelHandlerContext);
                this.logTCP(false, n, this.receiveSegmentNumber, this.sendSegmentNumber, inetSocketAddress2, inetSocketAddress, false);
                this.receiveSegmentNumber += n;
                TCPPacket.writePacket(byteBuf2, null, this.sendSegmentNumber, this.receiveSegmentNumber, inetSocketAddress.getPort(), inetSocketAddress2.getPort(), TCPPacket.TCPFlag.ACK);
                this.completeTCPWrite(inetSocketAddress, inetSocketAddress2, byteBuf2, byteBufAllocator, channelHandlerContext);
                this.logTCP(false, n, this.sendSegmentNumber, this.receiveSegmentNumber, inetSocketAddress, inetSocketAddress2, true);
            }
            finally {
                byteBuf2.release();
            }
        } else {
            this.logger.debug("Discarding Pcap Write for TCP Object: {}", object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeTCPWrite(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, ByteBuf byteBuf, ByteBufAllocator byteBufAllocator, ChannelHandlerContext channelHandlerContext) {
        ByteBuf byteBuf2 = byteBufAllocator.buffer();
        ByteBuf byteBuf3 = byteBufAllocator.buffer();
        ByteBuf byteBuf4 = byteBufAllocator.buffer();
        try {
            if (inetSocketAddress.getAddress() instanceof Inet4Address && inetSocketAddress2.getAddress() instanceof Inet4Address) {
                IPPacket.writeTCPv4(byteBuf2, byteBuf, NetUtil.ipv4AddressToInt((Inet4Address)inetSocketAddress.getAddress()), NetUtil.ipv4AddressToInt((Inet4Address)inetSocketAddress2.getAddress()));
                EthernetPacket.writeIPv4(byteBuf3, byteBuf2);
            } else if (inetSocketAddress.getAddress() instanceof Inet6Address && inetSocketAddress2.getAddress() instanceof Inet6Address) {
                IPPacket.writeTCPv6(byteBuf2, byteBuf, inetSocketAddress.getAddress().getAddress(), inetSocketAddress2.getAddress().getAddress());
                EthernetPacket.writeIPv6(byteBuf3, byteBuf2);
            } else {
                this.logger.error("Source and Destination IP Address versions are not same. Source Address: {}, Destination Address: {}", (Object)inetSocketAddress.getAddress(), (Object)inetSocketAddress2.getAddress());
                return;
            }
            this.pCapWriter.writePacket(byteBuf4, byteBuf3);
        }
        catch (IOException iOException) {
            this.logger.error("Caught Exception While Writing Packet into Pcap", iOException);
            channelHandlerContext.fireExceptionCaught(iOException);
        }
        finally {
            byteBuf2.release();
            byteBuf3.release();
            byteBuf4.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUDP(ChannelHandlerContext channelHandlerContext, Object object) {
        ByteBuf byteBuf = channelHandlerContext.alloc().buffer();
        try {
            if (object instanceof DatagramPacket) {
                if (((ByteBuf)((DatagramPacket)object).content()).readableBytes() == 0 && !this.captureZeroByte) {
                    this.logger.debug("Discarding Zero Byte UDP Packet");
                    return;
                }
                DatagramPacket datagramPacket = ((DatagramPacket)object).duplicate();
                InetSocketAddress inetSocketAddress = (InetSocketAddress)datagramPacket.sender();
                InetSocketAddress inetSocketAddress2 = (InetSocketAddress)datagramPacket.recipient();
                if (inetSocketAddress == null) {
                    inetSocketAddress = PcapWriteHandler.getLocalAddress(channelHandlerContext.channel(), inetSocketAddress2);
                }
                this.logger.debug("Writing UDP Data of {} Bytes, Src Addr {}, Dst Addr {}", ((ByteBuf)datagramPacket.content()).readableBytes(), inetSocketAddress, inetSocketAddress2);
                UDPPacket.writePacket(byteBuf, (ByteBuf)datagramPacket.content(), inetSocketAddress.getPort(), inetSocketAddress2.getPort());
                this.completeUDPWrite(inetSocketAddress, inetSocketAddress2, byteBuf, channelHandlerContext.alloc(), channelHandlerContext);
            } else if (object instanceof ByteBuf && (!(channelHandlerContext.channel() instanceof DatagramChannel) || ((DatagramChannel)channelHandlerContext.channel()).isConnected())) {
                if (((ByteBuf)object).readableBytes() == 0 && !this.captureZeroByte) {
                    this.logger.debug("Discarding Zero Byte UDP Packet");
                    return;
                }
                ByteBuf byteBuf2 = ((ByteBuf)object).duplicate();
                this.logger.debug("Writing UDP Data of {} Bytes, Src Addr {}, Dst Addr {}", byteBuf2.readableBytes(), this.initiatorAddr, this.handlerAddr);
                UDPPacket.writePacket(byteBuf, byteBuf2, this.initiatorAddr.getPort(), this.handlerAddr.getPort());
                this.completeUDPWrite(this.initiatorAddr, this.handlerAddr, byteBuf, channelHandlerContext.alloc(), channelHandlerContext);
            } else {
                this.logger.debug("Discarding Pcap Write for UDP Object: {}", object);
            }
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeUDPWrite(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, ByteBuf byteBuf, ByteBufAllocator byteBufAllocator, ChannelHandlerContext channelHandlerContext) {
        ByteBuf byteBuf2 = byteBufAllocator.buffer();
        ByteBuf byteBuf3 = byteBufAllocator.buffer();
        ByteBuf byteBuf4 = byteBufAllocator.buffer();
        try {
            if (inetSocketAddress.getAddress() instanceof Inet4Address && inetSocketAddress2.getAddress() instanceof Inet4Address) {
                IPPacket.writeUDPv4(byteBuf2, byteBuf, NetUtil.ipv4AddressToInt((Inet4Address)inetSocketAddress.getAddress()), NetUtil.ipv4AddressToInt((Inet4Address)inetSocketAddress2.getAddress()));
                EthernetPacket.writeIPv4(byteBuf3, byteBuf2);
            } else if (inetSocketAddress.getAddress() instanceof Inet6Address && inetSocketAddress2.getAddress() instanceof Inet6Address) {
                IPPacket.writeUDPv6(byteBuf2, byteBuf, inetSocketAddress.getAddress().getAddress(), inetSocketAddress2.getAddress().getAddress());
                EthernetPacket.writeIPv6(byteBuf3, byteBuf2);
            } else {
                this.logger.error("Source and Destination IP Address versions are not same. Source Address: {}, Destination Address: {}", (Object)inetSocketAddress.getAddress(), (Object)inetSocketAddress2.getAddress());
                return;
            }
            this.pCapWriter.writePacket(byteBuf4, byteBuf3);
        }
        catch (IOException iOException) {
            this.logger.error("Caught Exception While Writing Packet into Pcap", iOException);
            channelHandlerContext.fireExceptionCaught(iOException);
        }
        finally {
            byteBuf2.release();
            byteBuf3.release();
            byteBuf4.release();
        }
    }

    private static InetSocketAddress getLocalAddress(Channel channel, InetSocketAddress inetSocketAddress) {
        InetSocketAddress inetSocketAddress2 = (InetSocketAddress)channel.localAddress();
        if (inetSocketAddress != null && inetSocketAddress2.getAddress().isAnyLocalAddress()) {
            if (inetSocketAddress2.getAddress() instanceof Inet4Address && inetSocketAddress.getAddress() instanceof Inet6Address) {
                return new InetSocketAddress(WildcardAddressHolder.wildcard6, inetSocketAddress2.getPort());
            }
            if (inetSocketAddress2.getAddress() instanceof Inet6Address && inetSocketAddress.getAddress() instanceof Inet4Address) {
                return new InetSocketAddress(WildcardAddressHolder.wildcard4, inetSocketAddress2.getPort());
            }
        }
        return inetSocketAddress2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.channelType == ChannelType.TCP) {
            this.logger.debug("Starting Fake TCP FIN+ACK Flow to close connection");
            ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
            ByteBuf byteBuf = byteBufAllocator.buffer();
            try {
                TCPPacket.writePacket(byteBuf, null, this.sendSegmentNumber, this.receiveSegmentNumber, this.initiatorAddr.getPort(), this.handlerAddr.getPort(), TCPPacket.TCPFlag.FIN, TCPPacket.TCPFlag.ACK);
                this.completeTCPWrite(this.initiatorAddr, this.handlerAddr, byteBuf, byteBufAllocator, channelHandlerContext);
                TCPPacket.writePacket(byteBuf, null, this.receiveSegmentNumber, this.sendSegmentNumber, this.handlerAddr.getPort(), this.initiatorAddr.getPort(), TCPPacket.TCPFlag.FIN, TCPPacket.TCPFlag.ACK);
                this.completeTCPWrite(this.handlerAddr, this.initiatorAddr, byteBuf, byteBufAllocator, channelHandlerContext);
                TCPPacket.writePacket(byteBuf, null, this.sendSegmentNumber + 1, this.receiveSegmentNumber + 1, this.initiatorAddr.getPort(), this.handlerAddr.getPort(), TCPPacket.TCPFlag.ACK);
                this.completeTCPWrite(this.initiatorAddr, this.handlerAddr, byteBuf, byteBufAllocator, channelHandlerContext);
            }
            finally {
                byteBuf.release();
            }
            this.logger.debug("Finished Fake TCP FIN+ACK Flow to close connection");
        }
        this.close();
        super.handlerRemoved(channelHandlerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        if (this.channelType == ChannelType.TCP) {
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer();
            try {
                TCPPacket.writePacket(byteBuf, null, this.sendSegmentNumber, this.receiveSegmentNumber, this.initiatorAddr.getPort(), this.handlerAddr.getPort(), TCPPacket.TCPFlag.RST, TCPPacket.TCPFlag.ACK);
                this.completeTCPWrite(this.initiatorAddr, this.handlerAddr, byteBuf, channelHandlerContext.alloc(), channelHandlerContext);
            }
            finally {
                byteBuf.release();
            }
            this.logger.debug("Sent Fake TCP RST to close connection");
        }
        this.close();
        channelHandlerContext.fireExceptionCaught(throwable);
    }

    private void logTCP(boolean bl, int n, int n2, int n3, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, boolean bl2) {
        if (this.logger.isDebugEnabled()) {
            if (bl2) {
                this.logger.debug("Writing TCP ACK, isWriteOperation {}, Segment Number {}, Ack Number {}, Src Addr {}, Dst Addr {}", bl, n2, n3, inetSocketAddress2, inetSocketAddress);
            } else {
                this.logger.debug("Writing TCP Data of {} Bytes, isWriteOperation {}, Segment Number {}, Ack Number {}, Src Addr {}, Dst Addr {}", n, bl, n2, n3, inetSocketAddress, inetSocketAddress2);
            }
        }
    }

    OutputStream outputStream() {
        return this.outputStream;
    }

    boolean sharedOutputStream() {
        return this.sharedOutputStream;
    }

    public boolean isWriting() {
        return this.state.get() == State.WRITING;
    }

    State state() {
        return this.state.get();
    }

    public void pause() {
        if (!this.state.compareAndSet(State.WRITING, State.PAUSED)) {
            throw new IllegalStateException("State must be 'STARTED' to pause but current state is: " + this.state);
        }
    }

    public void resume() {
        if (!this.state.compareAndSet(State.PAUSED, State.WRITING)) {
            throw new IllegalStateException("State must be 'PAUSED' to resume but current state is: " + this.state);
        }
    }

    void markClosed() {
        if (this.state.get() != State.CLOSED) {
            this.state.set(State.CLOSED);
        }
    }

    PcapWriter pCapWriter() {
        return this.pCapWriter;
    }

    private void logDiscard() {
        this.logger.warn("Discarding pcap write because channel type is unknown. The channel this handler is registered on is not a SocketChannel or DatagramChannel, so the inference does not work. Please call forceTcpChannel or forceUdpChannel before registering the handler.");
    }

    public String toString() {
        return "PcapWriteHandler{captureZeroByte=" + this.captureZeroByte + ", writePcapGlobalHeader=" + this.writePcapGlobalHeader + ", sharedOutputStream=" + this.sharedOutputStream + ", sendSegmentNumber=" + this.sendSegmentNumber + ", receiveSegmentNumber=" + this.receiveSegmentNumber + ", channelType=" + (Object)((Object)this.channelType) + ", initiatorAddr=" + this.initiatorAddr + ", handlerAddr=" + this.handlerAddr + ", isServerPipeline=" + this.isServerPipeline + ", state=" + this.state + '}';
    }

    @Override
    public void close() throws IOException {
        if (this.state.get() == State.CLOSED) {
            this.logger.debug("PcapWriterHandler is already closed");
        } else {
            this.pCapWriter.close();
            this.markClosed();
            this.logger.debug("PcapWriterHandler is now closed");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class WildcardAddressHolder {
        static final InetAddress wildcard4;
        static final InetAddress wildcard6;

        private WildcardAddressHolder() {
        }

        static {
            try {
                wildcard4 = InetAddress.getByAddress(new byte[4]);
                wildcard6 = InetAddress.getByAddress(new byte[16]);
            }
            catch (UnknownHostException unknownHostException) {
                throw new AssertionError((Object)unknownHostException);
            }
        }
    }

    public static final class Builder {
        private boolean captureZeroByte;
        private boolean sharedOutputStream;
        private boolean writePcapGlobalHeader = true;
        private ChannelType channelType;
        private InetSocketAddress initiatorAddr;
        private InetSocketAddress handlerAddr;
        private boolean isServerPipeline;

        private Builder() {
        }

        public Builder captureZeroByte(boolean bl) {
            this.captureZeroByte = bl;
            return this;
        }

        public Builder sharedOutputStream(boolean bl) {
            this.sharedOutputStream = bl;
            return this;
        }

        public Builder writePcapGlobalHeader(boolean bl) {
            this.writePcapGlobalHeader = bl;
            return this;
        }

        public Builder forceTcpChannel(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, boolean bl) {
            this.channelType = ChannelType.TCP;
            this.handlerAddr = ObjectUtil.checkNotNull(inetSocketAddress, "serverAddress");
            this.initiatorAddr = ObjectUtil.checkNotNull(inetSocketAddress2, "clientAddress");
            this.isServerPipeline = bl;
            return this;
        }

        public Builder forceUdpChannel(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
            this.channelType = ChannelType.UDP;
            this.handlerAddr = ObjectUtil.checkNotNull(inetSocketAddress2, "remoteAddress");
            this.initiatorAddr = ObjectUtil.checkNotNull(inetSocketAddress, "localAddress");
            return this;
        }

        public PcapWriteHandler build(OutputStream outputStream) {
            ObjectUtil.checkNotNull(outputStream, "outputStream");
            return new PcapWriteHandler(this, outputStream);
        }
    }

    private static enum ChannelType {
        TCP,
        UDP;

    }
}

