/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.conscrypt.AllocatedBuffer;
import org.conscrypt.BufferAllocator;
import org.conscrypt.Conscrypt;
import org.conscrypt.HandshakeListener;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import pro.gravit.repackage.io.netty.handler.ssl.JdkSslEngine;
import pro.gravit.repackage.io.netty.handler.ssl.SslUtils;
import pro.gravit.repackage.io.netty.util.internal.EmptyArrays;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;

abstract class ConscryptAlpnSslEngine
extends JdkSslEngine {
    private static final boolean USE_BUFFER_ALLOCATOR = SystemPropertyUtil.getBoolean("pro.gravit.repackage.io.netty.handler.ssl.conscrypt.useBufferAllocator", true);

    static ConscryptAlpnSslEngine newClientEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
        return new ClientEngine(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator);
    }

    static ConscryptAlpnSslEngine newServerEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
        return new ServerEngine(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator);
    }

    private ConscryptAlpnSslEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, List<String> list) {
        super(sSLEngine);
        if (USE_BUFFER_ALLOCATOR) {
            Conscrypt.setBufferAllocator((SSLEngine)sSLEngine, (BufferAllocator)new BufferAllocatorAdapter(byteBufAllocator));
        }
        Conscrypt.setApplicationProtocols((SSLEngine)sSLEngine, (String[])list.toArray(EmptyArrays.EMPTY_STRINGS));
    }

    final int calculateOutNetBufSize(int n, int n2) {
        return this.calculateSpace(n, n2, Integer.MAX_VALUE);
    }

    final int calculateRequiredOutBufSpace(int n, int n2) {
        return this.calculateSpace(n, n2, Conscrypt.maxEncryptedPacketLength());
    }

    private int calculateSpace(int n, int n2, long l) {
        long l2 = (long)Conscrypt.maxSealOverhead((SSLEngine)this.getWrappedEngine()) * (long)n2;
        return (int)Math.min(l, (long)n + l2);
    }

    final SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) throws SSLException {
        return Conscrypt.unwrap((SSLEngine)this.getWrappedEngine(), (ByteBuffer[])byteBufferArray, (ByteBuffer[])byteBufferArray2);
    }

    private static final class BufferAdapter
    extends AllocatedBuffer {
        private final ByteBuf nettyBuffer;
        private final ByteBuffer buffer;

        BufferAdapter(ByteBuf byteBuf) {
            this.nettyBuffer = byteBuf;
            this.buffer = byteBuf.nioBuffer(0, byteBuf.capacity());
        }

        public ByteBuffer nioBuffer() {
            return this.buffer;
        }

        public AllocatedBuffer retain() {
            this.nettyBuffer.retain();
            return this;
        }

        public AllocatedBuffer release() {
            this.nettyBuffer.release();
            return this;
        }
    }

    private static final class BufferAllocatorAdapter
    extends BufferAllocator {
        private final ByteBufAllocator alloc;

        BufferAllocatorAdapter(ByteBufAllocator byteBufAllocator) {
            this.alloc = byteBufAllocator;
        }

        public AllocatedBuffer allocateDirectBuffer(int n) {
            return new BufferAdapter(this.alloc.directBuffer(n));
        }
    }

    private static final class ServerEngine
    extends ConscryptAlpnSslEngine {
        private final JdkApplicationProtocolNegotiator.ProtocolSelector protocolSelector;

        ServerEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
            super(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator.protocols());
            Conscrypt.setHandshakeListener((SSLEngine)sSLEngine, (HandshakeListener)new HandshakeListener(){

                public void onHandshakeFinished() throws SSLException {
                    ServerEngine.this.selectProtocol();
                }
            });
            this.protocolSelector = ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(jdkApplicationProtocolNegotiator.protocols())), "protocolSelector");
        }

        private void selectProtocol() throws SSLException {
            try {
                String string = Conscrypt.getApplicationProtocol((SSLEngine)this.getWrappedEngine());
                this.protocolSelector.select(string != null ? Collections.singletonList(string) : Collections.emptyList());
            }
            catch (Throwable throwable) {
                throw SslUtils.toSSLHandshakeException(throwable);
            }
        }
    }

    private static final class ClientEngine
    extends ConscryptAlpnSslEngine {
        private final JdkApplicationProtocolNegotiator.ProtocolSelectionListener protocolListener;

        ClientEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
            super(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator.protocols());
            Conscrypt.setHandshakeListener((SSLEngine)sSLEngine, (HandshakeListener)new HandshakeListener(){

                public void onHandshakeFinished() throws SSLException {
                    ClientEngine.this.selectProtocol();
                }
            });
            this.protocolListener = ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator.protocolListenerFactory().newListener(this, jdkApplicationProtocolNegotiator.protocols()), "protocolListener");
        }

        private void selectProtocol() throws SSLException {
            String string = Conscrypt.getApplicationProtocol((SSLEngine)this.getWrappedEngine());
            try {
                this.protocolListener.selected(string);
            }
            catch (Throwable throwable) {
                throw SslUtils.toSSLHandshakeException(throwable);
            }
        }
    }
}

