/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509KeyManager;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.UnpooledByteBufAllocator;
import pro.gravit.repackage.io.netty.handler.ssl.DefaultOpenSslKeyMaterial;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslKeyMaterial;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslPrivateKey;
import pro.gravit.repackage.io.netty.handler.ssl.PemEncoded;
import pro.gravit.repackage.io.netty.handler.ssl.PemX509Certificate;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import pro.gravit.repackage.io.netty.internal.tcnative.SSL;

class OpenSslKeyMaterialProvider {
    private final X509KeyManager keyManager;
    private final String password;

    OpenSslKeyMaterialProvider(X509KeyManager x509KeyManager, String string) {
        this.keyManager = x509KeyManager;
        this.password = string;
    }

    static void validateKeyMaterialSupported(X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string) throws SSLException {
        OpenSslKeyMaterialProvider.validateSupported(x509CertificateArray);
        OpenSslKeyMaterialProvider.validateSupported(privateKey, string);
    }

    private static void validateSupported(PrivateKey privateKey, String string) throws SSLException {
        if (privateKey == null) {
            return;
        }
        long l = 0L;
        long l2 = 0L;
        try {
            l = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, privateKey);
            l2 = SSL.parsePrivateKey((long)l, (String)string);
        }
        catch (Exception exception) {
            throw new SSLException("PrivateKey type not supported " + privateKey.getFormat(), exception);
        }
        finally {
            SSL.freeBIO((long)l);
            if (l2 != 0L) {
                SSL.freePrivateKey((long)l2);
            }
        }
    }

    private static void validateSupported(X509Certificate[] x509CertificateArray) throws SSLException {
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return;
        }
        long l = 0L;
        long l2 = 0L;
        PemEncoded pemEncoded = null;
        try {
            pemEncoded = PemX509Certificate.toPEM(UnpooledByteBufAllocator.DEFAULT, true, x509CertificateArray);
            l = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, pemEncoded.retain());
            l2 = SSL.parseX509Chain((long)l);
        }
        catch (Exception exception) {
            throw new SSLException("Certificate type not supported", exception);
        }
        finally {
            SSL.freeBIO((long)l);
            if (l2 != 0L) {
                SSL.freeX509Chain((long)l2);
            }
            if (pemEncoded != null) {
                pemEncoded.release();
            }
        }
    }

    X509KeyManager keyManager() {
        return this.keyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator byteBufAllocator, String string) throws Exception {
        X509Certificate[] x509CertificateArray = this.keyManager.getCertificateChain(string);
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return null;
        }
        PrivateKey privateKey = this.keyManager.getPrivateKey(string);
        PemEncoded pemEncoded = PemX509Certificate.toPEM(byteBufAllocator, true, x509CertificateArray);
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        try {
            OpenSslKeyMaterial openSslKeyMaterial;
            l = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, pemEncoded.retain());
            l3 = SSL.parseX509Chain((long)l);
            if (privateKey instanceof OpenSslPrivateKey) {
                openSslKeyMaterial = ((OpenSslPrivateKey)privateKey).newKeyMaterial(l3, x509CertificateArray);
            } else {
                l2 = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, privateKey);
                l4 = privateKey == null ? 0L : SSL.parsePrivateKey((long)l2, (String)this.password);
                openSslKeyMaterial = new DefaultOpenSslKeyMaterial(l3, l4, x509CertificateArray);
            }
            l3 = 0L;
            l4 = 0L;
            OpenSslKeyMaterial openSslKeyMaterial2 = openSslKeyMaterial;
            return openSslKeyMaterial2;
        }
        finally {
            SSL.freeBIO((long)l);
            SSL.freeBIO((long)l2);
            if (l3 != 0L) {
                SSL.freeX509Chain((long)l3);
            }
            if (l4 != 0L) {
                SSL.freePrivateKey((long)l4);
            }
            pemEncoded.release();
        }
    }

    void destroy() {
    }
}

