/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.io.File;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import pro.gravit.repackage.io.netty.handler.ssl.ApplicationProtocolConfig;
import pro.gravit.repackage.io.netty.handler.ssl.CipherSuiteFilter;
import pro.gravit.repackage.io.netty.handler.ssl.ClientAuth;
import pro.gravit.repackage.io.netty.handler.ssl.IdentityCipherSuiteFilter;
import pro.gravit.repackage.io.netty.handler.ssl.SslContext;
import pro.gravit.repackage.io.netty.handler.ssl.SslContextOption;
import pro.gravit.repackage.io.netty.handler.ssl.SslProvider;
import pro.gravit.repackage.io.netty.handler.ssl.util.KeyManagerFactoryWrapper;
import pro.gravit.repackage.io.netty.handler.ssl.util.TrustManagerFactoryWrapper;
import pro.gravit.repackage.io.netty.util.internal.EmptyArrays;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public final class SslContextBuilder {
    private static final Map.Entry[] EMPTY_ENTRIES = new Map.Entry[0];
    private final boolean forServer;
    private SslProvider provider;
    private Provider sslContextProvider;
    private X509Certificate[] trustCertCollection;
    private TrustManagerFactory trustManagerFactory;
    private X509Certificate[] keyCertChain;
    private PrivateKey key;
    private String keyPassword;
    private KeyManagerFactory keyManagerFactory;
    private Iterable<String> ciphers;
    private CipherSuiteFilter cipherFilter = IdentityCipherSuiteFilter.INSTANCE;
    private ApplicationProtocolConfig apn;
    private long sessionCacheSize;
    private long sessionTimeout;
    private ClientAuth clientAuth = ClientAuth.NONE;
    private String[] protocols;
    private boolean startTls;
    private boolean enableOcsp;
    private String keyStoreType = KeyStore.getDefaultType();
    private final Map<SslContextOption<?>, Object> options = new HashMap();

    public static SslContextBuilder forClient() {
        return new SslContextBuilder(false);
    }

    public static SslContextBuilder forServer(File file, File file2) {
        return new SslContextBuilder(true).keyManager(file, file2);
    }

    public static SslContextBuilder forServer(InputStream inputStream, InputStream inputStream2) {
        return new SslContextBuilder(true).keyManager(inputStream, inputStream2);
    }

    public static SslContextBuilder forServer(PrivateKey privateKey, X509Certificate ... x509CertificateArray) {
        return new SslContextBuilder(true).keyManager(privateKey, x509CertificateArray);
    }

    public static SslContextBuilder forServer(PrivateKey privateKey, Iterable<? extends X509Certificate> iterable) {
        return SslContextBuilder.forServer(privateKey, SslContextBuilder.toArray(iterable, EmptyArrays.EMPTY_X509_CERTIFICATES));
    }

    public static SslContextBuilder forServer(File file, File file2, String string) {
        return new SslContextBuilder(true).keyManager(file, file2, string);
    }

    public static SslContextBuilder forServer(InputStream inputStream, InputStream inputStream2, String string) {
        return new SslContextBuilder(true).keyManager(inputStream, inputStream2, string);
    }

    public static SslContextBuilder forServer(PrivateKey privateKey, String string, X509Certificate ... x509CertificateArray) {
        return new SslContextBuilder(true).keyManager(privateKey, string, x509CertificateArray);
    }

    public static SslContextBuilder forServer(PrivateKey privateKey, String string, Iterable<? extends X509Certificate> iterable) {
        return SslContextBuilder.forServer(privateKey, string, SslContextBuilder.toArray(iterable, EmptyArrays.EMPTY_X509_CERTIFICATES));
    }

    public static SslContextBuilder forServer(KeyManagerFactory keyManagerFactory) {
        return new SslContextBuilder(true).keyManager(keyManagerFactory);
    }

    public static SslContextBuilder forServer(KeyManager keyManager) {
        return new SslContextBuilder(true).keyManager(keyManager);
    }

    private SslContextBuilder(boolean bl) {
        this.forServer = bl;
    }

    public <T> SslContextBuilder option(SslContextOption<T> sslContextOption, T t) {
        if (t == null) {
            this.options.remove(sslContextOption);
        } else {
            this.options.put(sslContextOption, t);
        }
        return this;
    }

    public SslContextBuilder sslProvider(SslProvider sslProvider) {
        this.provider = sslProvider;
        return this;
    }

    public SslContextBuilder keyStoreType(String string) {
        this.keyStoreType = string;
        return this;
    }

    public SslContextBuilder sslContextProvider(Provider provider) {
        this.sslContextProvider = provider;
        return this;
    }

    public SslContextBuilder trustManager(File file) {
        try {
            return this.trustManager(SslContext.toX509Certificates(file));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("File does not contain valid certificates: " + file, exception);
        }
    }

    public SslContextBuilder trustManager(InputStream inputStream) {
        try {
            return this.trustManager(SslContext.toX509Certificates(inputStream));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Input stream does not contain valid certificates.", exception);
        }
    }

    public SslContextBuilder trustManager(X509Certificate ... x509CertificateArray) {
        this.trustCertCollection = x509CertificateArray != null ? (X509Certificate[])x509CertificateArray.clone() : null;
        this.trustManagerFactory = null;
        return this;
    }

    public SslContextBuilder trustManager(Iterable<? extends X509Certificate> iterable) {
        return this.trustManager(SslContextBuilder.toArray(iterable, EmptyArrays.EMPTY_X509_CERTIFICATES));
    }

    public SslContextBuilder trustManager(TrustManagerFactory trustManagerFactory) {
        this.trustCertCollection = null;
        this.trustManagerFactory = trustManagerFactory;
        return this;
    }

    public SslContextBuilder trustManager(TrustManager trustManager) {
        this.trustManagerFactory = trustManager != null ? new TrustManagerFactoryWrapper(trustManager) : null;
        this.trustCertCollection = null;
        return this;
    }

    public SslContextBuilder keyManager(File file, File file2) {
        return this.keyManager(file, file2, null);
    }

    public SslContextBuilder keyManager(InputStream inputStream, InputStream inputStream2) {
        return this.keyManager(inputStream, inputStream2, null);
    }

    public SslContextBuilder keyManager(PrivateKey privateKey, X509Certificate ... x509CertificateArray) {
        return this.keyManager(privateKey, (String)null, x509CertificateArray);
    }

    public SslContextBuilder keyManager(PrivateKey privateKey, Iterable<? extends X509Certificate> iterable) {
        return this.keyManager(privateKey, SslContextBuilder.toArray(iterable, EmptyArrays.EMPTY_X509_CERTIFICATES));
    }

    public SslContextBuilder keyManager(File file, File file2, String string) {
        PrivateKey privateKey;
        X509Certificate[] x509CertificateArray;
        try {
            x509CertificateArray = SslContext.toX509Certificates(file);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("File does not contain valid certificates: " + file, exception);
        }
        try {
            privateKey = SslContext.toPrivateKey(file2, string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("File does not contain valid private key: " + file2, exception);
        }
        return this.keyManager(privateKey, string, x509CertificateArray);
    }

    public SslContextBuilder keyManager(InputStream inputStream, InputStream inputStream2, String string) {
        PrivateKey privateKey;
        X509Certificate[] x509CertificateArray;
        try {
            x509CertificateArray = SslContext.toX509Certificates(inputStream);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Input stream not contain valid certificates.", exception);
        }
        try {
            privateKey = SslContext.toPrivateKey(inputStream2, string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Input stream does not contain valid private key.", exception);
        }
        return this.keyManager(privateKey, string, x509CertificateArray);
    }

    public SslContextBuilder keyManager(PrivateKey privateKey, String string, X509Certificate ... x509CertificateArray) {
        if (this.forServer) {
            ObjectUtil.checkNonEmpty(x509CertificateArray, "keyCertChain");
            ObjectUtil.checkNotNull(privateKey, "key required for servers");
        }
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            this.keyCertChain = null;
        } else {
            for (X509Certificate x509Certificate : x509CertificateArray) {
                ObjectUtil.checkNotNullWithIAE(x509Certificate, "cert");
            }
            this.keyCertChain = (X509Certificate[])x509CertificateArray.clone();
        }
        this.key = privateKey;
        this.keyPassword = string;
        this.keyManagerFactory = null;
        return this;
    }

    public SslContextBuilder keyManager(PrivateKey privateKey, String string, Iterable<? extends X509Certificate> iterable) {
        return this.keyManager(privateKey, string, SslContextBuilder.toArray(iterable, EmptyArrays.EMPTY_X509_CERTIFICATES));
    }

    public SslContextBuilder keyManager(KeyManagerFactory keyManagerFactory) {
        if (this.forServer) {
            ObjectUtil.checkNotNull(keyManagerFactory, "keyManagerFactory required for servers");
        }
        this.keyCertChain = null;
        this.key = null;
        this.keyPassword = null;
        this.keyManagerFactory = keyManagerFactory;
        return this;
    }

    public SslContextBuilder keyManager(KeyManager keyManager) {
        if (this.forServer) {
            ObjectUtil.checkNotNull(keyManager, "keyManager required for servers");
        }
        this.keyManagerFactory = keyManager != null ? new KeyManagerFactoryWrapper(keyManager) : null;
        this.keyCertChain = null;
        this.key = null;
        this.keyPassword = null;
        return this;
    }

    public SslContextBuilder ciphers(Iterable<String> iterable) {
        return this.ciphers(iterable, IdentityCipherSuiteFilter.INSTANCE);
    }

    public SslContextBuilder ciphers(Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter) {
        this.cipherFilter = ObjectUtil.checkNotNull(cipherSuiteFilter, "cipherFilter");
        this.ciphers = iterable;
        return this;
    }

    public SslContextBuilder applicationProtocolConfig(ApplicationProtocolConfig applicationProtocolConfig) {
        this.apn = applicationProtocolConfig;
        return this;
    }

    public SslContextBuilder sessionCacheSize(long l) {
        this.sessionCacheSize = l;
        return this;
    }

    public SslContextBuilder sessionTimeout(long l) {
        this.sessionTimeout = l;
        return this;
    }

    public SslContextBuilder clientAuth(ClientAuth clientAuth) {
        this.clientAuth = ObjectUtil.checkNotNull(clientAuth, "clientAuth");
        return this;
    }

    public SslContextBuilder protocols(String ... stringArray) {
        this.protocols = stringArray == null ? null : (String[])stringArray.clone();
        return this;
    }

    public SslContextBuilder protocols(Iterable<String> iterable) {
        return this.protocols(SslContextBuilder.toArray(iterable, EmptyArrays.EMPTY_STRINGS));
    }

    public SslContextBuilder startTls(boolean bl) {
        this.startTls = bl;
        return this;
    }

    public SslContextBuilder enableOcsp(boolean bl) {
        this.enableOcsp = bl;
        return this;
    }

    public SslContext build() throws SSLException {
        if (this.forServer) {
            return SslContext.newServerContextInternal(this.provider, this.sslContextProvider, this.trustCertCollection, this.trustManagerFactory, this.keyCertChain, this.key, this.keyPassword, this.keyManagerFactory, this.ciphers, this.cipherFilter, this.apn, this.sessionCacheSize, this.sessionTimeout, this.clientAuth, this.protocols, this.startTls, this.enableOcsp, this.keyStoreType, SslContextBuilder.toArray(this.options.entrySet(), EMPTY_ENTRIES));
        }
        return SslContext.newClientContextInternal(this.provider, this.sslContextProvider, this.trustCertCollection, this.trustManagerFactory, this.keyCertChain, this.key, this.keyPassword, this.keyManagerFactory, this.ciphers, this.cipherFilter, this.apn, this.protocols, this.sessionCacheSize, this.sessionTimeout, this.enableOcsp, this.keyStoreType, SslContextBuilder.toArray(this.options.entrySet(), EMPTY_ENTRIES));
    }

    private static <T> T[] toArray(Iterable<? extends T> iterable, T[] TArray) {
        if (iterable == null) {
            return null;
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : iterable) {
            arrayList.add(t);
        }
        return arrayList.toArray(TArray);
    }
}

