/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.stream;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.stream.ChunkedInput;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class ChunkedNioStream
implements ChunkedInput<ByteBuf> {
    private final ReadableByteChannel in;
    private final int chunkSize;
    private long offset;
    private final ByteBuffer byteBuffer;

    public ChunkedNioStream(ReadableByteChannel readableByteChannel) {
        this(readableByteChannel, 8192);
    }

    public ChunkedNioStream(ReadableByteChannel readableByteChannel, int n) {
        this.in = ObjectUtil.checkNotNull(readableByteChannel, "in");
        this.chunkSize = ObjectUtil.checkPositive(n, "chunkSize");
        this.byteBuffer = ByteBuffer.allocate(n);
    }

    public long transferredBytes() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        if (this.byteBuffer.position() > 0) {
            return false;
        }
        if (this.in.isOpen()) {
            int n = this.in.read(this.byteBuffer);
            if (n < 0) {
                return true;
            }
            this.offset += (long)n;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws Exception {
        this.in.close();
    }

    @Override
    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext channelHandlerContext) throws Exception {
        return this.readChunk(channelHandlerContext.alloc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf readChunk(ByteBufAllocator byteBufAllocator) throws Exception {
        int n;
        if (this.isEndOfInput()) {
            return null;
        }
        int n2 = this.byteBuffer.position();
        while ((n = this.in.read(this.byteBuffer)) >= 0) {
            this.offset += (long)n;
            if ((n2 += n) != this.chunkSize) continue;
            break;
        }
        this.byteBuffer.flip();
        n = 1;
        ByteBuf byteBuf = byteBufAllocator.buffer(this.byteBuffer.remaining());
        try {
            byteBuf.writeBytes(this.byteBuffer);
            this.byteBuffer.clear();
            n = 0;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        finally {
            if (n != 0) {
                byteBuf.release();
            }
        }
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public long progress() {
        return this.offset;
    }
}

