/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.stream;

import java.io.InputStream;
import java.io.PushbackInputStream;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.stream.ChunkedInput;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class ChunkedStream
implements ChunkedInput<ByteBuf> {
    static final int DEFAULT_CHUNK_SIZE = 8192;
    private final PushbackInputStream in;
    private final int chunkSize;
    private long offset;
    private boolean closed;

    public ChunkedStream(InputStream inputStream) {
        this(inputStream, 8192);
    }

    public ChunkedStream(InputStream inputStream, int n) {
        ObjectUtil.checkNotNull(inputStream, "in");
        ObjectUtil.checkPositive(n, "chunkSize");
        this.in = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream);
        this.chunkSize = n;
    }

    public long transferredBytes() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        if (this.closed) {
            return true;
        }
        if (this.in.available() > 0) {
            return false;
        }
        int n = this.in.read();
        if (n < 0) {
            return true;
        }
        this.in.unread(n);
        return false;
    }

    @Override
    public void close() throws Exception {
        this.closed = true;
        this.in.close();
    }

    @Override
    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext channelHandlerContext) throws Exception {
        return this.readChunk(channelHandlerContext.alloc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf readChunk(ByteBufAllocator byteBufAllocator) throws Exception {
        if (this.isEndOfInput()) {
            return null;
        }
        int n = this.in.available();
        int n2 = n <= 0 ? this.chunkSize : Math.min(this.chunkSize, this.in.available());
        boolean bl = true;
        ByteBuf byteBuf = byteBufAllocator.buffer(n2);
        try {
            int n3 = byteBuf.writeBytes(this.in, n2);
            if (n3 < 0) {
                ByteBuf byteBuf2 = null;
                return byteBuf2;
            }
            this.offset += (long)n3;
            bl = false;
            ByteBuf byteBuf3 = byteBuf;
            return byteBuf3;
        }
        finally {
            if (bl) {
                byteBuf.release();
            }
        }
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public long progress() {
        return this.offset;
    }
}

