/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.resolver;

import java.util.Arrays;
import java.util.List;
import pro.gravit.repackage.io.netty.resolver.NameResolver;
import pro.gravit.repackage.io.netty.resolver.SimpleNameResolver;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.concurrent.FutureListener;
import pro.gravit.repackage.io.netty.util.concurrent.Promise;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public final class CompositeNameResolver<T>
extends SimpleNameResolver<T> {
    private final NameResolver<T>[] resolvers;

    public CompositeNameResolver(EventExecutor eventExecutor, NameResolver<T> ... nameResolverArray) {
        super(eventExecutor);
        ObjectUtil.checkNotNull(nameResolverArray, "resolvers");
        for (int i = 0; i < nameResolverArray.length; ++i) {
            ObjectUtil.checkNotNull(nameResolverArray[i], "resolvers[" + i + ']');
        }
        if (nameResolverArray.length < 2) {
            throw new IllegalArgumentException("resolvers: " + Arrays.asList(nameResolverArray) + " (expected: at least 2 resolvers)");
        }
        this.resolvers = (NameResolver[])nameResolverArray.clone();
    }

    @Override
    protected void doResolve(String string, Promise<T> promise) throws Exception {
        this.doResolveRec(string, promise, 0, null);
    }

    private void doResolveRec(final String string, final Promise<T> promise, final int n, Throwable throwable) throws Exception {
        if (n >= this.resolvers.length) {
            promise.setFailure(throwable);
        } else {
            NameResolver<T> nameResolver = this.resolvers[n];
            nameResolver.resolve(string).addListener(new FutureListener<T>(){

                @Override
                public void operationComplete(Future<T> future) throws Exception {
                    if (future.isSuccess()) {
                        promise.setSuccess(future.getNow());
                    } else {
                        CompositeNameResolver.this.doResolveRec(string, promise, n + 1, future.cause());
                    }
                }
            });
        }
    }

    @Override
    protected void doResolveAll(String string, Promise<List<T>> promise) throws Exception {
        this.doResolveAllRec(string, promise, 0, null);
    }

    private void doResolveAllRec(final String string, final Promise<List<T>> promise, final int n, Throwable throwable) throws Exception {
        if (n >= this.resolvers.length) {
            promise.setFailure(throwable);
        } else {
            NameResolver<T> nameResolver = this.resolvers[n];
            nameResolver.resolveAll(string).addListener(new FutureListener<List<T>>(){

                @Override
                public void operationComplete(Future<List<T>> future) throws Exception {
                    if (future.isSuccess()) {
                        promise.setSuccess(future.getNow());
                    } else {
                        CompositeNameResolver.this.doResolveAllRec(string, promise, n + 1, future.cause());
                    }
                }
            });
        }
    }
}

