/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.internal.logging;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogLevel;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;

class Log4J2Logger
extends ExtendedLoggerWrapper
implements InternalLogger {
    private static final long serialVersionUID = 5485418394879791397L;
    private static final boolean VARARGS_ONLY = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                Logger.class.getMethod("debug", String.class, Object.class);
                return false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return true;
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
    });

    Log4J2Logger(Logger logger) {
        super((ExtendedLogger)logger, logger.getName(), logger.getMessageFactory());
        if (VARARGS_ONLY) {
            throw new UnsupportedOperationException("Log4J2 version mismatch");
        }
    }

    @Override
    public String name() {
        return this.getName();
    }

    @Override
    public void trace(Throwable throwable) {
        this.log(Level.TRACE, "Unexpected exception:", throwable);
    }

    @Override
    public void debug(Throwable throwable) {
        this.log(Level.DEBUG, "Unexpected exception:", throwable);
    }

    @Override
    public void info(Throwable throwable) {
        this.log(Level.INFO, "Unexpected exception:", throwable);
    }

    @Override
    public void warn(Throwable throwable) {
        this.log(Level.WARN, "Unexpected exception:", throwable);
    }

    @Override
    public void error(Throwable throwable) {
        this.log(Level.ERROR, "Unexpected exception:", throwable);
    }

    @Override
    public boolean isEnabled(InternalLogLevel internalLogLevel) {
        return this.isEnabled(Log4J2Logger.toLevel(internalLogLevel));
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, String string) {
        this.log(Log4J2Logger.toLevel(internalLogLevel), string);
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, String string, Object object) {
        this.log(Log4J2Logger.toLevel(internalLogLevel), string, object);
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, String string, Object object, Object object2) {
        this.log(Log4J2Logger.toLevel(internalLogLevel), string, object, object2);
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, String string, Object ... objectArray) {
        this.log(Log4J2Logger.toLevel(internalLogLevel), string, objectArray);
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, String string, Throwable throwable) {
        this.log(Log4J2Logger.toLevel(internalLogLevel), string, throwable);
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, Throwable throwable) {
        this.log(Log4J2Logger.toLevel(internalLogLevel), "Unexpected exception:", throwable);
    }

    private static Level toLevel(InternalLogLevel internalLogLevel) {
        switch (internalLogLevel) {
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case TRACE: {
                return Level.TRACE;
            }
        }
        throw new Error();
    }
}

