/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues;

import java.util.Iterator;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.BaseLinkedQueuePad2;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.LinkedQueueNode;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import pro.gravit.repackage.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;

abstract class BaseLinkedQueue<E>
extends BaseLinkedQueuePad2<E> {
    BaseLinkedQueue() {
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    protected final LinkedQueueNode<E> newNode() {
        return new LinkedQueueNode();
    }

    protected final LinkedQueueNode<E> newNode(E e) {
        return new LinkedQueueNode<E>(e);
    }

    @Override
    public final int size() {
        int n;
        LinkedQueueNode linkedQueueNode = this.lvConsumerNode();
        LinkedQueueNode linkedQueueNode2 = this.lvProducerNode();
        for (n = 0; linkedQueueNode != linkedQueueNode2 && linkedQueueNode != null && n < Integer.MAX_VALUE; ++n) {
            LinkedQueueNode linkedQueueNode3 = linkedQueueNode.lvNext();
            if (linkedQueueNode3 == linkedQueueNode) {
                return n;
            }
            linkedQueueNode = linkedQueueNode3;
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        LinkedQueueNode linkedQueueNode;
        LinkedQueueNode linkedQueueNode2 = this.lvConsumerNode();
        return linkedQueueNode2 == (linkedQueueNode = this.lvProducerNode());
    }

    protected E getSingleConsumerNodeValue(LinkedQueueNode<E> linkedQueueNode, LinkedQueueNode<E> linkedQueueNode2) {
        E e = linkedQueueNode2.getAndNullValue();
        linkedQueueNode.soNext(linkedQueueNode);
        this.spConsumerNode(linkedQueueNode2);
        return e;
    }

    @Override
    public E poll() {
        LinkedQueueNode linkedQueueNode = this.lpConsumerNode();
        LinkedQueueNode linkedQueueNode2 = linkedQueueNode.lvNext();
        if (linkedQueueNode2 != null) {
            return this.getSingleConsumerNodeValue(linkedQueueNode, linkedQueueNode2);
        }
        if (linkedQueueNode != this.lvProducerNode()) {
            linkedQueueNode2 = this.spinWaitForNextNode(linkedQueueNode);
            return this.getSingleConsumerNodeValue(linkedQueueNode, linkedQueueNode2);
        }
        return null;
    }

    @Override
    public E peek() {
        LinkedQueueNode linkedQueueNode = this.lpConsumerNode();
        LinkedQueueNode linkedQueueNode2 = linkedQueueNode.lvNext();
        if (linkedQueueNode2 != null) {
            return linkedQueueNode2.lpValue();
        }
        if (linkedQueueNode != this.lvProducerNode()) {
            linkedQueueNode2 = this.spinWaitForNextNode(linkedQueueNode);
            return linkedQueueNode2.lpValue();
        }
        return null;
    }

    LinkedQueueNode<E> spinWaitForNextNode(LinkedQueueNode<E> linkedQueueNode) {
        LinkedQueueNode<E> linkedQueueNode2;
        while ((linkedQueueNode2 = linkedQueueNode.lvNext()) == null) {
        }
        return linkedQueueNode2;
    }

    @Override
    public E relaxedPoll() {
        LinkedQueueNode linkedQueueNode = this.lpConsumerNode();
        LinkedQueueNode linkedQueueNode2 = linkedQueueNode.lvNext();
        if (linkedQueueNode2 != null) {
            return this.getSingleConsumerNodeValue(linkedQueueNode, linkedQueueNode2);
        }
        return null;
    }

    @Override
    public E relaxedPeek() {
        LinkedQueueNode linkedQueueNode = this.lpConsumerNode().lvNext();
        if (linkedQueueNode != null) {
            return linkedQueueNode.lpValue();
        }
        return null;
    }

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n) {
        if (null == consumer) {
            throw new IllegalArgumentException("c is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative: " + n);
        }
        if (n == 0) {
            return 0;
        }
        LinkedQueueNode linkedQueueNode = this.lpConsumerNode();
        for (int i = 0; i < n; ++i) {
            LinkedQueueNode linkedQueueNode2 = linkedQueueNode.lvNext();
            if (linkedQueueNode2 == null) {
                return i;
            }
            Object e = this.getSingleConsumerNodeValue(linkedQueueNode, linkedQueueNode2);
            linkedQueueNode = linkedQueueNode2;
            consumer.accept(e);
        }
        return n;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer) {
        return MessagePassingQueueUtil.drain(this, consumer);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.drain(this, consumer, waitStrategy, exitCondition);
    }

    @Override
    public int capacity() {
        return -1;
    }
}

